create or replace
PACKAGE UTILS AS
SQLSERVER           VARCHAR2(10)  := 'SQLSERVER';
SYBASE              VARCHAR2(10)  := 'SYBASE';
DATABASE_TYPE       VARCHAR2(10)  := SYBASE;

IDENTITY   NUMBER(10);
TRANCOUNT  NUMBER(10):=0;
VAR_NUMBER NUMBER(10):=0;

FUNCTION BIGINTTOHEX(P_EXPR NUMBER) RETURN VARCHAR2;
FUNCTION BIGINTTOHEX(P_EXPR RAW)    RETURN VARCHAR2;

FUNCTION BIT_XOR(P_RAW1 RAW   ,P_RAW2 RAW)    RETURN RAW;
FUNCTION BIT_XOR(P_NUM1 NUMBER,P_NUM2 NUMBER) RETURN NUMBER;

FUNCTION BIT_OR(P_RAW1 RAW    ,P_RAW2 RAW)    RETURN RAW;
FUNCTION BIT_OR(P_NUM1 NUMBER ,P_NUM2 NUMBER) RETURN NUMBER;

FUNCTION BIT_AND(P_RAW1 RAW   ,P_RAW2 RAW)    RETURN RAW;
FUNCTION BIT_AND(P_NUM1 NUMBER,P_NUM2 NUMBER) RETURN NUMBER;

FUNCTION BIT_COMPLIMENT(P_RAW1 RAW )    RETURN RAW;
FUNCTION BIT_COMPLIMENT(P_NUM1 NUMBER) RETURN NUMBER;

FUNCTION CONVERT_TO_BLOB    (P_EXPR IN VARCHAR2                 ,P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0     ,P_STYLE IN NUMBER DEFAULT 0) RETURN BLOB;
FUNCTION CONVERT_TO_BLOB    (P_EXPR IN NUMBER                   ,P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0     ,P_STYLE IN NUMBER DEFAULT 0) RETURN BLOB;

FUNCTION CONVERT_TO_DATE	  (P_EXPR IN TIMESTAMP WITH TIME ZONE	, P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN DATE;
FUNCTION CONVERT_TO_DATE	  (P_EXPR IN TIMESTAMP	              , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN DATE;
FUNCTION CONVERT_TO_DATE	  (P_EXPR IN DATE	                    , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN DATE;
FUNCTION CONVERT_TO_DATE	  (P_EXPR IN VARCHAR2	                , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN DATE;

FUNCTION CONVERT_TO_TIMESTAMP	      (P_EXPR IN VARCHAR2	                 , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN TIMESTAMP;
FUNCTION CONVERT_TO_TIMESTAMP	      (P_EXPR IN DATE	                     , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN TIMESTAMP;
FUNCTION CONVERT_TO_TIMESTAMP	      (P_EXPR IN TIMESTAMP	               , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN TIMESTAMP;
FUNCTION CONVERT_TO_TIMESTAMP	      (P_EXPR IN TIMESTAMP WITH TIME ZONE	 , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN TIMESTAMP;

FUNCTION CONVERT_TO_TIMESTAMP_TZ	  (P_EXPR IN VARCHAR2	                 , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN TIMESTAMP WITH TIME ZONE;
FUNCTION CONVERT_TO_TIMESTAMP_TZ	  (P_EXPR IN DATE	                     , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN TIMESTAMP WITH TIME ZONE;
FUNCTION CONVERT_TO_TIMESTAMP_TZ	  (P_EXPR IN TIMESTAMP	               , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN TIMESTAMP WITH TIME ZONE;
FUNCTION CONVERT_TO_TIMESTAMP_TZ	  (P_EXPR IN TIMESTAMP WITH TIME ZONE	 , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN TIMESTAMP WITH TIME ZONE;

FUNCTION CONVERT_TO_NUMBER	(P_EXPR IN VARCHAR2	                , P_PRECISION IN NUMBER DEFAULT NULL, P_SCALE IN NUMBER DEFAULT NULL, P_STYLE IN NUMBER DEFAULT NULL) RETURN NUMBER;
FUNCTION CONVERT_TO_NUMBER	(P_EXPR IN NUMBER  	                , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN NUMBER;
FUNCTION CONVERT_TO_NUMBER  (P_BLOB_EXPR IN BLOB                     , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT NULL, P_STYLE IN NUMBER DEFAULT NULL) RETURN NUMBER;

FUNCTION CONVERT_TO_FLOAT	  (P_EXPR IN VARCHAR2	                , P_PRECISION IN NUMBER DEFAULT NULL, P_SCALE IN NUMBER DEFAULT NULL, P_STYLE IN NUMBER DEFAULT NULL) RETURN FLOAT;
FUNCTION CONVERT_TO_FLOAT	  (P_EXPR IN NUMBER  	                , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN FLOAT;
FUNCTION CONVERT_TO_FLOAT	  (P_EXPR IN FLOAT  	                , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN FLOAT;

FUNCTION CONVERT_TO_VARCHAR2	(P_EXPR IN VARCHAR2	                , P_PRECISION IN NUMBER DEFAULT NULL, P_SCALE IN NUMBER DEFAULT NULL, P_STYLE IN NUMBER DEFAULT NULL) RETURN VARCHAR2;
FUNCTION CONVERT_TO_VARCHAR2	(P_EXPR IN NUMBER  	                , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN VARCHAR2;
FUNCTION CONVERT_TO_VARCHAR2	(P_EXPR IN DATE		                  , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN VARCHAR2;
FUNCTION CONVERT_TO_VARCHAR2	(P_EXPR IN TIMESTAMP		            , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN VARCHAR2;
FUNCTION CONVERT_TO_VARCHAR2	(P_EXPR IN TIMESTAMP WITH TIME ZONE	, P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN VARCHAR2;
FUNCTION CONVERT_TO_VARCHAR2  (P_EXPR IN BLOB                     , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT 0)    RETURN VARCHAR2;

FUNCTION CONVERT_TO_NVARCHAR2	(P_EXPR IN VARCHAR2	                , P_PRECISION IN NUMBER DEFAULT NULL, P_SCALE IN NUMBER DEFAULT NULL, P_STYLE IN NUMBER DEFAULT NULL) RETURN NVARCHAR2;
FUNCTION CONVERT_TO_NVARCHAR2	(P_EXPR IN NUMBER  	                , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN NVARCHAR2;
FUNCTION CONVERT_TO_NVARCHAR2	(P_EXPR IN DATE		                  , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN NVARCHAR2;
FUNCTION CONVERT_TO_NVARCHAR2	(P_EXPR IN TIMESTAMP		            , P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN NVARCHAR2;
FUNCTION CONVERT_TO_NVARCHAR2	(P_EXPR IN TIMESTAMP WITH TIME ZONE	, P_PRECISION IN NUMBER DEFAULT 0   , P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN NVARCHAR2;

FUNCTION CONVERT_TO_CHAR	(P_EXPR IN VARCHAR2	                , P_PRECISION IN NUMBER DEFAULT NULL, P_SCALE IN NUMBER DEFAULT NULL, P_STYLE IN NUMBER DEFAULT NULL) RETURN CHAR;
FUNCTION CONVERT_TO_CHAR	(P_EXPR IN NUMBER  	                , P_PRECISION IN NUMBER DEFAULT NULL, P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN CHAR;
FUNCTION CONVERT_TO_CHAR	(P_EXPR IN DATE		                  , P_PRECISION IN NUMBER DEFAULT NULL, P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN CHAR;
FUNCTION CONVERT_TO_CHAR	(P_EXPR IN TIMESTAMP		            , P_PRECISION IN NUMBER DEFAULT NULL, P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN CHAR;
FUNCTION CONVERT_TO_CHAR	(P_EXPR IN TIMESTAMP WITH TIME ZONE	, P_PRECISION IN NUMBER DEFAULT NULL, P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN CHAR;

FUNCTION CONVERT_TO_CLOB	(P_EXPR IN CLOB	                    , P_PRECISION IN NUMBER DEFAULT 4000, P_SCALE IN NUMBER DEFAULT NULL, P_STYLE IN NUMBER DEFAULT NULL) RETURN CLOB;
FUNCTION CONVERT_TO_CLOB	(P_EXPR IN VARCHAR2	                , P_PRECISION IN NUMBER DEFAULT 4000, P_SCALE IN NUMBER DEFAULT NULL, P_STYLE IN NUMBER DEFAULT NULL) RETURN CLOB;
FUNCTION CONVERT_TO_CLOB	(P_EXPR IN NUMBER  	                , P_PRECISION IN NUMBER DEFAULT 4000, P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN CLOB;
FUNCTION CONVERT_TO_CLOB	(P_EXPR IN DATE		                  , P_PRECISION IN NUMBER DEFAULT NULL, P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN CLOB;
FUNCTION CONVERT_TO_CLOB	(P_EXPR IN TIMESTAMP		            , P_PRECISION IN NUMBER DEFAULT NULL, P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN CLOB;
FUNCTION CONVERT_TO_CLOB	(P_EXPR IN TIMESTAMP WITH TIME ZONE	, P_PRECISION IN NUMBER DEFAULT NULL, P_SCALE IN NUMBER DEFAULT 0   , P_STYLE IN NUMBER DEFAULT NULL) RETURN CLOB;

FUNCTION DATENAME(P_PART_EXPR IN VARCHAR2, P_DATE_STR IN VARCHAR2)  RETURN VARCHAR2;
FUNCTION DATENAME(P_PART_EXPR IN VARCHAR2, P_DATE_EXPR IN DATE)  RETURN VARCHAR2;
FUNCTION DATENAME(P_PART_EXPR IN VARCHAR2, P_DATE_EXPR IN TIMESTAMP)  RETURN VARCHAR2;
FUNCTION DATENAME(P_PART_EXPR IN VARCHAR2, P_DATE_EXPR IN TIMESTAMP WITH TIME ZONE)  RETURN VARCHAR2;

FUNCTION DATEPART(P_PART_EXPR IN VARCHAR2, P_DATE_STR IN VARCHAR2)  RETURN NUMBER;
FUNCTION DATEPART(P_PART_EXPR IN VARCHAR2, P_DATE_EXPR IN DATE)  RETURN NUMBER;
FUNCTION DATEPART(P_PART_EXPR IN VARCHAR2, P_DATE_EXPR IN TIMESTAMP)  RETURN NUMBER;
FUNCTION DATEPART(P_PART_EXPR IN VARCHAR2, P_DATE_EXPR IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;

FUNCTION DATEADD(P_INTERVAL IN VARCHAR2, P_INTERVAL_VAL IN NUMBER, P_DATE_STR IN VARCHAR2) RETURN TIMESTAMP;
FUNCTION DATEADD(P_INTERVAL IN VARCHAR2, P_INTERVAL_VAL IN NUMBER, P_DATE_EXPR IN DATE) RETURN DATE;
FUNCTION DATEADD(P_INTERVAL IN VARCHAR2, P_INTERVAL_VAL IN NUMBER, P_DATE_EXPR IN TIMESTAMP) RETURN TIMESTAMP;
FUNCTION DATEADD(P_INTERVAL IN VARCHAR2, P_INTERVAL_VAL IN NUMBER, P_DATE_EXPR IN TIMESTAMP WITH TIME ZONE) RETURN TIMESTAMP WITH TIME ZONE;

FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_STR IN VARCHAR2, P_END_DATE_STR IN VARCHAR2) RETURN NUMBER;
FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_STR IN VARCHAR2, P_END_DATE_EXPR IN DATE) RETURN NUMBER;
FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_STR IN VARCHAR2, P_END_DATE_EXPR IN TIMESTAMP) RETURN NUMBER;
FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_STR IN VARCHAR2, P_END_DATE_EXPR IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;

FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_EXPR IN DATE, P_END_DATE_EXPR IN DATE) RETURN NUMBER;
FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_EXPR IN DATE, P_END_DATE_STR IN VARCHAR2) RETURN NUMBER;
FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_EXPR IN DATE, P_END_DATE_EXPR IN TIMESTAMP) RETURN NUMBER;
FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_EXPR IN DATE, P_END_DATE_EXPR IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;

FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_EXPR IN TIMESTAMP, P_END_DATE_EXPR IN TIMESTAMP) RETURN NUMBER;
FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_EXPR IN TIMESTAMP, P_END_DATE_EXPR IN DATE) RETURN NUMBER;
FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_EXPR IN TIMESTAMP, P_END_DATE_STR IN VARCHAR2) RETURN NUMBER;
FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_EXPR IN TIMESTAMP, P_END_DATE_EXPR IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;

FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_EXPR IN TIMESTAMP WITH TIME ZONE, P_END_DATE_EXPR IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_EXPR IN TIMESTAMP WITH TIME ZONE, P_END_DATE_EXPR IN TIMESTAMP) RETURN NUMBER;
FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_EXPR IN TIMESTAMP WITH TIME ZONE, P_END_DATE_EXPR IN DATE) RETURN NUMBER;
FUNCTION DATEDIFF(P_DATEPART IN VARCHAR2, P_START_DATE_EXPR IN TIMESTAMP WITH TIME ZONE, P_END_DATE_STR IN VARCHAR2) RETURN NUMBER;

FUNCTION YEAR_(P_DATE_STR    IN VARCHAR2) RETURN NUMBER;
FUNCTION YEAR_(P_DATE_EXPR   IN DATE) RETURN NUMBER;
FUNCTION YEAR_(P_DATE_EXPR   IN TIMESTAMP) RETURN NUMBER;
FUNCTION YEAR_(P_DATE_EXPR   IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;

FUNCTION MONTH_(P_DATE_STR  IN VARCHAR2) RETURN NUMBER;
FUNCTION MONTH_(P_DATE_EXPR  IN DATE) RETURN NUMBER;
FUNCTION MONTH_(P_DATE_EXPR  IN TIMESTAMP) RETURN NUMBER;
FUNCTION MONTH_(P_DATE_EXPR  IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;

FUNCTION DAY_(P_DATE_STR    IN VARCHAR2) RETURN NUMBER;
FUNCTION DAY_(P_DATE_EXPR    IN DATE) RETURN NUMBER;
FUNCTION DAY_(P_DATE_EXPR    IN TIMESTAMP) RETURN NUMBER;
FUNCTION DAY_(P_DATE_EXPR    IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;

FUNCTION STUFF(P_EXPR VARCHAR2, P_STARTIDX NUMBER, P_LEN NUMBER, P_REPLACE_EXPR VARCHAR2)  RETURN VARCHAR2;
FUNCTION REVERSE_(P_EXPR IN VARCHAR2)                                                      RETURN VARCHAR2;
FUNCTION QUOTENAME(P_STR IN VARCHAR2, P_DELIMITERS IN VARCHAR2 DEFAULT '[]')               RETURN VARCHAR2;
FUNCTION PARSENAME(P_OBJECT_NAME IN VARCHAR2, P_OBJECT_PIECE IN NUMBER)                    RETURN VARCHAR2;
FUNCTION DIFFERENCE(P_EXPR1 IN VARCHAR2, P_EXPR2 IN VARCHAR2)                              RETURN NUMBER;
FUNCTION PATINDEX(P_PATTERN IN VARCHAR2, P_EXPR IN VARCHAR2, P_FORMAT IN VARCHAR2 DEFAULT 'USING CHARS') RETURN NUMBER;
 
--NOTE THESE ALL NEED TO BE OVERRIDDEN WITH TIMESTAMP,TIMESTAMP TZ AND DATE DATA TYPES . LETS TEST REST FIRST
FUNCTION STATS_DATE(P_TABLE IN VARCHAR2,  P_INDEX IN VARCHAR2) RETURN DATE;

FUNCTION ISDATE(P_EXPR      IN VARCHAR2) RETURN NUMBER;
FUNCTION ISNUMERIC(P_EXPR IN VARCHAR2)       RETURN NUMBER;
FUNCTION DEGREES(P_ANGLE_RADIANS IN NUMBER)  RETURN NUMBER;
FUNCTION RADIANS(P_DEGREE IN NUMBER)         RETURN NUMBER;
FUNCTION ROUND_(P_EXPR NUMBER, P_LEN NUMBER, P_FUNCTION NUMBER DEFAULT 0)  RETURN NUMBER;
FUNCTION RAND(P_SEED NUMBER DEFAULT NULL)    RETURN NUMBER;
FUNCTION OCT(P_NUM VARCHAR2)                 RETURN VARCHAR2;
FUNCTION HEX(P_NUM VARCHAR2)                 RETURN VARCHAR2;
FUNCTION TO_BASE(P_DEC NUMBER, P_BASE NUMBER)RETURN VARCHAR2;

FUNCTION STR(P_EXPR IN NUMBER, P_LEN IN NUMBER DEFAULT 10, P_SCALE IN NUMBER DEFAULT 0)  RETURN VARCHAR2;
FUNCTION PI RETURN NUMBER;

PROCEDURE COMMIT_TRANSACTION;
PROCEDURE RESETTRANCOUNT;
PROCEDURE DECREMENTTRANCOUNT;
PROCEDURE INCREMENTTRANCOUNT;
FUNCTION GETIDENTITY RETURN NUMBER;
FUNCTION IDENT_INCR(P_SEQUENCE IN VARCHAR2)     RETURN NUMBER;
FUNCTION FETCH_STATUS(P_CURSORFOUND IN BOOLEAN) RETURN NUMBER;
FUNCTION SQLSTATUS(P_CURSORFOUND IN BOOLEAN,P_CURSOROPEN IN BOOLEAN) RETURN NUMBER;
FUNCTION IDENT_SEED(P_SEQUENCE IN VARCHAR2) RETURN NUMBER;

PROCEDURE SET_DATABASE_TYPE (P_DATABASE_TYPE IN VARCHAR2);

END UTILS;