REM Copyright (c) 2012, Oracle and/or its affiliates. 
REM All rights reserved. 

create or replace package sybase_tsql_translator as

  procedure translate_sql(sql_text              in  clob,
                          translated_text       out clob);

  procedure translate_error(error_code          in  binary_integer,
                            translated_code     out binary_integer,
                            translated_sqlstate out varchar2);

end;
/

create or replace package body sybase_tsql_translator as

  function translate_sql(sql_text              in  clob,
                          translated_text       out clob)  return boolean as
  language java
  name 'oracle.dbtools.babelfish.sybase.SybaseTSQLTranslator.translateSQL(oracle.sql.CLOB,oracle.sql.CLOB[]) return boolean';

  function translate_error(error_code          in  binary_integer,
                            translated_code     out binary_integer,
                            translated_sqlstate out varchar2)  return boolean as
  language java
  name 'oracle.dbtools.babelfish.sybase.SybaseTSQLTranslator.translateError(int,int[],java.lang.String[]) return boolean';

  procedure translate_sql(sql_text              in  clob,
                          translated_text       out clob) as
  begin
    if (not translate_sql(sql_text, translated_text)) then
      raise dbms_sql_translator.no_translation_found;
    end if;
  end;

  procedure translate_error(error_code          in  binary_integer,
                            translated_code     out binary_integer,
                            translated_sqlstate out varchar2) as
  begin
    if (not translate_error(error_code,
                            translated_code,
                            translated_sqlstate)) then
      raise dbms_sql_translator.no_translation_found;
    end if;
  end;
  
end;
/
EXIT
