#! /bin/sh
# @(#)startDump.bat
#
# Copyright 2009, 2010 by Oracle Corporation,
# 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
# All rights reserved.
#
# This software is the confidential and proprietary information
# of Oracle Corporation. 
 
OCP_FILE=teradata.ocp

ERROR_CONDITION="N"
if [[ "$1" = "" ]]; then 
   ERROR_CONDITION="Y"
fi
if [[ "$2" = "" ]]; then 
   ERROR_CONDITION="Y"
fi
if [[ "$3" = "" ]]; then 
   ERROR_CONDITION="Y"   
fi

if [[ $ERROR_CONDITION = "Y" ]]; then
    echo Usage:
    echo "startDump.sh <user> <password> <host>"
else

    SEED=$$

    ZIP_FILES=$OCP_FILE
    echo OfflinePluginIdentifier=oracle.dbtools.migration.workbench.plugin.Teradata13Plugin> $OCP_FILE
    echo SEED=$SEED >> $OCP_FILE
    echo OCP_FILE=$OCP_FILE >> $OCP_FILE
    echo VERSION_FILE=version.txt >> $OCP_FILE
    echo SCHEMAS_FILE=schemas.txt >> $OCP_FILE
    echo TABLES_FILE=tables.txt >> $OCP_FILE
    echo INDEXES_FILE=indexes.txt >> $OCP_FILE
    echo INDEXDETAILS_FILE=indexdetails.txt >> $OCP_FILE
    echo VIEWDEFN_FILE=viewdefns.txt >> $OCP_FILE
    echo VIEWS_FILE=views.txt >> $OCP_FILE
    echo TRIGGERS_FILE=triggers.txt >> $OCP_FILE
    echo PROCS_FILE=procedures.txt >> $OCP_FILE
    echo PKEY_FILE=primarykey.txt >> $OCP_FILE
    echo FKEY_FILE=foreignkey.txt >> $OCP_FILE
    echo CHECK_FILE=check.txt >> $OCP_FILE
    echo INDCONSTR_FILE=indconstr.txt >> %OCP_FILE%

    ZIP_FILES=version.txt schemas.txt tables.txt indexes.txt indexdetails.txt viewdefns.txt views.txt triggers.txt procedures.txt primarykey.txt foreignkey.txt check.txt indconstr.txt

    \rm -i $ZIP_FILES

    bteq .logon $3/$1,$2 < extract.bteq

    \rm -i dump.zip
    zip dump $ZIP_FILES $OCP_FILE

    echo Processing completed - files generated for Teradata Offline

fi
