/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Customization;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.ref.CachedStatementProfile;
import sqlj.runtime.profile.ref.IterConvertProfile;
import sqlj.runtime.profile.ref.JDBCProfile;
import sqlj.runtime.profile.ref.ParamRegProfile;
import sqlj.runtime.profile.ref.PositionedProfile;
import sqlj.runtime.profile.ref.ProfileDataImpl;
import sqlj.runtime.profile.ref.TransactionControlProfile;
import sqlj.runtime.profile.ref.UntypedSelectProfile;

public class ProfileImpl
extends Profile {
    private String m_profileName;
    private String m_contextName;
    private long m_timestamp;
    private Vector m_customizations = new Vector();
    private ProfileData m_profileData;
    static final long serialVersionUID = -2161640844900440703L;

    public ProfileImpl(String string, String string2, EntryInfo[] entryInfoArray, Loader loader, String string3) {
        super(loader);
        this.m_profileName = string;
        this.m_contextName = string2;
        this.m_timestamp = System.currentTimeMillis();
        this.m_profileData = new ProfileDataImpl(entryInfoArray, this, string3);
    }

    public String getProfileName() {
        return this.m_profileName;
    }

    public String getContextName() {
        return this.m_contextName;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public ProfileData getProfileData() {
        return this.m_profileData;
    }

    public ConnectedProfile getConnectedProfile(ConnectionContext connectionContext) throws SQLException {
        Connection connection = connectionContext.getConnection();
        Enumeration enumeration = this.getCustomizations();
        while (enumeration.hasMoreElements()) {
            Customization customization = (Customization)enumeration.nextElement();
            if (!customization.acceptsConnection(connection)) continue;
            return customization.getProfile(connectionContext, this);
        }
        return ProfileImpl.getDefaultProfile(connectionContext, this.getProfileData());
    }

    public static ConnectedProfile getDefaultProfile(ConnectionContext connectionContext, ProfileData profileData) {
        return ProfileImpl.getDefaultCachedProfile(connectionContext, profileData);
    }

    public static CachedStatementProfile getDefaultCachedProfile(ConnectionContext connectionContext, ProfileData profileData) {
        return new TransactionControlProfile(new PositionedProfile(new ParamRegProfile(new UntypedSelectProfile(new IterConvertProfile(new JDBCProfile(connectionContext, profileData))))));
    }

    public void registerCustomization(Customization customization) {
        if (customization == null) {
            throw new NullPointerException();
        }
        this.m_customizations.addElement(customization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCustomization(Customization customization, Customization customization2) {
        if (customization == null) {
            throw new NullPointerException();
        }
        Vector vector = this.m_customizations;
        synchronized (vector) {
            int n = this.m_customizations.indexOf(customization2);
            if (n == -1) {
                throw new IllegalArgumentException(customization2 + "");
            }
            this.m_customizations.insertElementAt(customization, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceCustomization(Customization customization, Customization customization2) {
        if (customization == null) {
            throw new NullPointerException();
        }
        Vector vector = this.m_customizations;
        synchronized (vector) {
            int n = this.m_customizations.indexOf(customization2);
            if (n == -1) {
                throw new IllegalArgumentException(customization2 + "");
            }
            this.m_customizations.setElementAt(customization, n);
        }
    }

    public void deregisterCustomization(Customization customization) {
        if (!this.m_customizations.removeElement(customization)) {
            throw new IllegalArgumentException(customization + "");
        }
    }

    public Enumeration getCustomizations() {
        return this.m_customizations.elements();
    }
}

