/*
 * Decompiled with CFR 0.152.
 */
package oracle.sqlj.runtime;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import oracle.sqlj.runtime.OraConsts;
import oracle.sqlj.runtime.OraEntryInfo;
import oracle.sqlj.runtime.OraProfile;
import oracle.sqlj.runtime.OraRTStatement;
import oracle.sqlj.runtime.OraTypeClosure;
import oracle.sqlj.runtime.OraTypeInfo;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.CharacterStream;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.RTCallableStatement;
import sqlj.runtime.ref.ResultSetIterImpl;

public class IBMWrappedRTStmt
extends OraRTStatement
implements OraConsts,
RTCallableStatement {
    private OraEntryInfo m_oraEntry;
    private EntryInfo m_entry;
    private OraProfile m_profile;
    protected PreparedStatement m_oPreparedStmt;
    protected CallableStatement m_oCallableStmt;
    private RTCallableStatement m_cstmt;
    private boolean m_isNativeSQL;
    private boolean m_definesToDo;
    private int m_index;
    private boolean m_isBatch;
    private IBMWrappedBatchContext m_oBatchContext = null;
    private Command m_command;
    private Method m_jdbccall = null;
    private Object[] m_jdbccallargs = null;
    private Object[] m_onefuncarg;
    private Class[] m_onefuncargtype;
    private Object[] m_twofuncarg;
    private Class[] m_twofuncargtype;
    private Object[] m_threefuncarg;
    private Class[] m_threefuncargtype;
    private Object[] m_fourfuncarg;
    private Class[] m_fourfuncargtype;
    public static long elapsed_time = 0L;
    static final int DEFINE = -28197;
    static final int SET_FIXED_CHAR = -28198;
    static final int SET_CHARACTER_STREAM = -28199;
    private static boolean m_inJServer = IBMWrappedRTStmt.initInJserver();
    public static final String runtimeVersion = "9.2.0/90/12/030709";

    public IBMWrappedRTStmt(RTStatement rTStatement, OraEntryInfo oraEntryInfo, OraProfile oraProfile, boolean bl, int n) throws SQLException {
        super(rTStatement, oraEntryInfo, oraProfile, bl, n);
        this.m_oraEntry = oraEntryInfo;
        this.m_entry = oraEntryInfo.getEntryInfo();
        this.m_profile = oraProfile;
        this.m_isNativeSQL = bl;
        this.m_index = n;
        this.m_isBatch = false;
        Command command = this.m_command = this.m_entry.getMetaBinds() != null ? new Command() : null;
        if (rTStatement != null) {
            this.setWrappedStatement(rTStatement);
        }
        this.m_definesToDo = true;
        this.m_onefuncarg = new Object[1];
        this.m_twofuncarg = new Object[2];
        this.m_threefuncarg = new Object[3];
        this.m_fourfuncarg = new Object[4];
        this.m_onefuncargtype = new Class[1];
        this.m_twofuncargtype = new Class[2];
        this.m_threefuncargtype = new Class[3];
        this.m_fourfuncargtype = new Class[4];
    }

    Object callWSCallHelper(Class clazz, Object object, String string, Object[] objectArray, Class[] classArray) {
        try {
            if (this.m_jdbccall == null) {
                Date date = new Date();
                Class<?> clazz2 = Class.forName("com.ibm.websphere.rsadapter.WSCallHelper");
                Class[] classArray2 = new Class[]{Class.class, Object.class, String.class, Object[].class, Class[].class};
                this.m_jdbccall = clazz2.getMethod("jdbcCall", classArray2);
                this.m_jdbccallargs = new Object[5];
                Date date2 = new Date();
                System.out.println(elapsed_time += date2.getTime() - date.getTime());
            }
            this.m_jdbccallargs[0] = clazz;
            this.m_jdbccallargs[1] = object;
            this.m_jdbccallargs[2] = string;
            this.m_jdbccallargs[3] = objectArray;
            this.m_jdbccallargs[4] = classArray;
            return this.m_jdbccall.invoke(null, this.m_jdbccallargs);
        }
        catch (Exception exception) {
            return null;
        }
    }

    void setWrappedStatement(RTStatement rTStatement) throws SQLException {
        this.stmt = rTStatement;
        if (this.m_entry.getStatementType() == 4) {
            this.m_cstmt = (RTCallableStatement)this.stmt;
            this.m_oCallableStmt = this.stmt.getJDBCCallableStatement();
            this.resetStatementState(this.m_oCallableStmt);
        } else {
            this.resetStatementState(this.stmt.getJDBCPreparedStatement());
        }
    }

    private void setDynamicStatement(RTStatement rTStatement) throws SQLException {
        if (this.m_entry.getStatementType() == 4) {
            this.m_cstmt = (RTCallableStatement)this.stmt;
            if (this.m_oCallableStmt == null) {
                this.m_oCallableStmt = this.stmt.getJDBCCallableStatement();
            }
        }
        if (this.m_oPreparedStmt == null) {
            this.m_oPreparedStmt = this.stmt.getJDBCPreparedStatement();
        }
    }

    private void resetStatementState(PreparedStatement preparedStatement) throws SQLException {
        if (preparedStatement != this.m_oPreparedStmt) {
            this.m_oPreparedStmt = preparedStatement;
            this.m_oPreparedStmt.setEscapeProcessing(!this.m_isNativeSQL);
        }
    }

    boolean doDefines() {
        return this.m_definesToDo;
    }

    int getIndex() {
        return this.m_index;
    }

    void setBatch(boolean bl) {
        this.m_isBatch = bl;
    }

    boolean isBatch() {
        return this.m_isBatch;
    }

    OraProfile getOraProfile() {
        return this.m_profile;
    }

    RTCallableStatement getRTCallableStatement() {
        return this.m_cstmt;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        OraTypeInfo oraTypeInfo = this.m_oraEntry.getParamInfo(n);
        if (this.m_command != null) {
            if (this.m_command.doReplay) {
                n = (Integer)this.m_entry.getMetaBinds()[n - 1];
            } else {
                this.m_command.set(-23710, n, n2);
                return;
            }
        }
        if (this.doDefines() && oraTypeInfo.getTypeSize() > 0) {
            this.m_oCallableStmt.registerOutParameter(n, n2, 0);
        } else {
            this.m_profile.getTypeClosure(oraTypeInfo).registerParameter(this, n, oraTypeInfo);
        }
    }

    RTResultSet newResultSet(RTResultSet rTResultSet) throws SQLException {
        return this.m_profile.newResultSet(rTResultSet, this.m_oraEntry);
    }

    public boolean execute() throws SQLException {
        if (this.m_command != null) {
            this.setDynamicStatement(super.prepareDynamicStatement());
            this.m_command.replay();
        }
        this.m_definesToDo = false;
        return super.execute();
    }

    public int executeUpdate() throws SQLException {
        if (this.m_command != null) {
            this.setDynamicStatement(super.prepareDynamicStatement());
            this.m_command.replay();
        }
        this.m_definesToDo = false;
        return super.executeUpdate();
    }

    public RTResultSet executeRTQuery() throws SQLException {
        if (this.m_command != null) {
            this.setDynamicStatement(super.prepareDynamicStatement());
            this.m_command.replay();
        }
        if (this.doDefines() && this.m_oraEntry.getColumnDefines() != null) {
            int[] nArray = this.m_oraEntry.getColumnDefines();
            String[] stringArray = this.m_oraEntry.getColumnDefineNames();
        }
        this.m_definesToDo = false;
        return super.executeRTQuery();
    }

    public void executeComplete() throws SQLException {
        if (!this.m_isBatch) {
            super.executeComplete();
        }
    }

    public void setString(int n, String string) throws SQLException {
        if (this.m_definesToDo) {
            this.def(n);
        }
        if (this.m_oraEntry.useFixedChar()) {
            if (this.m_command != null && !this.m_command.doReplay) {
                Object object = this.m_entry.getMetaBinds()[n - 1];
                if (object != null && object instanceof Integer) {
                    this.m_command.set(-28198, (int)((Integer)object), string);
                    return;
                }
                super.setString(n, string);
            } else {
                this.setFixedCHAR(n, string);
            }
        } else {
            super.setString(n, string);
        }
    }

    private void setFixedCHAR(int n, String string) throws SQLException {
        this.m_oPreparedStmt.setObject(n, string);
    }

    private void setCharacterStream(int n, CharacterStream characterStream) throws SQLException {
        this.m_oPreparedStmt.setCharacterStream(n, characterStream.getReader(), characterStream.getLength());
    }

    public void setCharacterStreamWrapper(int n, CharacterStream characterStream) throws SQLException {
        if (this.m_definesToDo) {
            this.def(n);
        }
        super.setCharacterStreamWrapper(n, characterStream);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.m_definesToDo) {
            this.def(n);
        }
        super.setBytes(n, byArray);
    }

    public void setAsciiStreamWrapper(int n, AsciiStream asciiStream) throws SQLException {
        if (this.m_definesToDo) {
            this.def(n);
        }
        super.setAsciiStreamWrapper(n, asciiStream);
    }

    public void setBinaryStreamWrapper(int n, BinaryStream binaryStream) throws SQLException {
        if (this.m_definesToDo) {
            this.def(n);
        }
        super.setBinaryStreamWrapper(n, binaryStream);
    }

    public void setUnicodeStreamWrapper(int n, UnicodeStream unicodeStream) throws SQLException {
        if (this.m_definesToDo) {
            this.def(n);
        }
        super.setUnicodeStreamWrapper(n, unicodeStream);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (this.m_command != null && !this.m_command.doReplay) {
            this.m_command.set(1111, n, object);
            return;
        }
        if (this.m_definesToDo) {
            this.defObject(n);
        }
        OraTypeInfo oraTypeInfo = this.getParamInfo(n);
        OraTypeClosure oraTypeClosure = this.m_profile.getTypeClosure(oraTypeInfo);
        if (this.m_command != null) {
            n = (Integer)this.m_entry.getMetaBinds()[n - 1];
        }
        if (this.m_entry.getRole() == 6 && object instanceof ResultSetIterImpl) {
            ResultSetIterImpl resultSetIterImpl = (ResultSetIterImpl)object;
            object = resultSetIterImpl.getImplicitRowid();
        }
        oraTypeClosure.setObject(this, n, object, oraTypeInfo);
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        OraTypeInfo oraTypeInfo = this.getParamInfo(n);
        OraTypeClosure oraTypeClosure = this.m_profile.getTypeClosure(oraTypeInfo);
        if (this.m_command != null) {
            n = (Integer)this.m_entry.getMetaBinds()[n - 1];
        }
        return oraTypeClosure.getObject(this, n, clazz, oraTypeInfo);
    }

    public OraTypeInfo getParamInfo(int n) {
        return this.m_oraEntry.getParamInfo(n);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.m_command != null) {
            n = (Integer)this.m_entry.getMetaBinds()[n - 1];
        }
        return this.m_oCallableStmt.getBigDecimal(n, 0);
    }

    private void defObject(int n) throws SQLException {
        String string;
        if (this.doDefines() && ((string = this.getParamInfo(n).getTypeInfo().getJavaTypeName()).equals("oracle.sql.NString") || string.equals("oracle.sql.NCHAR") || string.equals("oracle.sql.NCLOB") || string.equals("oracle.sqlj.runtime.NcharAsciiStream") || string.equals("oracle.sqlj.runtime.NcharUnicodeStream"))) {
            int n2 = n;
            if (this.m_command != null) {
                n2 = (Integer)this.m_entry.getMetaBinds()[n2 - 1];
            }
        }
        this.def(n);
    }

    private void def(int n) throws SQLException {
        OraTypeInfo oraTypeInfo = this.getParamInfo(n);
        if (this.doDefines() && oraTypeInfo.getTypeSize() > 0 && this.m_command != null) {
            if (this.m_command.doReplay) {
                n = (Integer)this.m_entry.getMetaBinds()[n - 1];
            } else {
                Object object = this.m_entry.getMetaBinds()[n - 1];
                if (object != null && !(object instanceof String)) {
                    this.m_command.set(-28197, n);
                }
                return;
            }
        }
    }

    public boolean isBatchable() {
        return this.m_oraEntry.isBatchable();
    }

    public boolean isBatchCompatible() throws SQLException {
        BatchContext batchContext = this.getWrappedRTStatement().getBatchContext();
        if (batchContext == null || !(batchContext instanceof IBMWrappedBatchContext)) {
            this.m_oBatchContext = new IBMWrappedBatchContext(this.m_oPreparedStmt, this);
            this.m_isBatch = true;
            return false;
        }
        this.m_oBatchContext = (IBMWrappedBatchContext)batchContext;
        if (this.m_oBatchContext.isBatchCompatible(this.m_oPreparedStmt)) {
            this.m_oBatchContext.addBatch(this.m_oPreparedStmt);
            return true;
        }
        this.m_oBatchContext = new IBMWrappedBatchContext(this.m_oPreparedStmt, this);
        this.m_isBatch = true;
        return false;
    }

    public BatchContext getBatchContext() {
        return this.m_oBatchContext;
    }

    private static int getUnlimitedBatchSize() {
        return Integer.MAX_VALUE;
    }

    static boolean inJServer() {
        return m_inJServer;
    }

    private static boolean initInJserver() {
        try {
            return System.getProperty("oracle.jserver.version") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static /* synthetic */ int access$000() {
        return IBMWrappedRTStmt.getUnlimitedBatchSize();
    }

    protected class Command {
        private Vector m_commands = new Vector();
        private int m_pos = 0;
        public boolean doReplay = false;

        Command() {
        }

        void set(int n, int n2) {
            this.m_commands.addElement(new Integer(n));
            this.m_commands.addElement(new Integer(n2));
        }

        void set(int n, int n2, int n3) {
            this.m_commands.addElement(new Integer(n));
            this.m_commands.addElement(new Integer(n2));
            this.m_commands.addElement(new Integer(n3));
        }

        void set(int n, int n2, Object object) {
            this.m_commands.addElement(new Integer(n));
            this.m_commands.addElement(new Integer(n2));
            this.m_commands.addElement(object);
        }

        void replay() throws SQLException {
            int n;
            this.doReplay = true;
            this.m_pos = 0;
            block9: while ((n = this.nextInt()) != -23700) {
                switch (n) {
                    case -23710: {
                        IBMWrappedRTStmt.this.registerOutParameter(this.nextInt(), this.nextInt());
                        continue block9;
                    }
                    case 1111: {
                        IBMWrappedRTStmt.this.setObject(this.nextInt(), this.nextObject());
                        continue block9;
                    }
                    case -23704: {
                        IBMWrappedRTStmt.this.setFetchSize(this.nextInt());
                        continue block9;
                    }
                    case -23705: {
                        IBMWrappedRTStmt.this.setFetchDirection(this.nextInt());
                        continue block9;
                    }
                    case -28197: {
                        IBMWrappedRTStmt.this.def(this.nextInt());
                        continue block9;
                    }
                    case -28198: {
                        IBMWrappedRTStmt.this.setObject(this.nextInt(), this.nextObject());
                        continue block9;
                    }
                    case -28199: {
                        IBMWrappedRTStmt.this.setCharacterStream(this.nextInt(), (CharacterStream)this.nextObject());
                        continue block9;
                    }
                }
                throw new IllegalArgumentException("Dynamic SQL: illegal command code " + n);
            }
            this.doReplay = false;
        }

        private int nextInt() {
            if (this.m_pos >= this.m_commands.size()) {
                return -23700;
            }
            return (Integer)this.m_commands.elementAt(this.m_pos++);
        }

        private Object nextObject() {
            return this.m_commands.elementAt(this.m_pos++);
        }
    }

    public static class IBMWrappedBatchContext
    implements BatchContext {
        private static int UNLIMITED_BATCH_SIZE = IBMWrappedRTStmt.access$000();
        private static final int JDBC_DEFAULT_BATCH_SIZE = 20;
        private PreparedStatement m_stmt;
        private IBMWrappedRTStmt m_rtstmt;
        private int m_batchLimit;
        private int m_count = 0;

        IBMWrappedBatchContext(PreparedStatement preparedStatement, IBMWrappedRTStmt iBMWrappedRTStmt) throws SQLException {
            this.m_stmt = preparedStatement;
            this.m_rtstmt = iBMWrappedRTStmt;
            this.m_batchLimit = UNLIMITED_BATCH_SIZE;
            this.m_stmt.addBatch();
            ++this.m_count;
        }

        IBMWrappedRTStmt getCachedStatement(OraProfile oraProfile, int n) {
            if (this.m_rtstmt != null && this.m_rtstmt.getOraProfile() == oraProfile && this.m_rtstmt.getIndex() == n && this.m_rtstmt.isBatch() && this.m_count < this.m_batchLimit) {
                return this.m_rtstmt;
            }
            return null;
        }

        boolean isBatchCompatible(PreparedStatement preparedStatement) {
            return this.m_count < this.m_batchLimit && preparedStatement == this.m_stmt;
        }

        void addBatch(PreparedStatement preparedStatement) throws SQLException {
            if (this.m_count >= this.m_batchLimit) {
                this.executeBatch();
            } else if (this.m_stmt != preparedStatement) {
                RuntimeRefErrors.raise_INCOMPATIBLE_BATCH();
            }
            ++this.m_count;
            this.m_stmt.addBatch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] executeBatch() throws SQLException {
            int[] nArray;
            if (this.m_stmt == null) {
                return null;
            }
            try {
                nArray = this.m_stmt.executeBatch();
            }
            finally {
                this.m_stmt = null;
                this.m_count = 0;
                this.m_rtstmt.setBatch(false);
                this.m_rtstmt.executeComplete();
                this.m_rtstmt = null;
            }
            return nArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearBatch() throws SQLException {
            try {
                if (this.m_stmt != null) {
                    this.m_stmt.clearBatch();
                }
            }
            finally {
                this.m_stmt = null;
                this.m_count = 0;
                this.m_rtstmt.setBatch(false);
                this.m_rtstmt.executeComplete();
                this.m_rtstmt = null;
            }
        }

        public void setBatchLimit(int n) throws SQLException {
            if (n == 0) {
                this.m_batchLimit = UNLIMITED_BATCH_SIZE;
            } else if (n == -1) {
                this.m_batchLimit = 20;
            } else if (UNLIMITED_BATCH_SIZE < n) {
                this.m_batchLimit = UNLIMITED_BATCH_SIZE;
            } else if (0 < n) {
                this.m_batchLimit = n;
            } else {
                RuntimeRefErrors.raise_INVALID_BATCH_LIMIT(n);
            }
        }
    }
}

