/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import oracle.ideimpl.persistence.DefaultNameSpace;
import oracle.ideimpl.persistence.PersistenceLogger;

class PackedNameSpace
extends DefaultNameSpace {
    private static final char DEFAULT_DATA_SEPARATOR = '|';
    private static final int SIZE_THREESOLD = 16384;
    private char _dataSeparator;

    public PackedNameSpace(String name, int pindex, int rindex, char dataSeparator) {
        super(name, pindex, rindex);
        this._dataSeparator = dataSeparator;
    }

    public PackedNameSpace(String name, int pindex, int rindex) {
        this(name, pindex, rindex, '|');
    }

    @Override
    public byte[] getRecord(String key) {
        String ckey = key + this._dataSeparator;
        byte[] res = super.getRecord(ckey);
        if (res != null) {
            return res;
        }
        try {
            String rec = this.getStore().getNextKey(this._pindex, this._btreeindex, ckey);
            if (rec == null || !rec.startsWith(ckey)) {
                return null;
            }
            res = this.dataFrom(rec);
            return res;
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to read record " + key, ex);
            return null;
        }
    }

    @Override
    public void putRecord(String key, byte[] data) {
        this.putRecordNoCache(key, data);
    }

    @Override
    public OutputStream putRecordStream(String key) {
        return new watchedByteArrayOutputStream(key);
    }

    @Override
    public InputStream getRecordStream(String key) {
        byte[] res = this.getRecord(key);
        if (res != null) {
            return new ByteArrayInputStream(res);
        }
        return null;
    }

    private void putRecordNoCache(String key, byte[] data) {
        String ckey = key + this._dataSeparator;
        try {
            String rec = this.getStore().getNextKey(this._pindex, this._btreeindex, ckey);
            if (rec != null && rec.startsWith(ckey)) {
                super.delRecord(rec);
            }
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to delete old record " + key, ex);
        }
        if (ckey.length() + data.length > 16384) {
            super.putRecord(ckey, data);
        } else {
            super.putRecord(ckey + PackedNameSpace.encode(data), null);
        }
    }

    @Override
    public void delRecord(String key) {
        String ckey = key + this._dataSeparator;
        try {
            String rec = this.getStore().getNextKey(this._pindex, this._btreeindex, ckey);
            if (rec != null && rec.startsWith(ckey)) {
                super.delRecord(rec);
            }
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to delete record " + key, ex);
        }
    }

    @Override
    public synchronized void flush() {
        super.flush();
    }

    @Override
    public Iterator<String> getKeyIterator(String prefix, boolean ignorecase) {
        return new filterIterator(this.getStore().getKeyIterator(this._pindex, this._btreeindex, prefix, ignorecase));
    }

    @Override
    public Iterator<String> getReverseKeyIterator(String prefix, boolean ignorecase) {
        return new filterIterator(this.getStore().getReverseKeyIterator(this._pindex, this._btreeindex, prefix, ignorecase));
    }

    String keyFrom(String record) {
        return record.substring(0, record.indexOf(this._dataSeparator));
    }

    byte[] dataFrom(String record) {
        return PackedNameSpace.decode(record.substring(record.indexOf(this._dataSeparator) + 1));
    }

    static void encelem(char[] dst, int ofd, byte[] b, int ofs) {
        dst[ofd++] = (char)((b[ofs] >> 1 & 0x7F) + 1);
        dst[ofd++] = (char)(((b[ofs] << 6 & 0x40 | b[++ofs] >> 2 & 0x3F) & 0x7F) + 1);
        dst[ofd++] = (char)(((b[ofs] << 5 & 0x60 | b[++ofs] >> 3 & 0x1F) & 0x7F) + 1);
        dst[ofd++] = (char)(((b[ofs] << 4 & 0x70 | b[++ofs] >> 4 & 0xF) & 0x7F) + 1);
        dst[ofd++] = (char)(((b[ofs] << 3 & 0x78 | b[++ofs] >> 5 & 7) & 0x7F) + 1);
        dst[ofd++] = (char)(((b[ofs] << 2 & 0x7C | b[++ofs] >> 6 & 3) & 0x7F) + 1);
        dst[ofd++] = (char)(((b[ofs] << 1 & 0x7E | b[++ofs] >> 7 & 1) & 0x7F) + 1);
        dst[ofd++] = (char)((b[ofs] & 0x7F) + 1);
    }

    static void decelem(byte[] dst, int ofd, byte[] org, int ofs) {
        dst[ofd] = (byte)(org[ofs] << 1 | org[++ofs] >> 6 & 1);
        dst[++ofd] = (byte)(org[ofs] << 2 | org[++ofs] >> 5 & 3);
        dst[++ofd] = (byte)(org[ofs] << 3 | org[++ofs] >> 4 & 7);
        dst[++ofd] = (byte)(org[ofs] << 4 | org[++ofs] >> 3 & 0xF);
        dst[++ofd] = (byte)(org[ofs] << 5 | org[++ofs] >> 2 & 0x1F);
        dst[++ofd] = (byte)(org[ofs] << 6 | org[++ofs] >> 1 & 0x3F);
        dst[++ofd] = (byte)(org[ofs] << 7 | org[++ofs] & 0x7F);
    }

    public static String encode(byte[] b) {
        int lp = b.length;
        int pad = 64;
        while (lp % 7 != 0) {
            ++lp;
            pad = (byte)(pad + 1);
        }
        char[] res = new char[1 + 8 * (lp / 7)];
        res[0] = (char)(pad + 1);
        int ofd = 1;
        int ofs = 0;
        int lim = b.length - 6;
        while (ofs < lim) {
            PackedNameSpace.encelem(res, ofd, b, ofs);
            ofs += 7;
            ofd += 8;
        }
        int lm = b.length - ofs;
        if (lm != 0) {
            byte[] p = new byte[7];
            int i = 0;
            while (--lm >= 0) {
                p[i++] = b[ofs++];
            }
            while (i < 7) {
                p[i++] = 1;
            }
            PackedNameSpace.encelem(res, ofd, p, 0);
        }
        return new String(res);
    }

    public static byte[] decode(String code) {
        byte[] res;
        byte[] b = new byte[code.length()];
        for (int i = 0; i < code.length(); ++i) {
            b[i] = (byte)(code.charAt(i) - '\u0001');
        }
        int pad = b[0] - 64;
        int lres = 7 * ((b.length - 1) / 8) - pad;
        byte[] rres = res = new byte[lres];
        if (lres < 7) {
            rres = new byte[7];
        }
        int lim = b.length;
        if (pad != 0) {
            PackedNameSpace.decelem(rres, 0, b, lim - 8);
            int i = 0;
            pad = 7 - pad;
            while (pad > 0) {
                res[lres - pad--] = rres[i++];
            }
            lim -= 8;
        }
        int ofd = 0;
        int ofs = 1;
        while (ofs < lim) {
            PackedNameSpace.decelem(res, ofd, b, ofs);
            ofs += 8;
            ofd += 7;
        }
        return res;
    }

    class filterIterator
    implements Iterator<String> {
        Iterator basit;

        filterIterator(Iterator baseiterator) {
            this.basit = baseiterator;
        }

        @Override
        public String next() {
            String rec = (String)this.basit.next();
            return PackedNameSpace.this.keyFrom(rec);
        }

        @Override
        public boolean hasNext() {
            return this.basit.hasNext();
        }

        @Override
        public void remove() {
            this.basit.remove();
        }
    }

    class watchedByteArrayOutputStream
    extends ByteArrayOutputStream {
        String _key;

        public watchedByteArrayOutputStream(String key) {
            this._key = key;
        }

        @Override
        public void close() {
            PackedNameSpace.this.putRecord(this._key, this.toByteArray());
        }
    }
}

