/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

import com.sleepycat.je.log.LogException;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import javax.swing.SwingUtilities;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Ide;
import oracle.ideimpl.persistence.res.Bundle;
import oracle.javatools.dialogs.MessageDialog;

final class OutOfFileHandlesDialog {
    private static final int RECOMMENDED_FILE_HANDLE_LIMIT = 4096;
    @GuardedBy(value="OutOfFileHandlesDialog.class")
    private static boolean hasBeenShown;
    private static final boolean TEST_DIALOG;
    private static Collection<InputStream> testStreams;

    OutOfFileHandlesDialog() {
    }

    public static synchronized void show() {
        if (Ide.getIdeArgs().getCreateUI() && !Boolean.getBoolean("ide.suppress.file.handle.dialog") && !hasBeenShown) {
            hasBeenShown = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String title = Bundle.get("OUT_OF_FILE_HANDLES_TITLE");
                    String message = Bundle.format("OUT_OF_FILE_HANDLES_MESSAGE", Ide.getProgramName(), 4096);
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
                }
            });
        }
    }

    public static boolean isOutOfFileHandlesError(Throwable t) {
        if ((t instanceof LogException || t instanceof FileNotFoundException) && OutOfFileHandlesDialog.hasOutOfFileHandlesMessage(t)) {
            return true;
        }
        Throwable cause = t.getCause();
        return cause == null ? false : OutOfFileHandlesDialog.isOutOfFileHandlesError(cause);
    }

    private static boolean hasOutOfFileHandlesMessage(Throwable t) {
        String message = t.getMessage();
        return message != null && message.contains("(Too many open files)");
    }

    static void startTesting() {
    }

    static void finishTesting() {
    }

    static {
        TEST_DIALOG = Boolean.getBoolean("ide.test.file.handle.dialog");
    }
}

