/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

final class FreePageMap {
    private static final int BYTES_PER_PAGE = 1023;
    private int _minRindex = 0;
    private byte[][] _mainMap = new byte[0][0];
    private boolean[] _dirty = new boolean[0];

    FreePageMap() {
    }

    private void checkPage(int pgnum) {
        if (pgnum >= this._mainMap.length) {
            byte[][] newmap = new byte[pgnum + 1][0];
            boolean[] newdirty = new boolean[pgnum + 1];
            System.arraycopy(this._mainMap, 0, newmap, 0, this._mainMap.length);
            System.arraycopy(this._dirty, 0, newdirty, 0, this._mainMap.length);
            for (int i = 0; i < newmap.length; ++i) {
                byte[] bytes = newmap[i];
                if (bytes.length == 1023) continue;
                newmap[i] = new byte[1023];
                newdirty[i] = true;
            }
            this._mainMap = newmap;
            this._dirty = newdirty;
        }
    }

    void setFree(int index) {
        int rindex = index / 8;
        int rrem = index % 8;
        int pgnum = rindex / 1023;
        int prem = rindex % 1023;
        this.checkPage(pgnum);
        byte[] byArray = this._mainMap[pgnum];
        int n = prem;
        byArray[n] = (byte)(byArray[n] | 1 << rrem);
        this._dirty[pgnum] = true;
        if (rindex < this._minRindex) {
            this._minRindex = rindex;
        }
    }

    boolean isFree(int index) {
        int rindex = index / 8;
        int rrem = index % 8;
        int pgnum = rindex / 1023;
        int prem = rindex % 1023;
        this.checkPage(pgnum);
        return (this._mainMap[pgnum][prem] & 1 << rrem) != 0;
    }

    int getFreePos() {
        int prem = this._minRindex % 1023;
        for (int pgnum = this._minRindex / 1023; pgnum < this._mainMap.length; ++pgnum) {
            while (prem < 1023) {
                byte b = this._mainMap[pgnum][prem];
                if (b != 0) {
                    int res = this._minRindex * 8;
                    byte msk = 1;
                    while ((b & msk) == 0) {
                        ++res;
                        msk = (byte)(msk << 1);
                    }
                    byte[] byArray = this._mainMap[pgnum];
                    int n = prem;
                    byArray[n] = (byte)(byArray[n] & ~msk);
                    this._dirty[pgnum] = true;
                    return res;
                }
                ++prem;
                ++this._minRindex;
            }
            prem = 0;
        }
        return -1;
    }

    int getDirtyIndex() {
        for (int i = 0; i < this._dirty.length; ++i) {
            if (!this._dirty[i]) continue;
            return i;
        }
        return -1;
    }

    void clearDirty(int index) {
        this._dirty[index] = false;
    }

    byte[] getPageDatas(int index) {
        return this._mainMap[index];
    }

    void setPageDatas(int index, byte[] datas, int offset, int len) {
        this.checkPage(index);
        System.arraycopy(datas, offset, this._mainMap[index], 0, len);
        int nrindex = index * 1023;
        if (nrindex < this._minRindex) {
            this._minRindex = nrindex;
        }
    }
}

