/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.TimerTask;
import java.util.logging.Level;
import oracle.ide.persistence.NameSpace;
import oracle.ideimpl.persistence.PersistenceLogger;
import oracle.ideimpl.persistence.StorageFile;
import oracle.javatools.util.NamedTimer;

class DefaultNameSpace
extends NameSpace {
    private static NamedTimer _flushTimer;
    int _pindex;
    int _btreeindex;
    boolean _dirty;
    StorageFile _store;
    private long _autoDelay;
    private TimerTask _flushTask;
    private long _timeLimit;

    DefaultNameSpace(String name, int pindex, int rindex) {
        super(name);
        this._pindex = pindex;
        this._btreeindex = rindex;
        this._dirty = false;
    }

    public static synchronized NamedTimer getFlushTimer() {
        if (_flushTimer == null) {
            _flushTimer = new NamedTimer("Persistence Auto Flusher", 5, true);
        }
        return _flushTimer;
    }

    @Override
    public synchronized void setAutoFlush(long delay) {
        this._autoDelay = delay;
    }

    @Override
    public synchronized void cancelAutoFlush() {
        if (this._flushTask != null) {
            this._flushTask.cancel();
            this._flushTask = null;
            this._autoDelay = 0L;
        }
    }

    protected StorageFile getStore() {
        return this._store;
    }

    @Override
    public Iterator<String> getKeyIterator(String prefix, boolean ignorecase) {
        return this._store.getKeyIterator(this._pindex, this._btreeindex, prefix, ignorecase);
    }

    @Override
    public Iterator<String> getReverseKeyIterator(String prefix, boolean ignorecase) {
        return this._store.getReverseKeyIterator(this._pindex, this._btreeindex, prefix, ignorecase);
    }

    @Override
    public byte[] getRecord(String key) {
        try {
            byte[] res = this._store.getISBytesFromKey(this._pindex, this._btreeindex, key);
            return res;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public byte[] getRecord(String secondaryKeyName, String secondaryKey) {
        throw new UnsupportedOperationException("Secondary keys not supported");
    }

    @Override
    public Collection<byte[]> getRecords(String secondaryKeyName, String secondaryKey) {
        throw new UnsupportedOperationException("Secondary keys not supported");
    }

    @Override
    public String getPrimaryKey(String secondaryKeyName, String secondaryKey) {
        throw new UnsupportedOperationException("Secondary keys not supported");
    }

    @Override
    public Collection<String> getPrimaryKeys(String secondaryKeyName, String secondaryKey) {
        throw new UnsupportedOperationException("Secondary keys not supported");
    }

    @Override
    public OutputStream putRecordStream(String key) {
        return this.putRecordStreamInternal(key);
    }

    private OutputStream putRecordStreamInternal(String key) {
        this.checkDirty();
        try {
            return this._store.getOSFromKey(this._pindex, this._btreeindex, key);
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to write record " + key, ex);
            return null;
        }
    }

    @Override
    public void putRecord(String key, byte[] data) {
        if (data != null && data.length != 0) {
            OutputStream os = this.putRecordStreamInternal(key);
            try {
                os.write(data);
                os.close();
            }
            catch (Exception ex) {}
        } else {
            this.checkDirty();
            try {
                this._store.updateEmptyKey(this._pindex, this._btreeindex, key);
            }
            catch (IOException ex) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to put record " + key, ex);
            }
        }
    }

    @Override
    public boolean checkRecord(String key) {
        try {
            return this._store.checkKey(this._pindex, this._btreeindex, key);
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to check record " + key, ex);
            return false;
        }
    }

    @Override
    public void delRecord(String key) {
        this.checkDirty();
        try {
            this._store.deleteFromKey(this._pindex, this._btreeindex, key);
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to delete record " + key, ex);
        }
    }

    @Override
    public InputStream getRecordStream(String key) {
        try {
            return this._store.getISFromKey(this._pindex, this._btreeindex, key);
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to read record " + key, ex);
            return null;
        }
    }

    @Override
    public synchronized void flush() {
        if (this._dirty) {
            try {
                this._store.decDirty(this._pindex);
            }
            catch (IOException ex) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to mark namespace clean", ex);
            }
        }
        this._flushTask = null;
        this._dirty = false;
    }

    private synchronized void checkDirty() {
        if (this._dirty) {
            if (this._flushTask != null) {
                this._timeLimit = System.currentTimeMillis() + this._autoDelay;
            }
            return;
        }
        if (this._autoDelay != 0L) {
            this._timeLimit = System.currentTimeMillis() + this._autoDelay;
            this._flushTask = new AutoFlusher();
            DefaultNameSpace.getFlushTimer().scheduleAtFixedRate(this._flushTask, this._autoDelay, 1000L);
        }
        try {
            this._store.incDirty(this._pindex);
        }
        catch (IOException ex) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to mark namespace dirty", ex);
        }
        this._dirty = true;
    }

    void checkTree(String mess) throws IOException {
        this._store.checkTree(mess, this._pindex, this._btreeindex);
    }

    void printTree() {
        this._store.printTreePages(this._pindex, this._btreeindex);
    }

    class AutoFlusher
    extends TimerTask {
        AutoFlusher() {
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() > DefaultNameSpace.this._timeLimit) {
                DefaultNameSpace.this.flush();
                this.cancel();
            }
        }
    }
}

