/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.NameSpaceFactory;
import oracle.ide.persistence.SecondaryKeyProvider;
import oracle.ideimpl.persistence.BerkeleyDBEnvironment;
import oracle.javatools.annotations.NotNull;

public final class BerkeleyDBNameSpaceFactory
implements NameSpaceFactory {
    @GuardedBy(value="this")
    @NotNull
    private final Map<String, BerkeleyDBEnvironment> environments = new HashMap<String, BerkeleyDBEnvironment>();

    @Override
    public NameSpace getNameSpace(String location, String name, int type, SecondaryKeyProvider provider) {
        return this.getOrCreateEnvironment(location).getNameSpace(name, provider);
    }

    @Override
    public Iterator<String> getNameSpaceIterator(String location, String prefix, boolean ignorecase) {
        return this.getNameSpaceIteratorImpl(location, prefix, ignorecase, false);
    }

    @Override
    public Iterator<String> getReverseNameSpaceIterator(String location, String prefix, boolean ignorecase) {
        return this.getNameSpaceIteratorImpl(location, prefix, ignorecase, true);
    }

    @Override
    public void deleteNameSpace(String location, String name) {
        this.getOrCreateEnvironment(location).deleteNameSpace(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeStorage(String location) {
        BerkeleyDBEnvironment environment;
        BerkeleyDBNameSpaceFactory berkeleyDBNameSpaceFactory = this;
        synchronized (berkeleyDBNameSpaceFactory) {
            environment = this.environments.remove(location);
        }
        if (environment != null) {
            environment.close();
        }
    }

    @NotNull
    private synchronized BerkeleyDBEnvironment getOrCreateEnvironment(String location) {
        BerkeleyDBEnvironment environment = this.environments.get(location);
        if (environment == null) {
            environment = new BerkeleyDBEnvironment(location);
            this.environments.put(location, environment);
        }
        return environment;
    }

    @Override
    public synchronized void shutdown() {
        for (Map.Entry<String, BerkeleyDBEnvironment> entry : this.environments.entrySet()) {
            entry.getValue().cleanEnvironment(true);
        }
    }

    @NotNull
    private Iterator<String> getNameSpaceIteratorImpl(String location, String prefix, boolean ignorecase, boolean reverse) {
        return this.getOrCreateEnvironment(location).getNameSpaceIterator(prefix, ignorecase, reverse);
    }
}

