/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.SecondaryKeyProvider;
import oracle.ide.persistence.Storage;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.util.NullArgumentException;

public final class Storages {
    @GuardedBy(value="itself")
    private static final WeakHashMap<Project, WeakReference<ProjectStorage>> PROJECT_STORAGES = new WeakHashMap();
    private static final Collection<ProjectStorage> LOCKED_PROJECT_STORAGES = Collections.synchronizedSet(new HashSet());
    private static final String PROJECT_OUTPUT_DIRECTORY = "oracle.jdevimpl.config.JProjectPaths/outputDirectory";
    private static final String STORAGE_DIRECTORY_NAME = ".data";
    private static final Logger LOGGER = Logger.getLogger(Storages.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Storage getProjectStorage(@NotNull Project project) {
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        WeakHashMap<Project, WeakReference<ProjectStorage>> weakHashMap = PROJECT_STORAGES;
        synchronized (weakHashMap) {
            ProjectStorage storage = null;
            WeakReference<ProjectStorage> ref = PROJECT_STORAGES.get(project);
            if (ref != null) {
                storage = (ProjectStorage)ref.get();
            }
            if (storage == null) {
                storage = new ProjectStorage(project);
                PROJECT_STORAGES.put(project, new WeakReference<ProjectStorage>(storage));
            }
            return storage;
        }
    }

    private Storages() {
    }

    private static final class ProjectStorage
    extends AbstractStorage {
        private final Project project;
        @GuardedBy(value="this")
        private int openCount;
        @GuardedBy(value="this")
        private String location;
        @GuardedBy(value="this")
        private URL baseURL;
        @GuardedBy(value="this")
        private final Collection<Thread> lockThreads = new HashSet<Thread>(3);

        public ProjectStorage(Project project) {
            this.project = project;
        }

        @Override
        public synchronized boolean isOpen() {
            return this.openCount > 0;
        }

        @Override
        public synchronized void open() {
            while (!this.lockThreads.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.openCount++ == 0) {
                LOGGER.fine("Opening project storage for " + this.getProjectString());
                this.openImpl();
            }
        }

        @Override
        public synchronized void close() {
            if (this.openCount <= 0) {
                throw new IllegalStateException("Mismatched open/close on project storage for " + this.getProjectString());
            }
            if (--this.openCount == 0) {
                LOGGER.fine("Closing project storage for " + this.getProjectString());
                NameSpace.closeStorage(this.location);
                this.notifyAll();
                this.location = null;
            }
        }

        @Override
        public synchronized void lockClosed() {
            if (this.lockThreads.isEmpty()) {
                LOGGER.finer("Locking project storage for " + this.getProjectString());
            }
            this.lockThreads.add(Thread.currentThread());
            LOCKED_PROJECT_STORAGES.add(this);
            while (this.openCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public synchronized void allowOpen() {
            if (!this.lockThreads.contains(Thread.currentThread())) {
                throw new IllegalStateException("Unmatched call to allowOpen for " + this.getProjectString());
            }
            LOCKED_PROJECT_STORAGES.remove(this);
            this.lockThreads.remove(Thread.currentThread());
            if (this.lockThreads.isEmpty()) {
                LOGGER.finer("Unlocking project storage for " + this.getProjectString());
                this.notifyAll();
            }
        }

        @Override
        public synchronized String getRelativePath(URL url) {
            if (url == null) {
                throw new NullArgumentException("null url");
            }
            this.checkOpen();
            return this.baseURL == null ? url.toString() : URLFileSystem.toRelativeSpec((URL)url, (URL)this.baseURL, (boolean)false);
        }

        @Override
        public synchronized URL getURL(String relativePath) {
            if (relativePath == null) {
                throw new NullArgumentException("null relative path");
            }
            this.checkOpen();
            return this.baseURL == null ? URLFactory.newURL((String)relativePath) : URLFactory.newURL((URL)this.baseURL, (String)relativePath);
        }

        @Override
        public synchronized NameSpace getNameSpace(String name, SecondaryKeyProvider secondaryKeyProvider) {
            if (name == null) {
                throw new NullArgumentException("null name");
            }
            if (secondaryKeyProvider == null) {
                throw new NullArgumentException("null secondary key provider");
            }
            this.checkOpen();
            return this.location == null ? NameSpace.getNameSpace(this.getSharedNameSpaceName(name), secondaryKeyProvider) : NameSpace.getLocalNameSpace(this.location, name, secondaryKeyProvider);
        }

        @Override
        public synchronized NameSpace getNameSpace(String name, int type) {
            if (name == null) {
                throw new NullArgumentException("null name");
            }
            if (type != 1 && type != 0) {
                throw new IllegalArgumentException("invalid type");
            }
            this.checkOpen();
            return this.location == null ? NameSpace.getNameSpace(this.getSharedNameSpaceName(name), type) : NameSpace.getLocalNameSpace(this.location, name, type);
        }

        @Override
        public synchronized void deleteNameSpace(String name) {
            if (name == null) {
                throw new NullArgumentException("null name");
            }
            this.checkOpen();
            if (this.location == null) {
                NameSpace.deleteNameSpace(this.getSharedNameSpaceName(name));
            } else {
                NameSpace.deleteLocalNameSpace(this.location, name);
            }
        }

        private URL getOutputDirectory(Project project) {
            return project.getProperties().getURL(Storages.PROJECT_OUTPUT_DIRECTORY);
        }

        private void openImpl() {
            URL outputDirectory = this.getOutputDirectory(this.project);
            if (outputDirectory != null) {
                if ("file".equals(outputDirectory.getProtocol())) {
                    URL storageDir = URLFactory.newDirURL((URL)outputDirectory, (String)Storages.STORAGE_DIRECTORY_NAME);
                    String path = storageDir.getPath();
                    File file = new File(path);
                    if (file.exists()) {
                        if (file.canWrite()) {
                            this.baseURL = outputDirectory;
                            this.location = path;
                            return;
                        }
                        LOGGER.fine("Storage directory exists in output directory but is not writable for " + this.getProjectString());
                    } else {
                        if (file.mkdirs()) {
                            this.baseURL = outputDirectory;
                            this.location = path;
                            return;
                        }
                        LOGGER.fine("Unable to create storage directory in project output directory for " + this.getProjectString());
                    }
                } else {
                    LOGGER.fine("Output directory not a file URL for " + this.getProjectString());
                }
            }
            this.baseURL = null;
            this.location = null;
        }

        private String getProjectString() {
            return URLFileSystem.getPlatformPathName((URL)this.project.getURL());
        }

        private synchronized void checkOpen() {
            if (this.openCount == 0) {
                throw new IllegalStateException("Project storage not open for " + this.getProjectString());
            }
        }

        private String getSharedNameSpaceName(String name) {
            return this.project.getURL().toExternalForm() + "-" + name;
        }
    }

    private static abstract class AbstractStorage
    implements Storage {
        private AbstractStorage() {
        }

        @Override
        public NameSpace getNameSpace(String name) {
            return this.getNameSpace(name, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runWhileOpen(Runnable r) {
            if (r == null) {
                throw new NullArgumentException("null Runnable");
            }
            this.open();
            try {
                r.run();
            }
            finally {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T runWhileOpen(Callable<T> c) throws Exception {
            if (c == null) {
                throw new NullArgumentException("null Callable");
            }
            this.open();
            try {
                T t = c.call();
                return t;
            }
            finally {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runWhileClosed(Runnable r) {
            if (r == null) {
                throw new NullArgumentException("null Runnable");
            }
            this.lockClosed();
            try {
                r.run();
            }
            finally {
                this.allowOpen();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T runWhileClosed(Callable<T> c) throws Exception {
            if (c == null) {
                throw new NullArgumentException("null Callable");
            }
            this.lockClosed();
            try {
                T t = c.call();
                return t;
            }
            finally {
                this.allowOpen();
            }
        }
    }
}

