/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.Ide;
import oracle.ide.persistence.NameSpaceFactory;
import oracle.ide.persistence.SecondaryKeyProvider;
import oracle.ideimpl.persistence.BerkeleyDBNameSpaceFactory;
import oracle.ideimpl.persistence.DefaultNameSpaceFactory;
import oracle.ideimpl.persistence.PersistenceLogger;

public abstract class NameSpace {
    public static final int NSTYPE_NORMAL = 0;
    public static final int NSTYPE_PACKED = 1;
    private static final String DEFSTOREDIR = "oracle.javatools.cache";
    private static volatile NameSpaceFactory _factory;
    protected final String _name;

    public static void setNameSpaceFactory(NameSpaceFactory factory) {
        _factory = factory;
    }

    public static NameSpaceFactory getNameSpaceFactory() {
        return _factory;
    }

    private static String getDefaultLocation() {
        String persistenceDirectory = System.getProperty("persistence.directory");
        if (persistenceDirectory == null) {
            persistenceDirectory = Ide.getSystemDirectory();
        }
        return persistenceDirectory + DEFSTOREDIR;
    }

    public static Iterator<String> getNameSpaceIterator() {
        return NameSpace.getNameSpaceIterator("", false);
    }

    public static Iterator<String> getReverseNameSpaceIterator() {
        return NameSpace.getReverseNameSpaceIterator("", false);
    }

    public static Iterator<String> getNameSpaceIterator(String prefix) {
        return NameSpace.getNameSpaceIterator(prefix, false);
    }

    public static Iterator<String> getReverseNameSpaceIterator(String prefix) {
        return NameSpace.getReverseNameSpaceIterator(prefix, false);
    }

    public static Iterator<String> getNameSpaceIterator(String prefix, boolean ignorecase) {
        return NameSpace.getLocalNameSpaceIterator(NameSpace.getDefaultLocation(), prefix, ignorecase);
    }

    public static Iterator<String> getReverseNameSpaceIterator(String prefix, boolean ignorecase) {
        return NameSpace.getLocalReverseNameSpaceIterator(NameSpace.getDefaultLocation(), prefix, ignorecase);
    }

    public static Iterator<String> getLocalNameSpaceIterator(String location, String prefix, boolean ignorecase) {
        return _factory.getNameSpaceIterator(location, prefix, ignorecase);
    }

    public static Iterator<String> getLocalReverseNameSpaceIterator(String location, String prefix, boolean ignorecase) {
        return _factory.getReverseNameSpaceIterator(location, prefix, ignorecase);
    }

    public static NameSpace getNameSpace(String name) {
        return NameSpace.getNameSpace(name, 0);
    }

    public static NameSpace getNameSpace(String name, int type) {
        return NameSpace.getLocalNameSpace(NameSpace.getDefaultLocation(), name, type);
    }

    public static NameSpace getNameSpace(String name, SecondaryKeyProvider provider) {
        return NameSpace.getLocalNameSpace(NameSpace.getDefaultLocation(), name, provider);
    }

    public static NameSpace getLocalNameSpace(String location, String name) {
        return NameSpace.getLocalNameSpace(location, name, 0);
    }

    public static NameSpace getLocalNameSpace(String location, String name, int type) {
        return NameSpace.getLocalNameSpace(location, name, type, null);
    }

    public static NameSpace getLocalNameSpace(String location, String name, SecondaryKeyProvider provider) {
        return NameSpace.getLocalNameSpace(location, name, 0, provider);
    }

    public static NameSpace getLocalNameSpace(String location, String name, int type, SecondaryKeyProvider provider) {
        return _factory.getNameSpace(location, name, type, provider);
    }

    @Deprecated
    public static void clearStorage(String location) {
        NameSpace.closeStorage(location);
    }

    public static void closeStorage(String location) {
        _factory.closeStorage(location);
    }

    public static void deleteNameSpace(String name) {
        NameSpace.deleteLocalNameSpace(NameSpace.getDefaultLocation(), name);
    }

    public static void deleteLocalNameSpace(String location, String name) {
        _factory.deleteNameSpace(location, name);
    }

    public NameSpace(String name) {
        this._name = name;
    }

    public abstract InputStream getRecordStream(String var1);

    public abstract void setAutoFlush(long var1);

    public abstract void cancelAutoFlush();

    public abstract byte[] getRecord(String var1);

    public abstract byte[] getRecord(String var1, String var2);

    public abstract Collection<byte[]> getRecords(String var1, String var2);

    public abstract String getPrimaryKey(String var1, String var2);

    public abstract Collection<String> getPrimaryKeys(String var1, String var2);

    public abstract void flush();

    public void close() {
        this.flush();
    }

    public abstract void delRecord(String var1);

    public abstract OutputStream putRecordStream(String var1);

    public abstract boolean checkRecord(String var1);

    public abstract void putRecord(String var1, byte[] var2);

    public Iterator<String> getKeyIterator() {
        return this.getKeyIterator("", false);
    }

    public Iterator<String> getReverseKeyIterator() {
        return this.getReverseKeyIterator("", false);
    }

    public Iterator<String> getKeyIterator(String prefix) {
        return this.getKeyIterator(prefix, false);
    }

    public Iterator<String> getReverseKeyIterator(String prefix) {
        return this.getReverseKeyIterator(prefix, false);
    }

    public abstract Iterator<String> getKeyIterator(String var1, boolean var2);

    public abstract Iterator<String> getReverseKeyIterator(String var1, boolean var2);

    public String getName() {
        return this._name;
    }

    static {
        String property = System.getProperty("ide.persistence.use.berkeley.db", "true");
        if (Boolean.parseBoolean(property)) {
            PersistenceLogger.getLogger().config("Using Berkeley DB for persistence");
            _factory = new BerkeleyDBNameSpaceFactory();
        } else {
            _factory = new DefaultNameSpaceFactory();
        }
    }
}

