/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector.layout;

import java.lang.reflect.Constructor;
import oracle.ide.inspector.layout.Element;
import oracle.ideimpl.inspector.layout.DefaultCategoryLayout;
import oracle.ideimpl.inspector.layout.DefaultChoice;
import oracle.ideimpl.inspector.layout.DefaultChoiceGroup;
import oracle.ideimpl.inspector.layout.DefaultCustomComponent;
import oracle.ideimpl.inspector.layout.DefaultDisplayGroup;
import oracle.ideimpl.inspector.layout.DefaultProperty;
import oracle.ideimpl.inspector.layout.DefaultPropertyFormLayout;
import oracle.ideimpl.inspector.layout.DefaultRow;
import oracle.ideimpl.inspector.layout.DefaultSpring;
import oracle.javatools.data.HashStructure;

public final class DefaultElementFactory {
    public static Element createElement(String elementName, HashStructure hash) {
        for (ElementTypes elementType : ElementTypes.values()) {
            if (!elementType.getName().equals(elementName)) continue;
            try {
                Constructor constructor = elementType.getType().getConstructor(HashStructure.class);
                return (Element)constructor.newInstance(hash);
            }
            catch (Exception e) {
                break;
            }
        }
        return null;
    }

    private DefaultElementFactory() {
    }

    private static enum ElementTypes {
        PROPERTY_FORM_LAYOUT("property-form-layout", DefaultPropertyFormLayout.class),
        CATEGORY_LAYOUT("category-layout", DefaultCategoryLayout.class),
        DISPLAY_GROUP("display-group", DefaultDisplayGroup.class),
        CHOICE_GROUP("choice-group", DefaultChoiceGroup.class),
        CHOICE("choice", DefaultChoice.class),
        COMPONENT("component", DefaultCustomComponent.class),
        ROW("row", DefaultRow.class),
        PROPERTY("property", DefaultProperty.class),
        SPRING("spring", DefaultSpring.class);

        private final String _name;
        private final Class _type;

        private ElementTypes(String name, Class type) {
            this._name = name;
            this._type = type;
        }

        String getName() {
            return this._name;
        }

        Class getType() {
            return this._type;
        }
    }
}

