/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.SwingUtilities;
import oracle.ide.inspector.ContextActionPanelHost;
import oracle.ide.inspector.CustomEditorButton;

public class PopupManager
implements AWTEventListener {
    private static final PopupManager INSTANCE = new PopupManager();

    public static void install() {
        final Toolkit tk = Toolkit.getDefaultToolkit();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                tk.addAWTEventListener(INSTANCE, 16L);
                return null;
            }
        });
    }

    @Override
    public void eventDispatched(AWTEvent ev) {
        if (!(ev instanceof MouseEvent)) {
            return;
        }
        MouseEvent me = (MouseEvent)ev;
        Component src = me.getComponent();
        switch (me.getID()) {
            case 501: {
                Window w = SwingUtilities.getWindowAncestor(src);
                if (w instanceof ContextActionPanelHost) break;
                CustomEditorButton.hidePopup();
            }
        }
    }

    private PopupManager() {
    }
}

