/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.SAXManifestParser;
import javax.ide.util.MetaClass;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.FormLayoutFactory;
import oracle.ide.inspector.layout.PropertyFormLayout;
import oracle.ide.inspector.layout.PropertyFormLayoutAssembly;
import oracle.ideimpl.inspector.layout.DefaultPropertyFormLayout;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class PIHook
extends HashStructureHook
implements FormLayoutFactory {
    public static final String PROPERTY_FORM_LAYOUTS = "property-form-layouts";
    public static final String INSPECTABLE_FACTORIES = "inspectable-factories";
    public static final String INSPECTABLE_FACTORY = "inspectable-factory";
    public static final String INSPECTABLE_FACTORY_CLASS = "class";
    private static final ElementName PI_HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "property-inspector-hook");
    private Map<String, Map<String, HashStructure>> _extensibleElementsMap;
    private static final List EXTENSIBLE_ELEMENTS = Arrays.asList("category-layout", "display-group", "choice", "choice-group");

    public static PIHook getPIHook() {
        return (PIHook)javax.ide.extension.ExtensionRegistry.getExtensionRegistry().getHook(PI_HOOK_NAME);
    }

    public PIHook() {
        super(true);
    }

    @Override
    public PropertyFormLayout createPropertyFormLayout(PropertyModel propertyModel) {
        List<HashStructure> layouts = this.getPropertyFormLayoutList();
        ArrayList<Element> layoutsToReturn = new ArrayList<Element>();
        for (HashStructure layout : layouts) {
            String pmClass = layout.getString("property-model-class");
            if (pmClass == null || !pmClass.equals(propertyModel.getClass().getName())) continue;
            layoutsToReturn.add(new DefaultPropertyFormLayout(layout));
        }
        if (layoutsToReturn.isEmpty()) {
            return null;
        }
        if (layoutsToReturn.size() == 1) {
            return (PropertyFormLayout)layoutsToReturn.get(0);
        }
        return new PropertyFormLayoutAssembly(layoutsToReturn);
    }

    public List<MetaClass> getInspectableFactories() {
        List<HashStructure> providers = this.getInspectableFactoriesList();
        ArrayList<MetaClass> classes = new ArrayList<MetaClass>();
        ArrayList<String> addedClasses = new ArrayList<String>();
        for (HashStructure provider : providers) {
            List metaClasses = provider.getAsList(INSPECTABLE_FACTORY);
            if (metaClasses == null) continue;
            for (int i = 0; i < metaClasses.size(); ++i) {
                String metaClassName;
                HashStructure hash = (HashStructure)metaClasses.get(i);
                MetaClass mclass = LazyClassAdapter.getInstance((HashStructure)hash).getMetaClass(INSPECTABLE_FACTORY_CLASS);
                if (mclass == null || addedClasses.contains(metaClassName = mclass.getClassName())) continue;
                classes.add(mclass);
                addedClasses.add(metaClassName);
            }
        }
        return classes;
    }

    public HashStructure getExtensibleElement(String id, String elementName) {
        Map<String, HashStructure> map;
        if (ModelUtil.hasLength((String)id) && ModelUtil.hasLength((String)elementName) && (map = this.getExtensibleElementsMap().get(elementName)) != null) {
            return map.get(id);
        }
        return null;
    }

    public void processExternalInspectorHook(InputSource source, String extensionID, String rsBundleClassName) {
        this.processExternalInspectorHook(null, source, extensionID, rsBundleClassName);
    }

    public void processExternalInspectorHook(XMLReader reader, InputSource source, String extensionID, String rsBundleClassName) {
        DefaultElementContext context = new DefaultElementContext();
        Map map = context.getScopeData();
        Extension extension = ExtensionRegistry.getExtensionRegistry().findExtension(extensionID);
        if (extension == null) {
            return;
        }
        map.put("extension", extension);
        if (rsBundleClassName != null) {
            map.put("rsbundleclass", rsBundleClassName);
        }
        ExtensionSource src = ((DefaultExtension)extension).getSource();
        map.put("extSource", src);
        context.registerChildVisitor(PI_HOOK_NAME, (ElementVisitor)this);
        SAXManifestParser parser = new SAXManifestParser(context);
        try {
            if (reader != null) {
                parser.parse(reader, source);
            } else {
                parser.parse(source);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public List<PropertyFormLayout> getExternalPropertyFormLayouts(InputSource source, String extensionID, String rsBundleClassName) {
        return this.getExternalPropertyFormLayouts(null, source, extensionID, rsBundleClassName);
    }

    public List<PropertyFormLayout> getExternalPropertyFormLayouts(XMLReader reader, InputSource source, String extensionID, String rsBundleClassName) {
        List<HashStructure> oldList = this.getPropertyFormLayoutList();
        this.processExternalInspectorHook(reader, source, extensionID, rsBundleClassName);
        List<HashStructure> newList = this.getPropertyFormLayoutList();
        newList.removeAll(oldList);
        ArrayList<PropertyFormLayout> result = new ArrayList<PropertyFormLayout>(newList.size());
        Iterator<HashStructure> i = newList.iterator();
        while (i.hasNext()) {
            result.add(new DefaultPropertyFormLayout(i.next()));
        }
        return result;
    }

    private List<HashStructure> getInspectableFactoriesList() {
        ArrayList<HashStructure> factoryList = new ArrayList<HashStructure>();
        HashStructure pi = this.getHashStructure();
        List factories = pi.getAsList(INSPECTABLE_FACTORIES);
        if (factories != null) {
            for (int i = 0; i < factories.size(); ++i) {
                factoryList.add((HashStructure)factories.get(i));
            }
        }
        return factoryList;
    }

    private List<HashStructure> getPropertyFormLayoutsList() {
        ArrayList<HashStructure> layoutsList = new ArrayList<HashStructure>();
        HashStructure pi = this.getHashStructure();
        List layouts = pi.getAsList(PROPERTY_FORM_LAYOUTS);
        if (layouts != null) {
            for (int i = 0; i < layouts.size(); ++i) {
                layoutsList.add((HashStructure)layouts.get(i));
            }
        }
        return layoutsList;
    }

    private List<HashStructure> getPropertyFormLayoutList() {
        ArrayList<HashStructure> layoutList = new ArrayList<HashStructure>();
        List<HashStructure> layoutsList = this.getPropertyFormLayoutsList();
        for (HashStructure hs : layoutsList) {
            List pflList = hs.getAsList("property-form-layout");
            if (pflList == null) continue;
            for (int j = 0; j < pflList.size(); ++j) {
                layoutList.add((HashStructure)pflList.get(j));
            }
        }
        return layoutList;
    }

    private Map<String, Map<String, HashStructure>> getExtensibleElementsMap() {
        if (this._extensibleElementsMap == null) {
            this._extensibleElementsMap = new HashMap<String, Map<String, HashStructure>>();
            List<HashStructure> pfls = this.getPropertyFormLayoutsList();
            Iterator<HashStructure> i = pfls.iterator();
            while (i.hasNext()) {
                try {
                    this.mapExtensibleElements(i.next());
                }
                catch (Exception exception) {}
            }
        }
        return this._extensibleElementsMap;
    }

    private void mapExtensibleElements(HashStructure hash) {
        Iterator iterator = hash.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            this.mapExtensibleElements(hash, key);
        }
    }

    private void mapExtensibleElements(HashStructure hash, String key) {
        Object value = hash.getObject(key);
        if (value instanceof HashStructure) {
            HashStructure hs = (HashStructure)value;
            this.mapExtensibleElement(hs, hs.getStructName());
            this.mapExtensibleElements(hs);
        } else if (value instanceof ListStructure) {
            ListStructure list = (ListStructure)value;
            Iterator iterator = list.iterator();
            String name = list.getStructName();
            while (iterator.hasNext()) {
                HashStructure hs = (HashStructure)iterator.next();
                this.mapExtensibleElement(hs, name);
                this.mapExtensibleElements(hs);
            }
        }
    }

    private void mapExtensibleElement(HashStructure hash, String name) {
        String id = hash.getString("id", "");
        if (id.length() == 0 || !EXTENSIBLE_ELEMENTS.contains(name)) {
            return;
        }
        if (!ModelUtil.hasLength((String)name)) {
            return;
        }
        Map<String, HashStructure> map = this._extensibleElementsMap.get(name);
        if (map == null) {
            map = new HashMap<String, HashStructure>();
            map.put(id, hash);
            this._extensibleElementsMap.put(name, map);
        } else if (!map.containsKey(id)) {
            map.put(id, hash);
        } else {
            this.reportDuplicateID(id, hash, map.get(id), name);
        }
    }

    private void reportDuplicateID(String ID, HashStructure newHS, HashStructure originalHS, String name) {
    }
}

