/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.PropertyModelListener;
import oracle.bali.inspector.PropertyModelUpdateEvent;
import oracle.bali.inspector.UpdateType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.Site;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.inspector.ComponentLevelActions;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.inspector.Inspectable;
import oracle.ide.inspector.Inspectable2;
import oracle.ide.inspector.InspectorContext;
import oracle.ide.inspector.InspectorFactory;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.inspector.InspectorPage;
import oracle.ide.inspector.InspectorWindow;
import oracle.ide.inspector.MultiInspectable;
import oracle.ide.inspector.NotObservableSubjectRegistry;
import oracle.ide.inspector.PropertyEditorRegistrar;
import oracle.ide.inspector.PropertyHelp;
import oracle.ide.inspector.UserSelectedCategories;
import oracle.ide.layout.Layout;
import oracle.ide.layout.URL2String;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.ElementFactory;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.docking.AutoExpander;
import oracle.ideimpl.inspector.AutoExpandPreferredSizes;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.ideimpl.inspector.InspectorManagerImpl;
import oracle.ideimpl.inspector.InspectorToolbar;
import oracle.ideimpl.inspector.PropertyInspector;
import oracle.ideimpl.inspector.TargetMonitor;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.ModelUtil;

public final class InspectorWindowImpl
extends InspectorWindow
implements Observer,
ListSelectionListener,
PropertyModelListener {
    private static final Object[] NO_COLUMNS_TO_UPDATE = new Object[0];
    private static final int REFRESH_DELAY = Integer.getInteger("inspector.refresh.delay", 200);
    private static final String OLD_INSPECTOR_KEY = InspectorCard.OLD_INSPECTOR.toString();
    private static final String NEW_INSPECTOR_KEY = InspectorCard.NEW_INSPECTOR.toString();
    public static final Subject[] NO_SUBJECTS = new Subject[0];
    static final Object NULL_OBJECT = new Object();
    private static final String SHOW_READ_ONLY = ".showReadOnly";
    private static final String SHOW_WRITE_ONLY = ".showWriteOnly";
    private static final String SHOW_STATUS = ".showStatus";
    private static final String TARGET = ".pinTarget";
    private static final String COUNT = ".count";
    private static final String NODE = ".document";
    private static final String PROJECT = ".project";
    private static final String WORKSPACE = ".workspace";
    private static final String FORM_MODE = ".formMode";
    private static final String AUTO_EXPAND_ENABLED = ".autoExpandEnabled";
    private static boolean registrationComplete;
    private Timer refreshTimer;
    private InspectorCard currentCard;
    private String title;
    private Component findPane;
    private SearchField searchField;
    private Component selectedPage;
    private JPanel gui;
    private JPanel container;
    private JPanel cardPanel;
    private CardLayout cards;
    private PropertyInspector inspector;
    private oracle.ide.inspector.PropertyInspector newInspector;
    private LinksDropDown linksDropDown;
    private PropertyAccess properties;
    private Customizer customizer;
    private JEWTDialog customizerDialog;
    private TattleTale tattleTale = new TattleTale();
    private TitleListener titleListener = new TitleListener();
    private final Map<Object, Object> idMap = new HashMap<Object, Object>();
    private final Map<Object, Object> valueMap = new HashMap<Object, Object>();
    private InternalAction findAction;
    private InternalAction formModeAction;
    private Context context;
    private Context initialContext;
    private MultiInspectable multiInspectable;
    private Subject[] subjects = NO_SUBJECTS;
    private final ArrayList<URL> pinTargets = new ArrayList();
    private URL nodeURL;
    private URL projectURL;
    private URL workspaceURL;
    private TargetMonitor targetMonitor;
    private boolean isMultiUpdate;
    private boolean isLoadingLayout;
    private boolean findVisible = true;
    private HashMap lastGroups = new HashMap();
    private Inspectable2 inspectableWithCustomDialog;
    private final List<Component> additionalPages = new ArrayList<Component>();
    private Component componentWithFocus;
    private ToggleToolButton autoExpandToolbarButton;
    private JToolBar.Separator autoExpandToolbarSeparator;
    private AbstractButton helpButton;
    private final AutoExpandPreferredSizes autoExpandSizes = new AutoExpandPreferredSizes();
    private IdeAction freezeViewAction;
    private IdeAction newViewAction;
    private HelpInfo contextHelpInfo;
    private final PropertyHelp propertyHelp = new PropertyHelp();
    private final UserSelectedCategories userSelectedCategories = new UserSelectedCategories();
    private UpdateType updateType = UpdateType.AUTOMATIC;
    private boolean loadOnce;

    protected InspectorWindowImpl(String viewId) {
        super(viewId);
        this.setAutoExpandable(true);
        this.setUpRefreshTimer();
    }

    private void setUpRefreshTimer() {
        this.refreshTimer = new Timer(REFRESH_DELAY, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectorWindowImpl.this.refresh();
            }
        });
        this.refreshTimer.setRepeats(false);
    }

    public void updatePropertyInspector(PropertyModelUpdateEvent event) {
        Object[] columnIds = event.columnIds();
        if (columnIds == null) {
            columnIds = NO_COLUMNS_TO_UPDATE;
        }
        if (columnIds.length == 1 && PropertyModel.COLUMN_VALIDATION_ISSUES.equals(columnIds[0])) {
            if (this.newInspector != null) {
                this.newInspector.updateValidationIssues();
            }
            return;
        }
        this.updateType = event.updateType();
        this.delayedRefresh();
    }

    public int getType() {
        return super.getType() | 1;
    }

    @Override
    @Deprecated
    public boolean isStatusVisible() {
        return false;
    }

    @Override
    @Deprecated
    public void setStatusVisible(boolean visible) {
    }

    @Override
    @Deprecated
    public void setStatus(String text) {
    }

    void showHelp() {
        if (this.contextHelpInfo == null) {
            return;
        }
        this.contextHelpInfo.setContext(this.getContext());
        HelpSystem.getHelpSystem().showHelp(this.contextHelpInfo);
    }

    public HelpInfo getHelpInfo() {
        HelpInfo helpToShow = this.contextHelpInfo;
        if (helpToShow == null) {
            helpToShow = this.defaultHelp();
        }
        helpToShow.setContext(this.getContext());
        return helpToShow;
    }

    public void setToolbarVisible(boolean visible) {
        super.setToolbarVisible(visible);
        if (this.container == null) {
            return;
        }
        if (this.isToolbarVisible && this.toolbar == null) {
            this.createToolbar();
        } else if (this.toolbar != null) {
            this.disposeToolbar();
        }
    }

    private void createToolbar() {
        this.toolbar = new InspectorToolbar();
        this.updateToolbar();
        this.gui.add((Component)this.toolbar, "North");
        this.notifySelectedPageThatToolbarStateChangedTo(0);
        this.container.revalidate();
    }

    private InspectorToolbar inspectorToolbar() {
        if (this.toolbar == null) {
            this.getGUI();
        }
        return (InspectorToolbar)this.toolbar;
    }

    private void disposeToolbar() {
        this.gui.remove((Component)this.toolbar);
        this.notifySelectedPageThatToolbarStateChangedTo(1);
        this.disposeAndRemoveAllFrom(this.toolbar);
        this.toolbar = null;
        this.container.revalidate();
    }

    private void notifySelectedPageThatToolbarStateChangedTo(int newState) {
        if (this.selectedPage instanceof InspectorPage) {
            ((InspectorPage)((Object)this.selectedPage)).toolbarStateChanged(newState);
        }
    }

    public Controller getController() {
        return InspectorManager.getInspectorManager();
    }

    public void setContext(Context context) {
        if (this.container == null) {
            this.createInitialContext();
        } else {
            super.setContext(context);
        }
    }

    private void createInitialContext() {
        this.initialContext = new Context(this.context);
        this.initialContext.setView((View)this);
    }

    public Context getContext(EventObject event) {
        if (this.context != null) {
            this.context.setEvent(event);
            return this.context;
        }
        if (this.initialContext != null) {
            this.initialContext.setEvent(event);
            return this.initialContext;
        }
        this.createContext();
        return this.context;
    }

    private void createContext() {
        this.context = Context.newIdeContext();
        this.context.setView((View)this);
        this.context.setSelection(EMPTY_SELECTION);
    }

    protected Element[] getSelectionFromUI() {
        if (this.context != null) {
            return this.context.getSelection();
        }
        if (this.initialContext != null) {
            this.initialContext.getSelection();
        }
        return EMPTY_SELECTION;
    }

    public void beforeAutoExpanding() {
        this.updateAutoExpandComponents();
        this.componentWithFocus = this.newInspector.componentWithFocus();
    }

    public void afterAutoExpanding() {
        this.restoreFocusInFocusedComponent();
        if (this.freezeViewAction != null) {
            this.freezeViewAction.setEnabled(true);
        }
        if (this.newViewAction != null) {
            this.newViewAction.setEnabled(true);
        }
    }

    private void updateAutoExpandComponents() {
        if (this.autoExpandToolbarButton != null) {
            this.autoExpandToolbarButton.setSelected(this.isAutoExpandableEnabled());
        }
    }

    public Dimension getAutoExpansionPreferredSize(int orientation) {
        return this.autoExpandSizes.size(this.getTitle(), orientation);
    }

    public Dimension getAutoExpansionSize(int orientation, JPanel dockedTitledPanel) {
        if (this.newInspector == null) {
            return null;
        }
        Component guiComponent = this.getGUI();
        if (guiComponent == null) {
            return null;
        }
        return this.newInspector.autoExpandSize(dockedTitledPanel.getSize(), orientation);
    }

    public void afterRestoringFromAutoExpansion(int orientation, Dimension autoExpandedWindowSize, boolean userResized) {
        this.restoreFocusInFocusedComponent();
        this.updateAutoExpandComponents();
        if (!userResized) {
            return;
        }
        this.autoExpandSizes.put(orientation, this.getTitle(), autoExpandedWindowSize);
    }

    private void restoreFocusInFocusedComponent() {
    }

    public Component getGUI() {
        if (this.gui != null) {
            return this.gui;
        }
        this.ensureRegistrationHasBeenCompleted();
        this.linksDropDown = new LinksDropDown();
        this.inspector = new PropertyInspector();
        this.inspector.setName(InspectorArb.getString(21));
        this.inspector.setOwner(this);
        this.selectedPage = this.inspector;
        this.newInspector = new oracle.ide.inspector.PropertyInspector(this, this.userSelectedCategories);
        this.addViewListener(this.newInspector);
        this.createContainer();
        this.gui = new JPanel(new BorderLayout()){};
        this.cards = new CardLayout();
        this.cardPanel = new JPanel(this.cards);
        this.cardPanel.add((Component)this.newInspector, NEW_INSPECTOR_KEY);
        if (InspectorWindowImpl.enableListMode()) {
            this.cardPanel.add(this.selectedPage, OLD_INSPECTOR_KEY);
            this.setCurrentCard(InspectorCard.OLD_INSPECTOR);
        } else {
            this.setCurrentCard(InspectorCard.NEW_INSPECTOR);
        }
        this.container.add((Component)this.cardPanel, "Center");
        this.gui.add((Component)this.container, "Center");
        this.loadDelayedProperties();
        this.setToolbarVisible(this.isToolbarVisible);
        this.handleDelayedContextUpdate();
        this.linksDropDown.updateVisibility();
        return this.gui;
    }

    boolean isToolbarVisible() {
        return this.isToolbarVisible;
    }

    private void ensureRegistrationHasBeenCompleted() {
        this.initRegistrar();
    }

    private void createContainer() {
        BorderLayout containerLayout = new BorderLayout();
        containerLayout.setVgap(0);
        containerLayout.setHgap(0);
        this.container = new JPanel();
        this.container.setLayout(containerLayout);
    }

    private void loadDelayedProperties() {
        this.loadLayout(this.properties);
        this.properties = null;
    }

    private void handleDelayedContextUpdate() {
        if (this.initialContext == null) {
            return;
        }
        this.setContext(this.initialContext);
        this.initialContext = null;
    }

    private void setCurrentCard(InspectorCard card) {
        this.currentCard = card;
        this.cards.show(this.cardPanel, card.toString());
    }

    private synchronized void initRegistrar() {
        if (registrationComplete) {
            return;
        }
        this.registerOutOfBoxPropertyEditors();
        this.registerPropertyEditors(this.registrarCount());
        registrationComplete = true;
    }

    private void registerOutOfBoxPropertyEditors() {
        String className = Ide.getProperty((String)"Inspector.PropertyEditor.registrar");
        if (className == null) {
            return;
        }
        try {
            Class<?> type = Class.forName(className);
            PropertyEditorRegistrar registrar = (PropertyEditorRegistrar)type.newInstance();
            if (registrar == null) {
                return;
            }
            registrar.registerPropertyEditors();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int registrarCount() {
        return this.parseInt(Ide.getProperty((String)"Inspector.PropertyEditor.count", (String)"0"));
    }

    private void registerPropertyEditors(int registrarCount) {
        for (int i = 0; i < registrarCount; ++i) {
            String prefix = "Inspector.PropertyEditor.editor" + i;
            String type = Ide.getProperty((String)(prefix + ".type"));
            String value = Ide.getProperty((String)(prefix + ".editor"));
            try {
                PropertyEditorManager.registerEditor(Class.forName(type), Class.forName(value));
                continue;
            }
            catch (Throwable t) {
                System.err.println("PropertyEditor for " + type + " could not be registered: " + value);
            }
        }
    }

    public void activate() {
        super.activate();
        this.updateAutoExpandComponents();
    }

    public void deactivate() {
        if (this.inspector != null) {
            TableCellEditor editor;
            JTable table = this.inspector.getPropertyTable();
            TableCellEditor tableCellEditor = editor = table != null ? table.getCellEditor() : null;
            if (editor != null) {
                editor.stopCellEditing();
            }
        }
        super.deactivate();
    }

    public void stateChange(int newState) {
        super.stateChange(newState);
        if (newState == 2) {
            if (this.newInspector != null) {
                this.newInspector.applyValueFromFocusedComponent();
            }
            return;
        }
        if (newState != 3) {
            return;
        }
        this.aggressiveCleanupToPreventLeaks();
    }

    private void aggressiveCleanupToPreventLeaks() {
        this.detachFromSubjects();
        this.setToolbarVisible(false);
        this.cleanUpOldModel();
        this.disposeInspector();
        this.disposeTargetMonitor();
        this.disposeLastGroups();
        this.newInspector = null;
        this.selectedPage = null;
        this.gui = null;
        this.cardPanel = null;
        this.cards = null;
        this.container = null;
        this.linksDropDown = null;
        this.properties = null;
        this.releaseCustomizer();
        this.tattleTale = null;
        this.titleListener = null;
        this.context = null;
        this.initialContext = null;
        this.disposeURLs();
        this.idMap.clear();
        this.valueMap.clear();
        this.pinTargets.clear();
        this.autoExpandSizes.clear();
        this.freezeViewAction = null;
        this.newViewAction = null;
        this.contextHelpInfo = null;
    }

    private void disposeInspector() {
        this.inspector.stateChanged(2);
        this.inspector.setOwner(null);
        this.disposeAdditionalPages();
        this.inspector = null;
    }

    private void disposeAdditionalPages() {
        if (this.additionalPages.isEmpty()) {
            return;
        }
        for (Component page : this.additionalPages) {
            if (page instanceof InspectorPage) {
                ((InspectorPage)((Object)page)).stateChanged(2);
                ((InspectorPage)((Object)page)).setOwner(null);
                continue;
            }
            if (!(page instanceof oracle.bali.inspector.PropertyInspector)) continue;
            ((oracle.bali.inspector.PropertyInspector)page).setUnderlyingPropertyModel(null);
        }
        this.additionalPages.clear();
    }

    private void disposeTargetMonitor() {
        if (this.targetMonitor == null) {
            return;
        }
        this.targetMonitor.reset();
        this.targetMonitor = null;
    }

    private void disposeLastGroups() {
        if (this.lastGroups == null) {
            return;
        }
        this.lastGroups.clear();
        this.lastGroups = null;
    }

    public void update(Object subject, UpdateMessage message) {
        if (message == null) {
            return;
        }
        super.update(subject, message);
        int messageId = message.getMessageID();
        if (messageId != UpdateMessage.ATTRIBUTE_CHANGED) {
            this.updateType = UpdateType.AUTOMATIC;
            this.delayedRefresh();
        }
    }

    public synchronized void setPinState(int newState) {
        if (!this.isLoadingLayout) {
            switch (newState) {
                case 0: {
                    this.getTargetMonitor().reset();
                    super.setPinState(newState);
                    break;
                }
                case 2: {
                    super.setPinState(newState);
                    this.persistPinTarget(true);
                    break;
                }
                default: {
                    super.setPinState(newState);
                }
            }
            return;
        }
        super.setPinState(newState);
    }

    public int getDefaultVisibility(Layout layout) {
        String showInspector = layout.getProperty("Layout.ShowInspector", "false");
        boolean visible = Boolean.valueOf(showInspector);
        return visible ? 5 : 0;
    }

    public String getTabName() {
        if (this.getPinState() != 0) {
            String subject = this.getTitle();
            if (subject == null && this.targetMonitor != null && this.targetMonitor.isMonitoring()) {
                subject = this.targetMonitor.title();
            }
            return subject != null ? subject : InspectorArb.getString(0);
        }
        return InspectorArb.getString(0);
    }

    public Icon getTabIcon() {
        return IdeArb.getIcon((int)170);
    }

    public String getTitleName() {
        String subject = this.getTitle();
        String suffix = InspectorArb.getString(1);
        return subject != null ? subject + " - " + suffix : suffix;
    }

    public String getMenuTitle() {
        return IdeArb.getString((int)168);
    }

    public Site getPreferredSite() {
        return new Site(this.getSite());
    }

    public void saveLayout(PropertyAccess properties) {
        if (this.inspector == null) {
            return;
        }
        String id = this.getId();
        Map<String, String> propertyNames = this.layoutPropertyNames(id);
        this.removePreviousTargets(properties, propertyNames);
        if (this.getPinState() == 2) {
            this.saveLayoutWhenPinStateIsPinObject(properties, propertyNames);
        } else {
            properties.removeProperty(propertyNames.get(NODE));
            properties.removeProperty(propertyNames.get(PROJECT));
            properties.removeProperty(propertyNames.get(WORKSPACE));
            properties.removeProperty(propertyNames.get(COUNT));
        }
        properties.setProperty("InspectorWindow", new ViewId(id).getName());
        this.setBooleanProperty(properties, propertyNames.get(SHOW_READ_ONLY), this.inspector.isReadOnlyIncluded());
        this.setBooleanProperty(properties, propertyNames.get(SHOW_WRITE_ONLY), this.inspector.isWriteOnlyIncluded());
        this.setBooleanProperty(properties, propertyNames.get(SHOW_STATUS), this.isStatusVisible());
        this.setBooleanProperty(properties, propertyNames.get(FORM_MODE), this.currentCard == InspectorCard.NEW_INSPECTOR);
        this.setBooleanProperty(properties, propertyNames.get(AUTO_EXPAND_ENABLED), this.isAutoExpandableEnabled());
        this.autoExpandSizes.saveTo(properties, id);
        this.userSelectedCategories.saveTo(properties);
    }

    private void removePreviousTargets(PropertyAccess properties, Map<String, String> propertyNames) {
        String value = properties.getProperty(propertyNames.get(COUNT), null);
        if (value == null) {
            return;
        }
        int count = this.parseInt(value);
        for (int i = 0; i < count; ++i) {
            properties.removeProperty(propertyNames.get(TARGET) + i);
        }
    }

    private void saveLayoutWhenPinStateIsPinObject(PropertyAccess properties, Map<String, String> propertyNames) {
        this.setOrRemoveUrlProperty(properties, propertyNames.get(NODE), this.nodeURL);
        this.setOrRemoveUrlProperty(properties, propertyNames.get(PROJECT), this.projectURL);
        this.setOrRemoveUrlProperty(properties, propertyNames.get(WORKSPACE), this.workspaceURL);
        properties.setProperty(propertyNames.get(COUNT), String.valueOf(this.pinTargets.size()));
        if (this.pinTargets.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.pinTargets.size(); ++i) {
            this.setUrlProperty(properties, propertyNames.get(TARGET) + i, this.pinTargets.get(i));
        }
    }

    private void setBooleanProperty(PropertyAccess properties, String propertyId, boolean value) {
        properties.setProperty(propertyId, String.valueOf(value));
    }

    private void setOrRemoveUrlProperty(PropertyAccess properties, String propertyId, URL value) {
        if (value != null) {
            this.setUrlProperty(properties, propertyId, value);
        } else {
            properties.removeProperty(propertyId);
        }
    }

    private void setUrlProperty(PropertyAccess properties, String propertyId, URL value) {
        properties.setProperty(propertyId, URL2String.toString((URL)value));
    }

    public void loadLayout(PropertyAccess properties) {
        if (!this.loadOnce) {
            if (properties == null) {
                return;
            }
            this.loadOnce = true;
            String id = this.getId();
            this.autoExpandSizes.loadFrom(properties, id);
            this.userSelectedCategories.loadFrom(properties);
            Map<String, String> propertyNames = this.layoutPropertyNames(id);
            this.setAutoExpandableEnabled(this.booleanProperty(properties, propertyNames.get(AUTO_EXPAND_ENABLED), false));
            if (this.inspector == null) {
                this.properties = properties;
                return;
            }
            this.pinTargets.clear();
            this.setPinStateWhenLoadingLayout(0);
            String value = properties.getProperty(propertyNames.get(COUNT), null);
            if (value != null) {
                this.loadURLsFromProperties(properties, propertyNames);
                this.loadPinTargets(properties, propertyNames, this.parseInt(value));
            } else {
                this.disposeURLs();
            }
            this.inspector.setReadOnlyIncluded(this.booleanProperty(properties, propertyNames.get(SHOW_READ_ONLY), false));
            this.inspector.setWriteOnlyIncluded(this.booleanProperty(properties, propertyNames.get(SHOW_WRITE_ONLY), false));
            this.setStatusVisible(this.booleanProperty(properties, propertyNames.get(SHOW_STATUS), true));
            this.setCurrentCard(this.booleanProperty(properties, propertyNames.get(FORM_MODE), true) ? InspectorCard.NEW_INSPECTOR : InspectorCard.OLD_INSPECTOR);
        }
    }

    private boolean booleanProperty(PropertyAccess properties, String propertyId, boolean defaultValue) {
        return "true".equals(properties.getProperty(propertyId, String.valueOf(defaultValue)));
    }

    private Map<String, String> layoutPropertyNames(String id) {
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
        names.put(NODE, id + NODE);
        names.put(PROJECT, id + PROJECT);
        names.put(WORKSPACE, id + WORKSPACE);
        names.put(COUNT, id + COUNT);
        names.put(SHOW_READ_ONLY, id + SHOW_READ_ONLY);
        names.put(SHOW_WRITE_ONLY, id + SHOW_WRITE_ONLY);
        names.put(SHOW_STATUS, id + SHOW_STATUS);
        names.put(FORM_MODE, id + FORM_MODE);
        names.put(TARGET, id + TARGET + ".");
        names.put(AUTO_EXPAND_ENABLED, id + AUTO_EXPAND_ENABLED);
        return names;
    }

    private void loadURLsFromProperties(PropertyAccess properties, Map<String, String> propertyNames) {
        this.nodeURL = this.urlFromProperty(properties, propertyNames.get(NODE));
        this.projectURL = this.urlFromProperty(properties, propertyNames.get(PROJECT));
        this.workspaceURL = this.urlFromProperty(properties, propertyNames.get(WORKSPACE));
    }

    private URL urlFromProperty(PropertyAccess properties, String propertyId) {
        String propertyValue = properties.getProperty(propertyId, null);
        return propertyValue != null ? URL2String.toURL((String)propertyValue) : null;
    }

    private void loadPinTargets(PropertyAccess properties, Map<String, String> propertyNames, int count) {
        for (int i = 0; i < count; ++i) {
            String value = properties.getProperty(propertyNames.get(TARGET) + i, null);
            if (value == null || value.length() == 0) continue;
            URL url = URL2String.toURL((String)value);
            if (url != null) {
                this.pinTargets.add(url);
                continue;
            }
            this.pinTargets.clear();
            break;
        }
        this.setPinStateWhenLoadingLayout(2);
    }

    private void setPinStateWhenLoadingLayout(int newPinState) {
        this.isLoadingLayout = true;
        this.setPinState(newPinState);
        this.isLoadingLayout = false;
    }

    private int parseInt(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    void clearPinTargets() {
        this.pinTargets.clear();
    }

    void disposeURLs() {
        this.nodeURL = null;
        this.projectURL = null;
        this.workspaceURL = null;
    }

    @Override
    public oracle.bali.inspector.PropertyInspector getPropertyInspector() {
        return this.inspector;
    }

    @Override
    public Customizer getCustomizer() {
        if (this.hasInspectableWithCustomDialog()) {
            this.releaseCustomizer();
            return this.customizer;
        }
        if (this.multiInspectable == null) {
            return this.customizer;
        }
        if (this.customizer != null) {
            return this.customizer;
        }
        int inspectableCount = this.multiInspectable.getSize();
        for (int i = 0; i < inspectableCount; ++i) {
            this.customizer = this.multiInspectable.getInspectable(i).getCustomizer();
            if (this.customizer == null) continue;
            this.customizer.addPropertyChangeListener(this.tattleTale);
            break;
        }
        return this.customizer;
    }

    private void releaseCustomizer() {
        if (this.customizer == null) {
            return;
        }
        this.customizer.removePropertyChangeListener(this.tattleTale);
        this.customizer = null;
        this.idMap.clear();
        this.valueMap.clear();
    }

    @Override
    public Component[] getAdditionalTabPages() {
        return this.additionalPages.toArray(new Component[this.additionalPages.size()]);
    }

    private String getTitle() {
        return this.title;
    }

    private void setTitle(String title) {
        this.title = title;
        this.updateTitle(this.getTitleName());
    }

    private void updateAutoExpandPreferredSizeMap(String newTitle) {
        if (!ModelUtil.hasLength((String)newTitle)) {
            return;
        }
        if (ModelUtil.areEqual((Object)newTitle, (Object)this.title)) {
            return;
        }
        this.autoExpandSizes.updateSizeKey(this.title, newTitle);
    }

    private synchronized void attachToSubjects(Subject[] newSubjects) {
        if (this.targetMonitor != null && this.targetMonitor.isMonitoring()) {
            return;
        }
        this.detachFromSubjects();
        if (newSubjects == null) {
            this.subjects = NO_SUBJECTS;
            return;
        }
        for (Subject s : this.subjects = newSubjects) {
            if (s == null || !NotObservableSubjectRegistry.instance().isObservable(s)) continue;
            s.attach((Observer)this);
        }
    }

    private void detachFromSubjects() {
        for (int i = 0; i < this.subjects.length; ++i) {
            if (this.subjects[i] == null) continue;
            this.subjects[i].detach((Observer)this);
        }
        this.subjects = NO_SUBJECTS;
    }

    private void ensureGuiExists() {
        if (this.container != null) {
            return;
        }
        this.getGUI();
    }

    private void notifyListenersSelectionChangedEvenForSameObject() {
        this.updateSelection();
    }

    private void delayedRefresh() {
        if (!this.refreshTimer.isRunning()) {
            this.refreshTimer.start();
            return;
        }
        this.refreshTimer.restart();
    }

    private boolean shouldUpdateUI(PropertyModel model) {
        if (UpdateType.AUTOMATIC.equals((Object)this.updateType) || this.updateType == null) {
            return super.equalPropertyModel(model);
        }
        return UpdateType.UPDATE_VALUES_ONLY.equals((Object)this.updateType);
    }

    synchronized void refresh() {
        if (this.inspector == null) {
            return;
        }
        if (this.isMultiUpdate) {
            return;
        }
        this.ensureGuiExists();
        this.notifyListenersSelectionChangedEvenForSameObject();
        this.updateMultiInspectable();
        this.cleanUpAdditionalPages();
        this.linksDropDown.clearActions();
        this.cleanUpOldModel();
        PropertyModel model = this.obtainAttachedModelFrom(this.multiInspectable);
        this.updateHelp(model);
        if (this.shouldUpdateUI(model)) {
            this.updateInspectableAndAdditionalPages(this.multiInspectable, model);
            this.refreshToolbar();
            this.linksDropDown.updateVisibility();
            this.updateTitleFrom(model);
            this.updatePropertyEditors(model);
            this.setThisAsAdditionalPagesOwnerAndSetThemToNewPropertyInspector();
            return;
        }
        String lastPage = this.selectedPage != null ? this.selectedPage.getName() : null;
        this.cleanUpAdditionalPages();
        this.releaseCustomizer();
        if (InspectorWindowImpl.enableListMode()) {
            this.inspector.setUnderlyingPropertyModel(model);
        }
        boolean hasFocus = this.hasFocus();
        this.setModelInNewPropertyInspector(model);
        this.updateInspectableAndAdditionalPages(this.multiInspectable, model);
        this.setThisAsAdditionalPagesOwnerAndSetThemToNewPropertyInspector();
        this.updateTitleFrom(model);
        this.updateSelectedPageForOldInspector(lastPage);
        this.refreshToolbar();
        if (InspectorWindowImpl.enableListMode()) {
            this.cardPanel.add(this.selectedPage, OLD_INSPECTOR_KEY);
            this.setCurrentCard(this.currentCard);
        }
        this.linksDropDown.updateVisibility();
        if (this.selectedPage instanceof InspectorPage) {
            ((InspectorPage)((Object)this.selectedPage)).stateChanged(0);
        }
        this.container.revalidate();
        this.container.repaint();
        if (this.customizerDialog != null) {
            this.customizerDialog.setContent((Component)((Object)this.getCustomizer()));
        }
        if (hasFocus && this.currentCard == InspectorCard.NEW_INSPECTOR) {
            this.newInspector.requestFocusInWindow();
        }
    }

    private boolean hasFocus() {
        Component focusOwner = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            return false;
        }
        Class<oracle.ide.inspector.PropertyInspector> parentType = oracle.ide.inspector.PropertyInspector.class;
        Container parent = SwingUtilities.getAncestorOfClass(parentType, focusOwner);
        return parent != null;
    }

    private void updateHelp(PropertyModel model) {
        try {
            this.contextHelpInfo = this.propertyHelp.getHelpFrom(model);
        }
        catch (Exception e) {
            this.contextHelpInfo = null;
        }
        if (this.contextHelpInfo == null) {
            this.contextHelpInfo = this.defaultHelp();
        }
    }

    private HelpInfo defaultHelp() {
        return new HelpInfo("f1_idepropertyinspector_html");
    }

    private void updateMultiInspectable() {
        this.multiInspectable = InspectorFactory.getInstance().getMultiInspectable(this.context);
        this.updateInspectableWithCustomDialog();
    }

    private void updateInspectableWithCustomDialog() {
        this.inspectableWithCustomDialog = null;
        if (this.multiInspectable == null) {
            return;
        }
        int i = 0;
        int inspectableCount = this.multiInspectable.getSize();
        if (i < inspectableCount) {
            Inspectable inspectable = this.multiInspectable.getInspectable(i);
            if (this.hasCustomDialog(inspectable)) {
                this.inspectableWithCustomDialog = (Inspectable2)inspectable;
            }
            return;
        }
    }

    private boolean hasInspectableWithCustomDialog() {
        return this.inspectableWithCustomDialog != null;
    }

    private boolean hasCustomDialog(Inspectable inspectable) {
        return inspectable instanceof Inspectable2 && ((Inspectable2)inspectable).hasCustomDialog();
    }

    private void cleanUpOldModel() {
        if (this.inspector != null) {
            this.cleanUp(this.inspector.getUnderlyingPropertyModel());
        }
        if (this.newInspector != null) {
            this.cleanUp(this.newInspector.getPropertyModel());
        }
    }

    private void cleanUp(PropertyModel model) {
        if (model == null) {
            return;
        }
        model.removePropertyChangeListener((PropertyChangeListener)this.titleListener);
        model.removePropertyModelListener((PropertyModelListener)this);
    }

    private void cleanUpAdditionalPages() {
        if (this.additionalPages.isEmpty()) {
            return;
        }
        for (Component page : this.additionalPages) {
            if (page instanceof InspectorPage) {
                ((InspectorPage)((Object)page)).stateChanged(2);
                ((InspectorPage)((Object)page)).setOwner(null);
                continue;
            }
            if (!(page instanceof oracle.bali.inspector.PropertyInspector)) continue;
            ((oracle.bali.inspector.PropertyInspector)page).setUnderlyingPropertyModel(null);
        }
        this.additionalPages.clear();
    }

    private PropertyModel obtainAttachedModelFrom(MultiInspectable multiInspectable) {
        PropertyModel model = multiInspectable.getPropertyModel();
        this.attachToSubjects(model);
        model.addPropertyModelListener((PropertyModelListener)this);
        return model;
    }

    private void updatePropertyEditors(PropertyModel model) {
        this.startTimingRefresh();
        this.newInspector.updatePropertyEditors(model);
        this.endTiminigRefresh();
    }

    private void setModelInNewPropertyInspector(PropertyModel model) {
        this.startTimingRefresh();
        if (this.currentCard == InspectorCard.NEW_INSPECTOR) {
            this.newInspector.setPropertyModel(model);
        } else {
            this.newInspector.setPropertyModel(null);
        }
        this.endTiminigRefresh();
    }

    private void startTimingRefresh() {
    }

    private void endTiminigRefresh() {
    }

    private void updateInspectableAndAdditionalPages(MultiInspectable multiInspectable, PropertyModel model) {
        int inspectableCount = multiInspectable.getSize();
        if (inspectableCount == 0) {
            this.additionalPages.clear();
            return;
        }
        for (int i = 0; i < inspectableCount; ++i) {
            Inspectable inspectable = multiInspectable.getInspectable(i);
            this.updateLinksDropDownFromInspectable(inspectable);
            Component[] pages = inspectable.getAdditionalTabPages();
            if (pages == null || pages.length == 0) continue;
            this.additionalPages.addAll(Arrays.asList(pages));
        }
        if (this.getCustomizer() != null) {
            this.copyModelValues(model);
        }
    }

    private void setThisAsAdditionalPagesOwnerAndSetThemToNewPropertyInspector() {
        if (this.additionalPages == null) {
            return;
        }
        for (Component c : this.additionalPages) {
            if (!(c instanceof InspectorPage)) continue;
            ((InspectorPage)((Object)c)).setOwner(this);
        }
        if (this.currentCard == InspectorCard.NEW_INSPECTOR) {
            this.newInspector.setAdditionalTabPages(this.getAdditionalTabPages());
        }
    }

    private void updateLinksDropDownFromInspectable(Inspectable inspectable) {
        if (inspectable instanceof ComponentLevelActions) {
            ComponentLevelActions actions = (ComponentLevelActions)((Object)inspectable);
            this.linksDropDown.setMenuActions(actions.getDropdownActions());
        } else if (inspectable instanceof Inspectable2) {
            Inspectable2 i2 = (Inspectable2)inspectable;
            this.linksDropDown.setMenuActions(i2.getLinkActions());
        } else {
            this.linksDropDown.clearActions();
        }
    }

    private void updateTitleFrom(PropertyModel model) {
        if (model != null) {
            this.setTitle(model.getTargetDisplayName());
            model.addPropertyChangeListener((PropertyChangeListener)this.titleListener);
        } else {
            this.setTitle(null);
        }
    }

    private void updateSelectedPageForOldInspector(String lastPage) {
        if (this.selectedPage == this.inspector) {
            return;
        }
        if (lastPage != null) {
            int i = this.additionalPages.size();
            while (--i >= 0) {
                Component page = this.additionalPages.get(i);
                String pageName = page != null ? page.getName() : null;
                if (pageName == null || !pageName.equals(lastPage)) continue;
                this.selectedPage = page;
                break;
            }
            if (i < 0) {
                this.selectedPage = this.inspector;
            }
        } else {
            this.selectedPage = this.inspector;
        }
    }

    private void refreshToolbar() {
        if (this.toolbar == null) {
            return;
        }
        this.updateToolbar();
        this.gui.add((Component)this.toolbar, "North");
    }

    private void attachToSubjects(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return;
        }
        if (propertyModel instanceof IdePropertyModel) {
            this.attachToSubjects(((IdePropertyModel)propertyModel).getSubjects());
            return;
        }
        this.attachToSubjects(this.subjectsFromContext());
    }

    private Subject[] subjectsFromContext() {
        Node node;
        Context localContext;
        Context context = localContext = this.context != null ? this.context : this.initialContext;
        if (localContext == null) {
            return NO_SUBJECTS;
        }
        Element[] selection = localContext.getSelection();
        ArrayList<Object> subjectList = new ArrayList<Object>();
        Integer[] offsets = InspectorContext.getInspectableOffsets(localContext);
        if (offsets != null) {
            for (int i = 0; i < offsets.length; ++i) {
                Element element = selection[offsets[i]];
                if (!(element instanceof Subject)) continue;
                subjectList.add((Subject)element);
            }
        }
        if (subjectList.size() == 0 && (node = localContext.getNode()) != null) {
            subjectList.add(node);
        }
        Subject[] subjects = new Subject[subjectList.size()];
        subjectList.toArray(subjects);
        return subjects;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateVisibleActions();
    }

    private void updateToolbar() {
        DefaultCustomTabPage tab;
        if (this.toolbar == null) {
            return;
        }
        this.disposeAndRemoveAllFrom(this.toolbar);
        String name = this.inspector.getShortLabel();
        Icon icon = this.inspector.getIcon();
        String tooltip = this.inspector.getToolTipText();
        DefaultListModel<DefaultCustomTabPage> model = new DefaultListModel<DefaultCustomTabPage>();
        DefaultCustomTabPage current = tab = new DefaultCustomTabPage(icon, null, (Object)this.inspector);
        tab.setLabel(name);
        tab.setTooltip(ModelUtil.areDifferent((Object)name, (Object)tooltip) ? tooltip : null);
        model.addElement(tab);
        String lastPage = this.selectedPage != null ? this.selectedPage.getName() : null;
        for (Component page : this.additionalPages) {
            if (page instanceof InspectorPage) {
                InspectorPage iPage = (InspectorPage)((Object)page);
                name = iPage.getShortLabel();
                icon = iPage.getIcon();
                tooltip = iPage.getToolTipText();
            } else {
                name = page.getClass().getName();
                icon = IdeArb.getIcon((int)170);
                tooltip = name;
            }
            tab = new DefaultCustomTabPage(icon, null, (Object)page);
            tab.setLabel(name);
            tab.setTooltip(ModelUtil.areDifferent((Object)name, (Object)tooltip) ? tooltip : null);
            model.addElement(tab);
            if (name != lastPage) continue;
            current = tab;
        }
        if (this.findAction == null) {
            this.initActions();
        }
        this.addAutoExtendActionToToolbar();
        this.addFreezeActionToToolbar();
        this.addNewViewActionToToolbar();
        this.addCustomizerActionToToolbar();
        this.addComponentLevelActionsToToolbar();
        this.toolbar.add((Component)this.inspectorToolbar().customToolbarButtonsContainer);
        this.toolbar.add((Component)((Object)this.linksDropDown));
        this.addFindPaneToToolbar();
        this.addHelpActionToToolbar();
        this.inspectorToolbar().sealLayout();
    }

    private void disposeAndRemoveAllFrom(Toolbar toolbar) {
        this.inspectorToolbar().unsealLayout();
        toolbar.dispose();
        toolbar.removeAll();
    }

    private void addAutoExtendActionToToolbar() {
        IdeAction action = InspectorManagerImpl.getAutoExtendCmdAction().newLocalAction((View)this);
        action.setCommandId(InspectorManagerImpl.AUTO_EXTEND_CMD_ID);
        this.autoExpandToolbarButton = this.toolbar.addToggleButton((ToggleAction)action);
        this.autoExpandToolbarSeparator = this.toolbar.newSeparator();
        this.toolbar.add((Component)this.autoExpandToolbarSeparator);
        this.updateAutoExpandComponents();
    }

    void enableOrDisableAutoExtend(boolean state) {
        this.setAutoExpandableEnabled(state);
        if (!state) {
            AutoExpander.instance().hideAutoExpanded((Dockable)this);
        }
    }

    private void addFreezeActionToToolbar() {
        this.freezeViewAction = IdeActions.getViewFreezeAction();
        if (this.freezeViewAction == null) {
            return;
        }
        this.freezeViewAction = this.freezeViewAction.newLocalAction((View)this);
        this.freezeViewAction.putValue("State", (Object)(this.getPinState() == 2 ? 1 : 0));
        this.toolbar.addToggleButton((ToggleAction)this.freezeViewAction);
        this.freezeViewAction.setEnabled(true);
    }

    private void addNewViewActionToToolbar() {
        this.newViewAction = IdeActions.getViewNewViewAction();
        if (this.newViewAction == null) {
            return;
        }
        this.newViewAction = this.newViewAction.newLocalAction((View)this);
        this.toolbar.add((ToggleAction)this.newViewAction);
        this.newViewAction.setEnabled(true);
    }

    private void addCustomizerActionToToolbar() {
        this.toolbar.addSeparator();
        boolean enabled = this.hasInspectableWithCustomDialog();
        if (!enabled) {
            enabled = this.getCustomizer() != null;
        }
        String tooltip = InspectorArb.getString(25);
        IdeAction action = InspectorManagerImpl.getCustomizerCmdAction().newLocalAction((View)this);
        action.setCommandId(InspectorManagerImpl.CUSTOMIZER_CMD_ID);
        action.setEnabled(enabled);
        ToolButton button = this.toolbar.add((ToggleAction)action);
        button.setToolTipText(tooltip);
        InspectorWindowImpl.updateToolbarActions((Toolbar)this.getToolbar());
    }

    private void addComponentLevelActionsToToolbar() {
        if (this.multiInspectable == null) {
            return;
        }
        int inspectableCount = this.multiInspectable.getSize();
        for (int i = 0; i < inspectableCount; ++i) {
            this.addComponentLevelActionsToToolbar(this.multiInspectable.getInspectable(i));
        }
    }

    private void addComponentLevelActionsToToolbar(Inspectable inspectable) {
        if (!(inspectable instanceof ComponentLevelActions)) {
            return;
        }
        Action[] actions = ((ComponentLevelActions)((Object)inspectable)).getToolbarActions();
        if (actions == null) {
            return;
        }
        for (Action action : actions) {
            if (action == null) continue;
            this.addToolbarAction(action);
        }
    }

    private void addToolbarAction(Action action) {
        JButton button = this.toolbar.add(action);
        String tooltip = (String)action.getValue("ShortDescription");
        if (tooltip == null) {
            tooltip = (String)action.getValue("Name");
        }
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
    }

    private void addHelpActionToToolbar() {
        IdeAction action = InspectorManagerImpl.getHelpAction().newLocalAction((View)this);
        action.setCommandId(InspectorManagerImpl.HELP_CMD_ID);
        ToolButton button = new ToolButton((Action)action);
        this.helpButton = (AbstractButton)this.toolbar.addComponent((Component)button, -1);
        this.helpButton.setVisible(true);
        this.helpButton.setEnabled(this.contextHelpInfo != null);
        this.helpButton.setActionCommand(InspectorArb.getString(17));
    }

    private void addFindPaneToToolbar() {
        this.findPane = this.createFindPane();
        this.inspectorToolbar().addHorizontalGlue();
        this.toolbar.add(this.findPane);
    }

    private void copyModelValues(PropertyModel model) {
        Enumeration propertyIds = model.getPropertyIDs();
        int nameColumnIndex = model.getColumnIndex(PropertyModel.COLUMN_NAME);
        int valueColumnIndex = model.getColumnIndex(PropertyModel.COLUMN_VALUE);
        if (propertyIds == null) {
            return;
        }
        while (propertyIds.hasMoreElements()) {
            Object propertyId = propertyIds.nextElement();
            Object name = model.getPropertyByID(nameColumnIndex, propertyId);
            Object value = model.getPropertyByID(valueColumnIndex, propertyId);
            if (value == null) {
                value = NULL_OBJECT;
            }
            if (name == null) continue;
            this.idMap.put(name, propertyId);
            this.valueMap.put(propertyId, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCustomizer() {
        if (this.hasInspectableWithCustomDialog()) {
            this.inspectableWithCustomDialog.showCustomDialog(this.getGUI());
            return;
        }
        if (this.getCustomizer() == null) {
            return;
        }
        this.customizerDialog = DialogUtil.createJEWTDialogOwnedBy((Component)this.getGUI());
        if (this.customizerDialog == null) {
            return;
        }
        try {
            this.customizerDialog.setButtonMask(16);
            this.customizerDialog.setContent((Component)((Object)this.getCustomizer()));
            this.customizerDialog.runDialog();
        }
        finally {
            this.customizerDialog = null;
        }
    }

    private boolean applyCustomizerChangeToModel(PropertyModel model, PropertyChangeEvent e) {
        model.invalidateValueData();
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return false;
        }
        Object propertyId = this.idMap.get(propertyName);
        if (propertyId == null) {
            return false;
        }
        Object newValue = null;
        int columnIndex = model.getColumnIndex(PropertyModel.COLUMN_IS_READABLE);
        Object readable = model.getPropertyByID(columnIndex, propertyId);
        if (readable != null && ((Boolean)readable).booleanValue()) {
            columnIndex = model.getColumnIndex(PropertyModel.COLUMN_VALUE);
            newValue = model.getPropertyByID(columnIndex, propertyId);
        } else {
            newValue = e.getNewValue();
        }
        try {
            int row = model.getPropertyIndex(propertyId);
            model.setPropertyValue(row, newValue);
        }
        catch (Throwable t) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void customizerChange(PropertyChangeEvent e) {
        if (e == null) {
            return;
        }
        if (this.inspector == null) {
            return;
        }
        boolean succeeded = false;
        PropertyModel model = this.inspector.getUnderlyingPropertyModel();
        try {
            succeeded = this.applyCustomizerChangeToModel(model, e);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (succeeded) {
            return;
        }
        try {
            this.isMultiUpdate = true;
            Enumeration propertyIds = model.getPropertyIDs();
            int columnNameIndex = model.getColumnIndex(PropertyModel.COLUMN_NAME);
            int valueColumnIndex = model.getColumnIndex(PropertyModel.COLUMN_VALUE);
            int isReadableColumnIndex = model.getColumnIndex(PropertyModel.COLUMN_IS_READABLE);
            while (propertyIds.hasMoreElements()) {
                boolean isDifferent = false;
                Object propertyId = propertyIds.nextElement();
                Object name = model.getPropertyByID(columnNameIndex, propertyId);
                Object oldValue = this.valueMap.get(this.idMap.get(name));
                Object liveValue = model.getPropertyByID(valueColumnIndex, propertyId);
                if (oldValue == null || oldValue == NULL_OBJECT) {
                    if (liveValue != null) {
                        isDifferent = true;
                    }
                } else if (liveValue == null) {
                    isDifferent = true;
                } else if (oldValue != liveValue && !oldValue.equals(liveValue)) {
                    isDifferent = true;
                }
                if (!isDifferent) {
                    return;
                }
                Object readable = model.getPropertyByID(isReadableColumnIndex, propertyId);
                if (readable == null || !((Boolean)readable).booleanValue()) continue;
                try {
                    int row = model.getPropertyIndex(propertyId);
                    model.setPropertyValue(row, liveValue);
                }
                catch (Throwable t) {}
            }
        }
        catch (Exception ex) {
        }
        finally {
            this.isMultiUpdate = false;
            this.updateType = UpdateType.AUTOMATIC;
            this.delayedRefresh();
        }
    }

    protected boolean isViewSupported(View view) {
        return InspectorManager.getInspectorManager().supportsInspection(view);
    }

    protected synchronized void viewSelectionChanged(Context viewCtx) {
        if (viewCtx != null) {
            this.context = new Context(viewCtx);
        } else {
            this.context = Context.newIdeContext();
            this.context.setSelection(EMPTY_SELECTION);
        }
        this.context.setView((View)this);
        this.delayedRefresh();
    }

    protected void clear() {
        super.clear();
        this.detachFromSubjects();
        if (this.context == null) {
            this.context = Context.newIdeContext();
            this.context.setView((View)this);
        }
        this.context.setNode(null);
        this.context.setProject(Ide.getActiveProject());
        this.context.setWorkspace(Ide.getActiveWorkspace());
        this.context.setSelection(EMPTY_SELECTION);
        this.viewSelectionChanged(this.context);
    }

    protected void persistPinTarget() {
        this.persistPinTarget(true);
    }

    private void persistPinTarget(boolean attachMonitors) {
        int i;
        Element[] elements;
        if (this.targetMonitor != null && this.targetMonitor.isMonitoring()) {
            return;
        }
        this.getTargetMonitor().reset();
        this.pinTargets.clear();
        if (this.getPinState() == 0) {
            this.disposeURLs();
            return;
        }
        Context ctx = this.updateURLs();
        Element[] elementArray = elements = ctx != null ? ctx.getSelection() : EMPTY_SELECTION;
        if (elements != null && elements.length > 0) {
            for (i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof Locatable)) {
                    this.pinTargets.clear();
                    break;
                }
                this.pinTargets.add(((Locatable)elements[i]).getURL());
            }
        }
        if (attachMonitors) {
            for (i = 0; i < this.subjects.length; ++i) {
                this.getTargetMonitor().monitor(this.subjects[i], true);
            }
            this.detachFromSubjects();
            this.getTargetMonitor().monitor((Subject)ctx.getNode());
            this.getTargetMonitor().monitor((Subject)ctx.getProject());
            this.getTargetMonitor().monitor((Subject)ctx.getWorkspace());
            this.getTargetMonitor().title(this.getTitle());
        }
    }

    private Context updateURLs() {
        Context ctx = this.getContext();
        Node node = null;
        Project prj = null;
        Workspace wsp = null;
        if (ctx != null) {
            node = ctx.getNode();
            prj = ctx.getProject();
            wsp = ctx.getWorkspace();
        }
        this.nodeURL = node != null ? node.getURL() : null;
        this.projectURL = prj != null ? prj.getURL() : null;
        this.workspaceURL = wsp != null ? wsp.getURL() : null;
        return ctx;
    }

    void updateURL(URL url, URL oldURL) {
        if (this.pinTargets.contains(oldURL)) {
            this.pinTargets.set(this.pinTargets.indexOf(oldURL), url);
        }
        if (this.areEqualOrSame(this.nodeURL, oldURL)) {
            this.nodeURL = url;
        }
        if (this.areEqualOrSame(this.projectURL, oldURL)) {
            this.projectURL = url;
        }
        if (this.areEqualOrSame(this.workspaceURL, oldURL)) {
            this.workspaceURL = url;
        }
    }

    private boolean areEqualOrSame(URL first, URL second) {
        return first == second || first.equals(second);
    }

    protected void restorePinTarget() {
        this.restorePinTarget(true);
    }

    void restorePinTarget(boolean reset) {
        Context ctx = this.getContext();
        Workspace workspace = null;
        Project project = null;
        Node node = null;
        try {
            workspace = (Workspace)NodeFactory.findOrCreate((URL)this.workspaceURL);
            ctx.setWorkspace(workspace);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            project = (Project)NodeFactory.findOrCreate((URL)this.projectURL);
            ctx.setProject(project);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            node = NodeFactory.findOrCreate((URL)this.nodeURL);
            ctx.setNode(node);
        }
        catch (Exception e) {
            // empty catch block
        }
        ctx.setSelection(EMPTY_SELECTION);
        if (!this.pinTargets.isEmpty()) {
            ArrayList<Element> targets = new ArrayList<Element>();
            try {
                int size = this.pinTargets.size();
                for (int i = 0; i < size; ++i) {
                    Element elem = ElementFactory.findOrCreate((URL)this.pinTargets.get(i), (Project)project);
                    if (elem == null) {
                        elem = NodeFactory.findOrCreate((URL)this.pinTargets.get(i));
                    }
                    if (elem == null) {
                        this.pinTargets.clear();
                        targets.clear();
                        break;
                    }
                    targets.add(elem);
                }
            }
            catch (Exception e) {
                this.pinTargets.clear();
                targets.clear();
            }
            if (!targets.isEmpty()) {
                Element[] sel = new Element[targets.size()];
                targets.toArray(sel);
                ctx.setSelection(sel);
            }
        }
        if (reset) {
            this.getTargetMonitor().reset();
            this.pinTargets.clear();
            this.disposeURLs();
        }
        this.viewSelectionChanged(ctx);
    }

    private TargetMonitor getTargetMonitor() {
        if (this.targetMonitor == null) {
            this.targetMonitor = new TargetMonitor(this);
        }
        return this.targetMonitor;
    }

    public boolean isFindVisible() {
        return this.findVisible;
    }

    public void setFindVisible(boolean visible) {
        if (visible == this.findVisible) {
            return;
        }
        this.findVisible = visible;
        if (this.findPane == null) {
            return;
        }
        this.findPane.setVisible(this.findVisible);
        if (this.findVisible) {
            this.searchField.requestFocus();
        } else {
            this.searchField.transferFocus();
        }
    }

    protected void initActions() {
        String name = InspectorArb.getString(11);
        Integer mnemonic = InspectorArb.getInteger(12);
        Icon icon = IdeArb.getIcon((int)111);
        this.findAction = new InternalAction(name, mnemonic, icon, this.isFindVisible());
        if (InspectorWindowImpl.enableListMode()) {
            this.formModeAction = new InternalAction("Form Mode", null, this.getTabIcon(), this.currentCard == InspectorCard.NEW_INSPECTOR);
        }
    }

    protected Component createFindPane() {
        Box findPane = new Box(2);
        this.searchField = this.searchField();
        findPane.setName("Find");
        findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        findPane.add((Component)this.searchField);
        Dimension preferred = findPane.getPreferredSize();
        Dimension max = this.derive(preferred, 250);
        Dimension min = this.derive(preferred, 120);
        findPane.setPreferredSize(max);
        findPane.setMaximumSize(max);
        findPane.setMinimumSize(min);
        return findPane;
    }

    private SearchField searchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FIND);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString(34));
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent e) {
                boolean searchRepeat;
                String searchText = e.getSearchText();
                boolean searchForward = e.getDirection() == SearchEvent.Direction.FORWARD;
                boolean bl = searchRepeat = !e.isTriggeredByKeypress();
                if (!InspectorWindowImpl.this.findText(searchText, searchForward, searchRepeat) && searchText.length() > 0) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }

            public void searchCategoryChanged(SearchEvent e) {
            }
        });
        return searchField;
    }

    private boolean findText(String searchText, boolean searchForward, boolean searchRepeat) {
        if (this.currentCard == InspectorCard.NEW_INSPECTOR) {
            return this.newInspector.findText(searchText, searchForward, searchRepeat);
        }
        System.out.println("Find in old inspector not implemented.");
        return false;
    }

    private Dimension derive(Dimension original, int newWidth) {
        return new Dimension(newWidth, original.height);
    }

    class InternalAction
    extends ToggleAction {
        InternalAction(String name, Integer mnemonic, Icon icon, boolean initialState) {
            super(name, icon);
            this.putValue("Check", Boolean.TRUE);
            this.putValue("State", initialState);
            this.putValue("MnemonicKey", mnemonic);
            this.putValue("ActionCommandKey", name);
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (!InspectorWindowImpl.enableListMode()) {
                return;
            }
            if (!InspectorWindowImpl.this.formModeAction.getValue("Name").equals(cmd)) {
                return;
            }
            boolean isNewInspector = InspectorWindowImpl.this.currentCard == InspectorCard.NEW_INSPECTOR;
            InspectorCard card = !isNewInspector ? InspectorCard.NEW_INSPECTOR : InspectorCard.OLD_INSPECTOR;
            InspectorWindowImpl.this.setCurrentCard(card);
            InspectorWindowImpl.this.delayedRefresh();
        }
    }

    private static class LinksDropDown
    extends MenuToolButton {
        private int actionCount;

        LinksDropDown() {
            super((ToggleAction)null);
            this.setText(InspectorArb.getString(30));
        }

        int actionCount() {
            return this.actionCount;
        }

        void setMenuActions(Action[] actions) {
            this.clearActions();
            int n = this.actionCount = actions == null ? 0 : actions.length;
            if (this.actionCount <= 0) {
                return;
            }
            JPopupMenu menu = this.getPopupMenu();
            for (Action action : actions) {
                menu.add(action);
            }
        }

        void clearActions() {
            this.actionCount = 0;
            this.getPopupMenu().removeAll();
        }

        void updateVisibility() {
            this.setVisible(this.actionCount > 0);
        }
    }

    private class TitleListener
    implements PropertyChangeListener {
        private TitleListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (!"targetDisplayName".equals(e.getPropertyName())) {
                return;
            }
            Object newValue = e.getNewValue();
            String newTitle = newValue != null ? newValue.toString() : "";
            InspectorWindowImpl.this.updateAutoExpandPreferredSizeMap(newTitle);
            InspectorWindowImpl.this.setTitle(newTitle);
        }
    }

    private class TattleTale
    implements PropertyChangeListener {
        private TattleTale() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            InspectorWindowImpl.this.customizerChange(e);
        }
    }

    private static enum InspectorCard {
        OLD_INSPECTOR,
        NEW_INSPECTOR;

    }
}

