/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.inspector.editor.EditorComponentFactory;
import oracle.bali.inspector.editor.EditorComponentFactoryRegistry;
import oracle.bali.inspector.editor.EditorComponentSetup;
import oracle.bali.inspector.editor.EditorComponentSetupRegistry;
import oracle.bali.inspector.editor.TextFieldEditorBehavior;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.inspector.InspectableViewRegistry;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.inspector.editor.CheckBoxEditorFactory;
import oracle.ide.inspector.editor.CheckBoxEditorSetup;
import oracle.ide.inspector.editor.ExtendedTextFieldEditorFactory;
import oracle.ide.inspector.editor.ExtendedTextFieldEditorSetup;
import oracle.ide.inspector.layout.PropertyFormLayoutFactory;
import oracle.ide.layout.ViewId;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.ideimpl.docking.AutoExpander;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.ideimpl.inspector.InspectorDockableFactory;
import oracle.ideimpl.inspector.InspectorWindowImpl;
import oracle.ideimpl.inspector.PIHook;
import oracle.ideimpl.inspector.PopupManager;
import oracle.javatools.icons.OracleIcons;

public class InspectorManagerImpl
extends InspectorManager
implements Addin {
    public static final int TOGGLE_TOOLBAR_CMD_ID;
    public static final int TOGGLE_PAGE_CMD_ID;
    public static final int CUSTOMIZER_CMD_ID;
    public static final int AUTO_EXTEND_CMD_ID;
    public static final int HELP_CMD_ID;
    private static IdeAction CUSTOMIZER_CMD_ACTION;
    private static IdeAction AUTO_EXTEND_CMD_ACTION;
    private static IdeAction HELP_CMD_ACTION;
    public static final String SINGLETON = "SingletonInspectorWindow";
    private static final String SUPPORTERS_PROP = "Inspector.inspectedViews";
    private static final String DETRACTORS_PROP = "Inspector.nonInspectedViews";
    private static final DockableFactory FACTORY;
    private final InspectorController inspectorController = new InspectorController();

    protected InspectorManagerImpl() {
    }

    @Override
    public DockableView showLastView(Context context) {
        DockableView view = super.showLastView(context);
        if (!(view instanceof InspectorWindowImpl)) {
            return view;
        }
        AutoExpander.instance().autoExpand((Dockable)view);
        return view;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        FocusListener[] fListeners;
        KeyboardFocusManager kfm;
        Component fcomp;
        int id = action != null ? action.getCommandId() : -1;
        View view = context.getView();
        if (id == CUSTOMIZER_CMD_ID) {
            if (view instanceof InspectorWindowImpl) {
                ((InspectorWindowImpl)view).showCustomizer();
            }
            return true;
        }
        if (id == AUTO_EXTEND_CMD_ID) {
            if (view instanceof InspectorWindowImpl) {
                ((InspectorWindowImpl)view).enableOrDisableAutoExtend(action.getState());
            }
            return true;
        }
        if (id == HELP_CMD_ID) {
            if (view instanceof InspectorWindowImpl) {
                ((InspectorWindowImpl)view).showHelp();
            }
            return true;
        }
        if ((id == 13 || id == 11) && view instanceof InspectorWindowImpl && (fcomp = (kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getFocusOwner()) != null && (fListeners = fcomp.getFocusListeners()) != null) {
            for (FocusListener flistener : fListeners) {
                if (!(flistener instanceof TextFieldEditorBehavior)) continue;
                FocusEvent fakeEvent = new FocusEvent(fcomp, 1005, false);
                flistener.focusLost(fakeEvent);
            }
        }
        boolean handled = super.handleEvent(action, context);
        if (id == 67) {
            if (!(view instanceof InspectorWindowImpl)) {
                return true;
            }
            DockableView lastView = this.getLastView();
            if (!(lastView instanceof InspectorWindowImpl)) {
                return true;
            }
            if (view == lastView) {
                return true;
            }
            InspectorWindowImpl lastInspectorWindow = (InspectorWindowImpl)lastView;
            Context currentEditorContext = this.currentEditorContext();
            if (currentEditorContext == null) {
                return true;
            }
            lastInspectorWindow.viewSelectionChanged(currentEditorContext);
            return true;
        }
        return handled;
    }

    private Context currentEditorContext() {
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager == null) {
            return null;
        }
        Editor editor = editorManager.getCurrentEditor();
        if (editor == null) {
            return null;
        }
        View editorView = editor.getViewWithoutDecoration();
        if (editorView == null) {
            return null;
        }
        return editorView.getContext();
    }

    public boolean update(IdeAction action, Context context) {
        if (action == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        View view = context.getView();
        if (cmdId == 70) {
            if (!(view instanceof InspectorWindowImpl)) {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == 71) {
            if (!(view instanceof InspectorWindowImpl)) {
                action.setEnabled(false);
            }
            return true;
        }
        boolean updateValue = super.update(action, context);
        return updateValue;
    }

    public void initialize() {
        super.initialize();
        InspectorManager.setInspectorManager(this);
        PropertyFormLayoutFactory.addFormLayoutFactory(PIHook.getPIHook());
        IdeAction action = this.getShowAction();
        Menubar menuMgr = Ide.getMenubar();
        JMenuItem inspectorItem = menuMgr.createMenuItem((ToggleAction)action);
        JMenu viewMenu = MenuManager.getJMenu((String)"View");
        menuMgr.add((Component)inspectorItem, viewMenu, MenuConstants.SECTION_VIEW_ALPHABETIZED_VIEWS);
    }

    protected String getViewCategory() {
        return "InspectorWindow";
    }

    protected String getAcceleratorFile() {
        return "oracle/ideimpl/inspector/accelerators.xml";
    }

    protected String getDefaultName() {
        return SINGLETON;
    }

    protected ViewId getViewId(Context context) {
        if (context != null) {
            return new ViewId(this.getViewCategory());
        }
        return new ViewId(this.getViewCategory());
    }

    protected DockableFactory getDockableFactory() {
        return FACTORY;
    }

    protected IdeAction createShowAction() {
        IdeAction action = IdeAction.get((int)33, (String)AddinManager.getAddinManager().getCommand(33, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)168), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)IdeArb.getInteger((int)169), (ArrayResourceBundle)IdeArb.getInstance(), (int)170, null, (boolean)true);
        action.addController((Controller)this.inspectorController);
        return action;
    }

    protected float getToggleToolbarMenuWeight() {
        return MenuConstants.WEIGHT_VIEW_PROPERTY_INSPECTOR;
    }

    protected IdeAction createToggleToolbarAction() {
        return IdeAction.get((int)TOGGLE_TOOLBAR_CMD_ID, null, (String)InspectorArb.getString(31), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)InspectorArb.getInteger(32), (ArrayResourceBundle)InspectorArb.getInstance(), (int)33, null, (boolean)true);
    }

    protected DockableView createDockableView(Context context, ViewId viewId) {
        InspectorWindowImpl view = new InspectorWindowImpl(viewId.getId());
        if (view != null && context != null) {
            view.setContext(context);
        }
        return view;
    }

    protected DockableView getRelativeView(Context context, ViewId viewId) {
        DockableView lastView = this.getLastView();
        if (lastView != null) {
            return lastView;
        }
        Dockable palette = DockStation.getDockStation().findDockable(new ViewId("PALETTEFACTORY.PALETTE"));
        if (palette instanceof DockableView) {
            return (DockableView)palette;
        }
        return null;
    }

    protected int getOrientation(ViewId viewId, DockableView relative) {
        return relative != null ? 4 : 1;
    }

    @Override
    public boolean supportsInspection(View view) {
        if (view == null) {
            return false;
        }
        Class<?> viewType = view.getClass();
        Class<?> closest = null;
        for (String supporterClassName : InspectableViewRegistry.instance().supporters()) {
            Class<?> supporter = null;
            try {
                supporter = Class.forName(supporterClassName);
            }
            catch (Exception e) {
                continue;
            }
            if (viewType == supporter) {
                return true;
            }
            if (!supporter.isAssignableFrom(viewType)) continue;
            if (closest == null) {
                closest = supporter;
                continue;
            }
            if (!closest.isAssignableFrom(supporter)) continue;
            closest = supporter;
        }
        for (String detractorClassName : InspectableViewRegistry.instance().detractors()) {
            Class<?> detractor = null;
            try {
                detractor = Class.forName(detractorClassName);
            }
            catch (Exception e) {
                continue;
            }
            if (viewType == detractor) {
                return false;
            }
            if (!detractor.isAssignableFrom(viewType)) continue;
            if (closest == null) {
                return false;
            }
            if (!closest.isAssignableFrom(detractor)) continue;
            return false;
        }
        return closest != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdeAction getCustomizerCmdAction() {
        Class<InspectorManagerImpl> clazz = InspectorManagerImpl.class;
        synchronized (InspectorManagerImpl.class) {
            if (CUSTOMIZER_CMD_ACTION == null) {
                CUSTOMIZER_CMD_ACTION = IdeAction.get((int)CUSTOMIZER_CMD_ID, null, (String)InspectorArb.getString(23));
                CUSTOMIZER_CMD_ACTION.putValue("SmallIcon", (Object)InspectorArb.getIcon(24));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return CUSTOMIZER_CMD_ACTION;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdeAction getAutoExtendCmdAction() {
        Class<InspectorManagerImpl> clazz = InspectorManagerImpl.class;
        synchronized (InspectorManagerImpl.class) {
            if (AUTO_EXTEND_CMD_ACTION == null) {
                AUTO_EXTEND_CMD_ACTION = IdeAction.get((int)AUTO_EXTEND_CMD_ID, null, (String)InspectorArb.getString(26));
                AUTO_EXTEND_CMD_ACTION.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"pi_autoextend.png"));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return AUTO_EXTEND_CMD_ACTION;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdeAction getHelpAction() {
        Class<InspectorManagerImpl> clazz = InspectorManagerImpl.class;
        synchronized (InspectorManagerImpl.class) {
            if (HELP_CMD_ACTION == null) {
                HELP_CMD_ACTION = IdeAction.get((int)HELP_CMD_ID, null, (String)InspectorArb.getString(17));
                HELP_CMD_ACTION.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"help.png"));
                HELP_CMD_ACTION.putValue("MnemonicKey", (Object)18);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return HELP_CMD_ACTION;
        }
    }

    static {
        StringTokenizer tokenizer;
        TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID((String)"Inspector.TOGGLE_TOOLBAR_CMD_ID");
        TOGGLE_PAGE_CMD_ID = Ide.findOrCreateCmdID((String)"Inspector.TOGGLE_PAGE_CMD_ID");
        CUSTOMIZER_CMD_ID = Ide.findOrCreateCmdID((String)"Inspector.CUSTOMIZER_CMD_ID");
        AUTO_EXTEND_CMD_ID = Ide.findOrCreateCmdID((String)"Inspector.AUTO_EXTEND_CMD_ID");
        HELP_CMD_ID = Ide.findOrCreateCmdID((String)"Inspector.HELP_CMD_ID");
        FACTORY = new InspectorDockableFactory();
        String views = Ide.getProperty((String)SUPPORTERS_PROP);
        InspectableViewRegistry registry = InspectableViewRegistry.instance();
        if (views != null) {
            tokenizer = new StringTokenizer(views, ";");
            while (tokenizer.hasMoreTokens()) {
                registry.registerSupporter(tokenizer.nextToken());
            }
        }
        if ((views = Ide.getProperty((String)DETRACTORS_PROP)) != null) {
            tokenizer = new StringTokenizer(views, ";");
            while (tokenizer.hasMoreTokens()) {
                registry.registerDetractor(tokenizer.nextToken());
            }
        }
        ExtendedTextFieldEditorFactory extTextFieldEditorFactory = new ExtendedTextFieldEditorFactory();
        EditorComponentFactoryRegistry factoryRegistry = EditorComponentFactoryRegistry.instance();
        factoryRegistry.register((EditorComponentFactory)extTextFieldEditorFactory);
        factoryRegistry.addDefaultEditorFactory((EditorComponentFactory)extTextFieldEditorFactory);
        factoryRegistry.register((EditorComponentFactory)new CheckBoxEditorFactory());
        EditorComponentSetupRegistry setupRegistry = EditorComponentSetupRegistry.instance();
        setupRegistry.register((EditorComponentSetup)new ExtendedTextFieldEditorSetup());
        setupRegistry.register((EditorComponentSetup)new CheckBoxEditorSetup());
        PopupManager.install();
    }

    private static class InspectorController
    implements Controller {
        private InspectorController() {
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == 33) {
                action.setEnabled(InspectorManager.getInspectorManager() != null);
                return true;
            }
            return false;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == 33) {
                if (InspectorManager.getInspectorManager() != null) {
                    InspectorManager.getInspectorManager().showLastView(context);
                }
                return true;
            }
            return false;
        }
    }
}

