/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.ide.util.MetaClass;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.inspector.layout.AutoExpandPreferredSize;
import oracle.ide.inspector.layout.CategoryLayout;
import oracle.ide.inspector.layout.Choice;
import oracle.ide.inspector.layout.ChoiceGroup;
import oracle.ide.inspector.layout.ChoiceSelector;
import oracle.ide.inspector.layout.CustomComponent;
import oracle.ide.inspector.layout.DisplayGroup;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.Extensible;
import oracle.ide.inspector.layout.ExtensibleGroup;
import oracle.ide.inspector.layout.Property;
import oracle.ide.inspector.layout.PropertyFormLayout;
import oracle.ide.inspector.layout.Row;
import oracle.javatools.util.ModelUtil;

public final class PropertyFormLayoutAssembly
extends PropertyFormLayout {
    private final List<Element> _propertyFormLayouts = new ArrayList<Element>();
    private List<Element> _categoryLayouts;

    public PropertyFormLayoutAssembly(List<Element> propertyFormLayouts) {
        this._propertyFormLayouts.addAll(propertyFormLayouts);
    }

    @Override
    public MetaClass getPropertyModelClass() {
        return ((PropertyFormLayout)this._propertyFormLayouts.get(0)).getPropertyModelClass();
    }

    @Override
    public AutoExpandPreferredSize getAutoExtendPreferredSize() {
        AutoExpandPreferredSize size = null;
        for (Element child : this._propertyFormLayouts) {
            if (!(child instanceof PropertyFormLayout)) continue;
            PropertyFormLayout layout = (PropertyFormLayout)child;
            size = AutoExpandPreferredSize.max(size, layout.getAutoExtendPreferredSize());
        }
        if (size == null) {
            size = AutoExpandPreferredSize.DEFAULT;
        }
        return size;
    }

    @Override
    public List<Element> getChildren() {
        if (this._categoryLayouts != null) {
            return this._categoryLayouts;
        }
        this._categoryLayouts = new ArrayList<Element>();
        for (List<Element> l : PropertyFormLayoutAssembly.assemble(this._propertyFormLayouts)) {
            this._categoryLayouts.add(new CategoryLayoutAssembly(l));
        }
        return this._categoryLayouts;
    }

    private static Collection<List<Element>> assemble(List<Element> sources) {
        LinkedHashMap map = new LinkedHashMap();
        HashMap<String, String> map2 = new HashMap<String, String>();
        int idCounter = 0;
        for (Element element : sources) {
            if (element == null) continue;
            for (Element item : element.getChildren()) {
                if (item == null) continue;
                List<Element> list = null;
                String partOf = null;
                String id = null;
                if (item.isExtensible()) {
                    partOf = item.getExtensible().getPartOf();
                    id = item.getExtensible().getID();
                }
                if (id == null) {
                    id = "oracle.ideimpl.inspector.layout.fakeID" + Integer.toString(idCounter++);
                }
                if (ModelUtil.hasLength((String)partOf) && (list = (ArrayList<Element>)map.get(partOf)) == null && map2.containsKey(partOf)) {
                    list = (List)map.get(map2.get(partOf));
                }
                if (list != null) {
                    list.add(item);
                    map2.put(id, partOf);
                    continue;
                }
                list = new ArrayList<Element>();
                list.add(item);
                map.put(id, list);
            }
        }
        return map.values();
    }

    public static class ChoiceSelectorDispatcher
    extends ChoiceSelector {
        private List<MetaClass> _choiceSelectorClasses;
        private List<ChoiceSelector> _choiceSelectors;

        @Override
        public void onActivate(PropertyModel model, String choice) {
            List<ChoiceSelector> choiceSelectors = this.getChoiceSelectors();
            Iterator<ChoiceSelector> i = choiceSelectors.iterator();
            while (i.hasNext()) {
                try {
                    i.next().onActivate(model, choice);
                }
                catch (Exception e) {}
            }
        }

        @Override
        public void onDeactivate(PropertyModel model, String choice) {
            List<ChoiceSelector> choiceSelectors = this.getChoiceSelectors();
            Iterator<ChoiceSelector> i = choiceSelectors.iterator();
            while (i.hasNext()) {
                try {
                    i.next().onDeactivate(model, choice);
                }
                catch (Exception e) {}
            }
        }

        public void setChoiceSelectorClasses(List<MetaClass> classes) {
            this._choiceSelectorClasses = classes;
        }

        public List<ChoiceSelector> getChoiceSelectors() {
            if (this._choiceSelectorClasses != null && this._choiceSelectorClasses.size() > 0 && this._choiceSelectors != null) {
                this._choiceSelectors = new ArrayList<ChoiceSelector>(this._choiceSelectorClasses.size());
                for (MetaClass mclass : this._choiceSelectorClasses) {
                    try {
                        this._choiceSelectors.add((ChoiceSelector)mclass.newInstance());
                    }
                    catch (Exception exception) {}
                }
            }
            return this._choiceSelectors;
        }
    }

    public static final class ChoiceAssembly
    extends Choice {
        private final List<Element> _choices;
        private List<Element> _displayElements;

        public String getID() {
            return ((Choice)this._choices.get(0)).getID();
        }

        @Override
        public String getExtends() {
            return null;
        }

        @Override
        public ExtensibleGroup getBase() {
            return null;
        }

        @Override
        public String getPartOf() {
            return null;
        }

        @Override
        public String getTitle() {
            return ((Choice)this._choices.get(0)).getTitle();
        }

        @Override
        public String getHint() {
            return ((Choice)this._choices.get(0)).getHint();
        }

        @Override
        public boolean isExpanded() {
            return ((Choice)this._choices.get(0)).isExpanded();
        }

        @Override
        public List<Element> getChildren() {
            if (this._displayElements == null) {
                this._displayElements = new ArrayList<Element>();
                Collection assembly = PropertyFormLayoutAssembly.assemble(this._choices);
                for (List list : assembly) {
                    Element element = (Element)list.get(0);
                    if (element instanceof Property) {
                        this._displayElements.add((Property)element);
                        continue;
                    }
                    if (element instanceof Row) {
                        this._displayElements.add((Row)element);
                        continue;
                    }
                    if (element instanceof CustomComponent) {
                        this._displayElements.add((CustomComponent)element);
                        continue;
                    }
                    if (!(element instanceof DisplayGroup)) continue;
                    this._displayElements.add(new DisplayGroupAssembly(list));
                }
            }
            return this._displayElements;
        }

        private ChoiceAssembly(List<Element> choices) {
            this._choices = choices;
        }
    }

    public static final class ChoiceGroupAssembly
    extends ChoiceGroup {
        private final List<Element> _choiceGroups;
        private final MetaClass _choiceSelectorClass = new MetaClass(this.getClass().getClassLoader(), ChoiceSelectorDispatcher.class.getName());
        private List<Element> _choices;
        private ChoiceSelectorDispatcher _choiceSelector;

        @Override
        public MetaClass getChoiceSelectorClass() {
            return this._choiceSelectorClass;
        }

        @Override
        public ChoiceSelector getChoiceSelector() {
            if (this._choiceSelector == null) {
                this._choiceSelector = new ChoiceSelectorDispatcher();
                this._choiceSelector.setChoiceSelectorClasses(this.getChoiceSelectorClasses());
            }
            return this._choiceSelector;
        }

        public String getID() {
            return ((ChoiceGroup)this._choiceGroups.get(0)).getID();
        }

        @Override
        public String getExtends() {
            return null;
        }

        @Override
        public ExtensibleGroup getBase() {
            return null;
        }

        @Override
        public String getPartOf() {
            return null;
        }

        @Override
        public String getTitle() {
            return ((ChoiceGroup)this._choiceGroups.get(0)).getTitle();
        }

        @Override
        public String getHint() {
            return ((ChoiceGroup)this._choiceGroups.get(0)).getHint();
        }

        @Override
        public boolean isExpanded() {
            return ((ChoiceGroup)this._choiceGroups.get(0)).isExpanded();
        }

        @Override
        public List<Element> getChildren() {
            if (this._choices == null) {
                this._choices = new ArrayList<Element>();
                Collection assembly = PropertyFormLayoutAssembly.assemble(this._choiceGroups);
                Iterator i = assembly.iterator();
                while (i.hasNext()) {
                    this._choices.add(new ChoiceAssembly((List)i.next()));
                }
            }
            return this._choices;
        }

        List<MetaClass> getChoiceSelectorClasses() {
            ArrayList<MetaClass> result = new ArrayList<MetaClass>();
            Iterator<Element> i = this._choiceGroups.iterator();
            while (i.hasNext()) {
                result.add(((ChoiceGroup)i.next()).getChoiceSelectorClass());
            }
            return result;
        }

        private ChoiceGroupAssembly(List<Element> choiceGroups) {
            this._choiceGroups = choiceGroups;
        }
    }

    public static final class DisplayGroupAssembly
    extends DisplayGroup {
        private final List<Element> _displayGroups;
        private List<Element> _displayElements;

        public String getID() {
            return ((DisplayGroup)this._displayGroups.get(0)).getID();
        }

        @Override
        public String getExtends() {
            return null;
        }

        @Override
        public String getPartOf() {
            return null;
        }

        @Override
        public ExtensibleGroup getBase() {
            return null;
        }

        @Override
        public String getTitle() {
            return ((DisplayGroup)this._displayGroups.get(0)).getTitle();
        }

        @Override
        public String getHint() {
            return ((DisplayGroup)this._displayGroups.get(0)).getHint();
        }

        @Override
        public boolean isExpanded() {
            return ((DisplayGroup)this._displayGroups.get(0)).isExpanded();
        }

        @Override
        public List<Element> getChildren() {
            if (this._displayElements == null) {
                this._displayElements = new ArrayList<Element>();
                Collection assembly = PropertyFormLayoutAssembly.assemble(this._displayGroups);
                for (List list : assembly) {
                    Element element = (Element)list.get(0);
                    if (element instanceof Property) {
                        this._displayElements.add((Property)element);
                        continue;
                    }
                    if (element instanceof Row) {
                        this._displayElements.add((Row)element);
                        continue;
                    }
                    if (element instanceof CustomComponent) {
                        this._displayElements.add((CustomComponent)element);
                        continue;
                    }
                    if (!(element instanceof ChoiceGroup)) continue;
                    this._displayElements.add(new ChoiceGroupAssembly(list));
                }
            }
            return this._displayElements;
        }

        private DisplayGroupAssembly(List<Element> displayGroups) {
            this._displayGroups = displayGroups;
        }
    }

    public static final class CategoryLayoutAssembly
    extends CategoryLayout {
        private List<Element> _groups;
        private final List<Element> _categoryLayouts;

        private CategoryLayoutAssembly(List<Element> categoryLayouts) {
            this._categoryLayouts = categoryLayouts;
        }

        @Override
        public String getTitle() {
            for (Element e : this._categoryLayouts) {
                String title = ((CategoryLayout)e).getTitle();
                if (!ModelUtil.hasLength((String)title)) continue;
                return title;
            }
            return null;
        }

        @Override
        public String getHint() {
            for (Element e : this._categoryLayouts) {
                String hint = ((CategoryLayout)e).getHint();
                if (!ModelUtil.hasLength((String)hint)) continue;
                return hint;
            }
            return null;
        }

        @Override
        public Boolean isSelected() {
            for (Element e : this._categoryLayouts) {
                Boolean selected = ((CategoryLayout)e).isSelected();
                if (selected == null || !selected.booleanValue()) continue;
                return selected;
            }
            return null;
        }

        @Override
        public Boolean isExpanded() {
            for (Element e : this._categoryLayouts) {
                Boolean expanded = ((CategoryLayout)e).isExpanded();
                if (expanded == null || !expanded.booleanValue()) continue;
                return expanded;
            }
            return null;
        }

        @Override
        public List<Element> getChildren() {
            if (this._groups == null) {
                this._groups = new ArrayList<Element>();
                Collection assembly = PropertyFormLayoutAssembly.assemble(this._categoryLayouts);
                for (List list : assembly) {
                    if (list.get(0) instanceof DisplayGroup) {
                        this._groups.add(new DisplayGroupAssembly(list));
                        continue;
                    }
                    this._groups.add(new ChoiceGroupAssembly(list));
                }
            }
            return this._groups;
        }

        @Override
        public String getExtends() {
            return null;
        }

        @Override
        public Extensible getBase() {
            return null;
        }

        @Override
        public String getPartOf() {
            return null;
        }

        public String getID() {
            return ((CategoryLayout)this._categoryLayouts.get(0)).getID();
        }
    }
}

