/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.ide.inspector.PropertyInfo;

class ValueApplierPropertyChangeListener
implements PropertyChangeListener {
    private volatile boolean updating;
    private final PropertyInfo property;
    private PropertyEditorFactory2 editorFactory;
    private Component editor;

    ValueApplierPropertyChangeListener(PropertyInfo property, PropertyEditorFactory2 editorFactory, Component editor) {
        this.property = property;
        this.attachTo(editorFactory, editor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.editorFactory == null || this.editor == null) {
            return;
        }
        if (this.updating) {
            return;
        }
        this.updating = true;
        try {
            this.property.updateModelValue(this.editorFactory.getValue());
        }
        finally {
            this.updating = false;
        }
        if (this.editorFactory.isPaintable()) {
            this.editor.repaint();
        }
    }

    void attachTo(PropertyEditorFactory2 editorFactory, Component editor) {
        this.editorFactory = editorFactory;
        this.editor = editor;
        this.editorFactory.addPropertyChangeListener((PropertyChangeListener)this);
    }

    void detach() {
        if (this.editorFactory != null) {
            this.editorFactory.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.editorFactory = null;
        this.editor = null;
    }
}

