/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import oracle.ide.inspector.Backgrounds;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.PropertyInfo;
import oracle.javatools.status.Issue;
import oracle.javatools.status.Severity;
import oracle.javatools.ui.Borders;
import oracle.javatools.util.ModelUtil;

final class ValidationIssues {
    private static final Color FOCUS_BORDER = new Color(102, 153, 255);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String HAS_ISSUES_PROPERTY = "hasIssues";

    static void addValidationIssues(Component editor, PropertyInfo property, Orientation orientation) {
        ValidationIssues.addValidationIssuesToEditor(editor, property, orientation);
        ValidationIssues.addFocusBorderToEditor(editor, orientation);
    }

    static void addValidationIssuesToEditor(Component editor, PropertyInfo property, Orientation orientation) {
        if (editor == null) {
            return;
        }
        if (!(editor instanceof JComponent)) {
            return;
        }
        JComponent c = (JComponent)editor;
        c.setToolTipText(null);
        Collection<? extends Issue> issues = property.validationIssues();
        if (issues == null || issues.isEmpty()) {
            c.putClientProperty(HAS_ISSUES_PROPERTY, null);
            if (c.hasFocus() && ValidationIssues.canHaveFocusBorder(editor)) {
                ValidationIssues.attachFocusBorder(c, orientation);
            } else {
                Borders.restoreBorder((JComponent)c);
            }
            return;
        }
        if (ValidationIssues.hasErrors(issues)) {
            ValidationIssues.addErrorBorderAndTooltip(c, issues);
            return;
        }
        if (ValidationIssues.hasWarnings(issues)) {
            ValidationIssues.addWarningBorderAndTooltip(c, issues);
            return;
        }
    }

    private static boolean hasErrors(Collection<? extends Issue> allIssues) {
        return ValidationIssues.hasIssuesWithSeverity(allIssues, Severity.ERROR);
    }

    private static boolean hasWarnings(Collection<? extends Issue> allIssues) {
        return ValidationIssues.hasIssuesWithSeverity(allIssues, Severity.WARNING);
    }

    private static boolean hasIssuesWithSeverity(Collection<? extends Issue> allIssues, Severity severity) {
        for (Issue issue : allIssues) {
            if (!severity.equals((Object)issue.getSeverity())) continue;
            return true;
        }
        return false;
    }

    private static void addFocusBorderToEditor(Component editor, final Orientation orientation) {
        if (!ValidationIssues.canHaveFocusBorder(editor)) {
            return;
        }
        final JComponent c = (JComponent)editor;
        editor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (c.getClientProperty(ValidationIssues.HAS_ISSUES_PROPERTY) == null) {
                    ValidationIssues.attachFocusBorder(c, orientation);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (c.getClientProperty(ValidationIssues.HAS_ISSUES_PROPERTY) == null) {
                    Borders.restoreBorder((JComponent)c);
                }
            }
        });
    }

    private static boolean canHaveFocusBorder(Component editor) {
        if (editor instanceof JTextComponent) {
            return true;
        }
        if (editor instanceof JComboBox) {
            return ((JComboBox)editor).isEditable();
        }
        return false;
    }

    private static void attachFocusBorder(JComponent c, Orientation orientation) {
        Borders.attachBorder((JComponent)c, (Color)FOCUS_BORDER, (Color)Backgrounds.backgroundFor(orientation));
    }

    private static void addWarningBorderAndTooltip(JComponent editor, Collection<? extends Issue> issues) {
        editor.putClientProperty(HAS_ISSUES_PROPERTY, true);
        Borders.attachWarningBorder((JComponent)editor);
        editor.setToolTipText(ValidationIssues.toolTip(issues, editor.getFont()));
    }

    private static void addErrorBorderAndTooltip(JComponent editor, Collection<? extends Issue> issues) {
        editor.putClientProperty(HAS_ISSUES_PROPERTY, true);
        Borders.attachErrorBorder((JComponent)editor);
        editor.setToolTipText(ValidationIssues.toolTip(issues, editor.getFont()));
    }

    private static String toolTip(Collection<? extends Issue> issues, Font font) {
        StringBuilder b = new StringBuilder("<html><pre ");
        b.append(ValidationIssues.createCSSStyle(font));
        b.append(">");
        Iterator<? extends Issue> i = issues.iterator();
        while (i.hasNext()) {
            String message = i.next().getMessage();
            if (!ModelUtil.hasLength((String)message)) continue;
            b.append(message);
            if (!i.hasNext()) continue;
            b.append(LINE_SEPARATOR);
        }
        b.append("</pre></html>");
        return b.toString();
    }

    private static String createCSSStyle(Font font) {
        StringBuilder rule = new StringBuilder("style=\"");
        if (font != null) {
            rule.append("font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        rule.append("\"");
        return rule.toString();
    }

    private ValidationIssues() {
    }
}

