/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.inspector.Orientation;
import oracle.ide.util.PropertyAccess;

public class UserSelectedCategories {
    private static final int CACHE_SIZE = 200;
    private final Map<String, Boolean> selected = UserSelectedCategories.createCache();
    private final Map<String, Boolean> unselected = UserSelectedCategories.createCache();
    private static final String SELECTED_CATEGORY = "Inspector.selectedCategory.";
    private static final String UNSELECTED_CATEGORY = "Inspector.unselectedCategory.";
    private static final String COUNT = "count";
    private boolean enabled;
    private Orientation orientation;

    public UserSelectedCategories() {
        this(true);
    }

    UserSelectedCategories(boolean enabled) {
        this.enabled = enabled;
    }

    boolean enabled() {
        return this.enabled;
    }

    private static Map<String, Boolean> createCache() {
        return new LRUMap<String, Boolean>(200);
    }

    void orientation(Orientation orientation) {
        if (!this.enabled) {
            return;
        }
        this.orientation = orientation;
    }

    void userSelected(String category) {
        if (!this.enabled) {
            return;
        }
        if (Orientation.HORIZONTAL.equals((Object)this.orientation)) {
            this.unselected.putAll(this.selected);
            this.selected.clear();
        }
        this.selected.put(category, Boolean.TRUE);
        this.unselected.remove(category);
    }

    void userUnselected(String category) {
        if (!this.enabled) {
            return;
        }
        this.selected.remove(category);
        this.unselected.put(category, Boolean.TRUE);
    }

    boolean isSelected(String category) {
        return this.selected.containsKey(category);
    }

    boolean isUnselected(String category) {
        return this.unselected.containsKey(category);
    }

    boolean hasSelection() {
        return !this.selected.isEmpty();
    }

    String firstSelected() {
        return this.lastOf(this.orderedSelection());
    }

    String lastSelected() {
        return this.firstOf(this.orderedSelection());
    }

    private List<String> orderedSelection() {
        return this.orderedKeysOf(this.selected);
    }

    String firstUnselected() {
        return this.lastOf(this.orderedUnselection());
    }

    String lastUnselected() {
        return this.firstOf(this.orderedUnselection());
    }

    private String lastOf(List<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    private List<String> orderedUnselection() {
        return this.orderedKeysOf(this.unselected);
    }

    private String firstOf(List<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private List<String> orderedKeysOf(Map<String, Boolean> map) {
        ArrayList<String> orderedKeys = new ArrayList<String>();
        Set<String> keys = map.keySet();
        if (!keys.isEmpty()) {
            orderedKeys.addAll(keys);
        }
        Collections.reverse(orderedKeys);
        return orderedKeys;
    }

    int selectedCount() {
        return this.selected.size();
    }

    int unselectedCount() {
        return this.unselected.size();
    }

    public void loadFrom(PropertyAccess properties) {
        if (!this.enabled) {
            return;
        }
        this.loadFrom(properties, SELECTED_CATEGORY, this.selected);
        this.loadFrom(properties, UNSELECTED_CATEGORY, this.unselected);
    }

    private void loadFrom(PropertyAccess properties, String propertyName, Map<String, Boolean> map) {
        map.clear();
        String propertyCountName = this.propertyCountName(propertyName);
        int selectedCategoryCount = this.propertyCount(properties, propertyCountName);
        if (selectedCategoryCount <= 0) {
            return;
        }
        for (int i = 0; i < selectedCategoryCount; ++i) {
            String index = this.propertyIndex(propertyName, i);
            String category = properties.getProperty(index, null);
            if (category == null) continue;
            map.put(category, Boolean.TRUE);
        }
    }

    public void saveTo(PropertyAccess properties) {
        if (!this.enabled) {
            return;
        }
        this.removeExisting(properties, SELECTED_CATEGORY);
        this.save(properties, SELECTED_CATEGORY, this.orderedKeysOf(this.selected));
        this.removeExisting(properties, UNSELECTED_CATEGORY);
        this.save(properties, UNSELECTED_CATEGORY, this.orderedKeysOf(this.unselected));
    }

    private void removeExisting(PropertyAccess properties, String propertyName) {
        String propertyCountName = this.propertyCountName(propertyName);
        int selectedCategoryCount = this.propertyCount(properties, propertyCountName);
        properties.removeProperty(propertyCountName);
        if (selectedCategoryCount <= 0) {
            return;
        }
        for (int i = 0; i < selectedCategoryCount; ++i) {
            properties.removeProperty(this.propertyIndex(propertyName, i));
        }
    }

    private void save(PropertyAccess properties, String propertyName, List<String> values) {
        String propertyCountName = this.propertyCountName(propertyName);
        int valueCount = values.size();
        properties.setProperty(propertyCountName, String.valueOf(valueCount));
        if (valueCount == 0) {
            return;
        }
        for (int i = 0; i < valueCount; ++i) {
            String propertyIndex = this.propertyIndex(propertyName, i);
            properties.setProperty(propertyIndex, values.get(i));
        }
    }

    private int propertyCount(PropertyAccess properties, String propertyCountName) {
        try {
            return Integer.parseInt(properties.getProperty(propertyCountName, "0"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private String propertyCountName(String propertyName) {
        return propertyName + COUNT;
    }

    private String propertyIndex(String propertyName, int i) {
        return propertyName + i;
    }

    private static class LRUMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final float loadFactor = 0.75f;
        private int cacheSize;

        LRUMap(int cacheSize) {
            super(LRUMap.capacity(cacheSize), 0.75f, true);
            this.cacheSize = cacheSize;
        }

        private static int capacity(int cacheSize) {
            return (int)Math.ceil((float)cacheSize / 0.75f) + 1;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.cacheSize;
        }
    }
}

