/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.inspector.Backgrounds;
import oracle.ide.inspector.CategoryCollection;
import oracle.ide.inspector.CategoryCollectionDisplay;
import oracle.ide.inspector.EmptyPropertyDisplay;
import oracle.ide.inspector.InspectorBundle;
import oracle.ide.inspector.InspectorWindow;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertiesLayoutRenderer;
import oracle.ide.inspector.PropertiesRenderer;
import oracle.ide.inspector.PropertyCategoryPanel;
import oracle.ide.inspector.PropertyDisplay;
import oracle.ide.inspector.PropertyGroupPanel;
import oracle.ide.inspector.RenderingOptimizer;
import oracle.ide.inspector.SearchableCategoryTabbedPane;
import oracle.ide.inspector.SingletonPropertyEditorUpdater;
import oracle.ide.inspector.UserSelectedCategories;
import oracle.ide.inspector.VerticalCategoryCollection;
import oracle.ide.inspector.find.SearchableContainer;
import oracle.ide.inspector.layout.AutoExpandPreferredSize;
import oracle.ide.inspector.layout.CustomComponent;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.PropertyFormLayout;
import oracle.ide.inspector.layout.PropertyFormLayoutFactory;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;

public class PropertyInspector
extends JComponent
implements Accessible,
SearchableContainer,
CategoryCollectionDisplay,
ViewListener {
    protected PropertyModel model;
    protected Properties properties;
    private RenderingOptimizer renderingOptimizer = new RenderingOptimizer();
    private CategoryCollection categoryCollection;
    private SearchableCategoryTabbedPane horizontalCategories;
    private VerticalCategoryCollection verticalCategories;
    private final PropertiesLayoutRenderer propertiesLayoutRenderer;
    private final PropertiesRenderer propertiesRenderer;
    private AutoExpandPreferredSize autoExpandSize;
    private final PropertyDisplay propertyDisplay;
    private Orientation orientation = Orientation.NOT_SET;
    private boolean dynamicOrientation;
    private boolean resizing;
    private UserSelectedCategories userSelectedCategories;
    private Component categoryGUI;

    public PropertyInspector() {
        this(new EmptyPropertyDisplay(), new UserSelectedCategories(false), false);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public PropertyInspector(PropertyDisplay propertyDisplay) {
        this(propertyDisplay, new UserSelectedCategories(false), true);
    }

    public PropertyInspector(PropertyDisplay propertyDisplay, UserSelectedCategories userSelectedCategories) {
        this(propertyDisplay, userSelectedCategories, true);
    }

    private PropertyInspector(PropertyDisplay propertyDisplay, UserSelectedCategories userSelectedCategories, boolean dynamicOrientation) {
        this.userSelectedCategories = userSelectedCategories;
        this.propertyDisplay = propertyDisplay;
        this.dynamicOrientation = dynamicOrientation;
        this.setLayout(new BorderLayout());
        this.horizontalCategories = this.createTabbedCategoryCollection();
        this.propertiesLayoutRenderer = new PropertiesLayoutRenderer(this, this.categoryCollection);
        this.propertiesRenderer = new PropertiesRenderer(this.categoryCollection);
        if (dynamicOrientation) {
            this.verticalCategories = this.createVerticalCategoryCollection();
            this.updateOrientation();
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    PropertyInspector.this.resizing = true;
                    PropertyInspector inspector = PropertyInspector.this;
                    inspector.setVisible(false);
                    Component[] additionalPages = null;
                    if (PropertyInspector.this.categoryCollection != null) {
                        additionalPages = PropertyInspector.this.categoryCollection.additionalPages();
                    }
                    if (PropertyInspector.this.updateOrientation() && additionalPages != null) {
                        PropertyInspector.this.setAdditionalTabPages(additionalPages);
                    }
                    inspector.setVisible(true);
                    PropertyInspector.this.resizing = false;
                }
            });
        } else {
            this.orientation(Orientation.HORIZONTAL);
        }
        this.setOpaque(true);
    }

    @Override
    public UserSelectedCategories userSelectedCategories() {
        return this.userSelectedCategories;
    }

    public void dynamicOrientation(boolean dynamicOrientation) {
        this.dynamicOrientation = dynamicOrientation;
    }

    private boolean updateOrientation() {
        return this.orientation(this.guessOrientation());
    }

    private SearchableCategoryTabbedPane createTabbedCategoryCollection() {
        SearchableCategoryTabbedPane c = new SearchableCategoryTabbedPane(this);
        if (this.dynamicOrientation) {
            c.setBackground(Backgrounds.backgroundFor(Orientation.HORIZONTAL));
        } else {
            c.setBackground(this.getBackground());
        }
        return c;
    }

    private VerticalCategoryCollection createVerticalCategoryCollection() {
        VerticalCategoryCollection c = new VerticalCategoryCollection(this);
        c.setBackground(Backgrounds.backgroundFor(Orientation.VERTICAL));
        return c;
    }

    @Override
    public void categorySelected(PropertyCategoryPanel p) {
        this.updateCurrentCategory();
        if (p == null) {
            return;
        }
        this.renderOrUpdate(p);
        JComponent categoryPanel = p.categoryPanel();
        if (categoryPanel != null) {
            categoryPanel.setVisible(true);
        }
    }

    private void updateCurrentCategory() {
        this.updateCurrentCategory(this.categoryCollection.currentCategory());
    }

    @Override
    public void updateCurrentCategory(String currentCategory) {
        this.renderingOptimizer.updateCurrentCategory(currentCategory);
    }

    public void applyValueFromFocusedComponent() {
        this.renderingOptimizer.applyValueFromFocusedComponent();
    }

    public Component componentWithFocus() {
        return this.renderingOptimizer.componentWithFocus();
    }

    public boolean orientation(Orientation orientation) {
        PropertyModel model;
        this.userSelectedCategories.orientation(orientation);
        if (orientation.equals((Object)this.orientation)) {
            this.revalidate();
            return false;
        }
        this.horizontalCategories.setVisible(false);
        if (this.verticalCategories != null) {
            this.verticalCategories.setVisible(false);
        }
        this.orientation = orientation;
        this.updateCategoryCollection();
        this.matchCategoryCollectionBackgroundColor();
        this.categoryCollection.removeAllCategories();
        this.propertiesLayoutRenderer.update(this.categoryCollection);
        this.propertiesRenderer.update(this.categoryCollection);
        if (this.properties != null && (model = this.properties.model()) != null) {
            this.setPropertyModel(model);
        }
        this.categoryCollection.setVisible(true);
        this.revalidate();
        return true;
    }

    private void matchCategoryCollectionBackgroundColor() {
        if (!this.dynamicOrientation) {
            return;
        }
        this.setBackground(Backgrounds.backgroundFor(this.orientation));
    }

    private void updateCategoryCollection() {
        if (Orientation.VERTICAL.equals((Object)this.orientation)) {
            this.categoryCollection = this.verticalCategories;
            return;
        }
        this.categoryCollection = this.horizontalCategories;
    }

    public String getSelectedCategoryName() {
        return this.categoryCollection.selectedCategoryName();
    }

    public void setSelectedCategoryName(String category) {
        this.categoryCollection.selectedCategoryName(category);
    }

    public String getDefaultSelectedCategoryName() {
        return this.categoryCollection.defaultSelectedCategory();
    }

    @Override
    public boolean findText(String searchText, boolean searchForward, boolean searchRepeat) {
        boolean searchResult = this.textFound(searchText, searchForward, searchRepeat);
        this.updateCurrentCategory();
        this.renderingOptimizer.ensureCorrectRendering();
        return searchResult;
    }

    private boolean textFound(String searchText, boolean searchForward, boolean searchRepeat) {
        if (this.categoryCollection.categoryCount() > 0) {
            return this.categoryCollection.findText(searchText, searchForward, searchRepeat);
        }
        if (this.getComponentCount() > 0) {
            return this.findTextInComponent(this.getComponent(0), searchText, searchForward, searchRepeat);
        }
        return false;
    }

    @Override
    public boolean findTextInComponent(Component c, String searchText, boolean searchForward, boolean searchRepeat) {
        if ((c = this.unwrapScrollPane(c)) instanceof SearchableContainer) {
            this.ensureRendered(c);
            return ((SearchableContainer)((Object)c)).findText(searchText, searchForward, searchRepeat);
        }
        return false;
    }

    private Component unwrapScrollPane(Component c) {
        if (c instanceof JScrollPane) {
            return ((JScrollPane)c).getViewport().getView();
        }
        return c;
    }

    private void ensureRendered(Component c) {
        if ((c = this.unwrapScrollPane(c)) instanceof PropertyCategoryPanel) {
            this.renderOrUpdate((PropertyCategoryPanel)((Object)c));
            return;
        }
        if (!(c instanceof Container)) {
            return;
        }
        for (Component child : ((Container)c).getComponents()) {
            if (child == null) continue;
            this.ensureRendered(child);
        }
    }

    private void renderOrUpdate(PropertyCategoryPanel p) {
        if (p.isRendered()) {
            this.renderingOptimizer.ensureCorrectRendering();
            return;
        }
        p.render(this.properties, this.orientation);
    }

    protected void setStatusText(String text) {
        this.propertyDisplay.showPropertyDescription(text);
    }

    public void setAdditionalTabPages(Component[] additionalPages) {
        if (this.isMultiSelect()) {
            this.categoryCollection.removeAdditionalPages();
            this.categoryCollection.updateComplete(this.properties);
            return;
        }
        this.categoryCollection.additionalTabPages(additionalPages);
        this.categoryCollection.updateComplete(this.properties);
    }

    public void setPropertyModel(PropertyModel model) {
        this.updatePropertyModel(model, false);
    }

    public void updatePropertyEditors(PropertyModel model) {
        this.updatePropertyModel(model, true);
    }

    public void updateValidationIssues() {
        if (this.properties == null || this.renderingOptimizer == null) {
            return;
        }
        this.renderingOptimizer.updateIssues(this.properties, this.orientation);
    }

    private void updatePropertyModel(PropertyModel model, boolean equalModel) {
        if (model == null) {
            this.clean();
            this.disposeCurrentModel();
            return;
        }
        PropertyFormLayout formLayout = this.updateModelAndFindLayout(model);
        this.updateAutoExpandSize(formLayout);
        if (equalModel && this.renderingOptimizer.hasPropertyEditors()) {
            this.updateProperties();
            if (this.isMultiSelect()) {
                this.categoryCollection.removeAdditionalPages();
            }
            this.updateWithoutRedrawing();
            return;
        }
        this.clean();
        this.createProperties();
        this.render(formLayout);
        this.addCategoryGUI();
    }

    private void render(PropertyFormLayout formLayout) {
        boolean isHomogeneousMultiSelect;
        boolean isMultiSelect = this.isMultiSelect();
        boolean bl = isHomogeneousMultiSelect = isMultiSelect && this.properties.isHomogeneousMultiSelect();
        if (isMultiSelect && !isHomogeneousMultiSelect) {
            this.renderHeterogenousMultiselect();
            return;
        }
        if (formLayout != null && (isHomogeneousMultiSelect || !isMultiSelect)) {
            this.renderPropertiesFrom(formLayout);
            return;
        }
        this.renderProperties();
    }

    private Orientation guessOrientation() {
        InspectorWindow w;
        Orientation o;
        if (!this.dynamicOrientation) {
            return Orientation.HORIZONTAL;
        }
        if (this.propertyDisplay instanceof InspectorWindow && (o = Orientation.orientationFor((w = (InspectorWindow)this.propertyDisplay).dockableOrientation())) != null) {
            return o;
        }
        Dimension size = this.getSize();
        double height = size.getHeight();
        if (height == 0.0) {
            return Orientation.HORIZONTAL;
        }
        double ratio = size.getWidth() / height;
        return ratio > 2.85 ? Orientation.HORIZONTAL : Orientation.VERTICAL;
    }

    private boolean isMultiSelect() {
        return this.properties != null && this.properties.isMultiSelect();
    }

    private PropertyFormLayout updateModelAndFindLayout(PropertyModel newModel) {
        PropertyFormLayout formLayout = PropertyInspector.layoutFor(newModel);
        if (!this.resizing) {
            this.disposeCurrentModel();
        }
        this.model = newModel;
        return formLayout;
    }

    private void updateAutoExpandSize(PropertyFormLayout formLayout) {
        this.autoExpandSize = null;
        if (formLayout == null) {
            return;
        }
        this.autoExpandSize = formLayout.getAutoExtendPreferredSize();
    }

    public Dimension autoExpandSize(Dimension titledPanelSize, int orientation) {
        if (this.autoExpandSize == null) {
            this.autoExpandSize = AutoExpandPreferredSize.DEFAULT;
        }
        return this.autoExpandSize.dimension(titledPanelSize, orientation);
    }

    private void addCategoryGUI() {
        this.removeComponentInCenter();
        this.categoryGUI = this.categoryCollection.componentToAddToPI(this.properties);
        if (this.categoryGUI != null) {
            if (!this.dynamicOrientation && this.categoryGUI instanceof JComponent) {
                ((JComponent)this.categoryGUI).setBorder(BorderFactory.createEmptyBorder());
            }
            this.verifyCorrectRendering();
            this.add(this.categoryGUI, "Center");
            return;
        }
        this.verifyCorrectRendering();
    }

    private void verifyCorrectRendering() {
        if (this.categoryCollection != this.horizontalCategories) {
            return;
        }
        PropertyCategoryPanel selected = this.horizontalCategories.selectedPropertyCategoryPanel();
        if (selected == null || selected.isRendered()) {
            return;
        }
        selected.render(this.properties, Orientation.HORIZONTAL);
    }

    Component categoryGUI() {
        return this.categoryGUI;
    }

    private void removeComponentInCenter() {
        BorderLayout layout = (BorderLayout)this.getLayout();
        Component inCenter = layout.getLayoutComponent("Center");
        if (inCenter != null) {
            this.remove(inCenter);
        }
    }

    private void updateWithoutRedrawing() {
        this.renderingOptimizer.update(this.properties, SingletonPropertyEditorUpdater.instance(), this.orientation);
    }

    private void updateProperties() {
        if (this.properties == null) {
            this.createProperties();
            return;
        }
        this.properties.update(this.model, this.renderingOptimizer);
    }

    private void renderPropertiesFrom(PropertyFormLayout formLayout) {
        if (this.properties.isEmpty() && this.atLeastOneCustomComponentIn(formLayout)) {
            this.properties.thereIsCustomComponents();
        }
        if (this.properties.isEmpty()) {
            return;
        }
        this.propertiesLayoutRenderer.render(this.properties, formLayout, this.orientation);
        this.renderPropertiesInOtherCategory();
    }

    private void renderPropertiesInOtherCategory() {
        Properties notRendered = this.properties.notRendered();
        if (notRendered.isEmpty()) {
            return;
        }
        List<String> groups = notRendered.organizeByGroups();
        if (groups == null || groups.isEmpty()) {
            this.renderInOtherCategory(notRendered);
            return;
        }
        for (String group : groups) {
            if (this.categoryCollection.hasCategory(group)) continue;
            PropertyGroupPanel panel = new PropertyGroupPanel(group);
            panel.renderAll(notRendered.propertiesInGroup(group), this.orientation);
            if (panel.getComponentCount() <= 0) continue;
            this.categoryCollection.addCategory(panel, this.properties);
        }
        Properties otherProperties = notRendered.notRendered();
        if (otherProperties.isEmpty()) {
            return;
        }
        this.renderInOtherCategory(otherProperties);
    }

    private void renderInOtherCategory(Properties otherProperties) {
        String title = InspectorBundle.get("OTHER_CATEGORY_NAME");
        PropertyGroupPanel panel = new PropertyGroupPanel(title);
        panel.renderAll(otherProperties, this.orientation);
        if (panel.getComponentCount() > 0) {
            this.categoryCollection.addCategory(panel, this.properties);
        }
    }

    private void renderHeterogenousMultiselect() {
        this.propertiesRenderer.renderWithoutGroups(this.properties, this.orientation);
    }

    private void renderProperties() {
        this.propertiesRenderer.render(this.properties, this.orientation);
    }

    private void createProperties() {
        this.properties = new Properties(this.model, this.renderingOptimizer, this.propertyDisplay);
    }

    private void clean() {
        if (this.properties != null) {
            this.properties.dispose();
        }
        this.properties = null;
        this.renderingOptimizer.clear();
        this.categoryCollection.removeAllCategories();
    }

    private static PropertyFormLayout layoutFor(PropertyModel model) {
        return PropertyFormLayoutFactory.getPropertyFormLayout(model);
    }

    public PropertyModel getPropertyModel() {
        return this.properties != null ? this.properties.model() : null;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePropertyInspector();
        }
        return this.accessibleContext;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            Rectangle clip = g.getClipBounds();
            g.setColor(this.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (!this.dynamicOrientation) {
            this.horizontalCategories.setBackground(bg);
        }
    }

    public void viewActivated(ViewEvent e) {
    }

    public void viewDeactivated(ViewEvent e) {
    }

    public void viewClosed(ViewEvent e) {
        if (e.getView() instanceof InspectorWindow) {
            this.disposeCurrentModel();
        }
    }

    private void disposeCurrentModel() {
        if (this.model != null) {
            this.model.dispose();
            this.model = null;
        }
    }

    private boolean atLeastOneCustomComponentIn(Element parent) {
        for (Element e : parent.getChildren()) {
            if (e instanceof CustomComponent) {
                return true;
            }
            if (!this.atLeastOneCustomComponentIn(e)) continue;
            return true;
        }
        return false;
    }

    Properties getProperties() {
        return this.properties;
    }

    PropertyDisplay getPropertyDisplay() {
        return this.propertyDisplay;
    }

    PropertiesRenderer getPropertiesRenderer() {
        return this.propertiesRenderer;
    }

    PropertiesLayoutRenderer getPropertiesLayoutRenderer() {
        return this.propertiesLayoutRenderer;
    }

    CategoryCollection getCategoryCollection() {
        return this.categoryCollection;
    }

    protected class AccessiblePropertyInspector
    extends JComponent.AccessibleJComponent {
        protected AccessiblePropertyInspector() {
            super(PropertyInspector.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }
    }
}

