/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.bali.inspector.ActionContext;
import oracle.bali.inspector.ActionGroup;
import oracle.bali.inspector.editor.SinglePropertyInfo;
import oracle.ide.inspector.CustomEditorButton;
import oracle.ide.inspector.CustomEditors;
import oracle.ide.inspector.EditorContainer;
import oracle.ide.inspector.LabelContainer;
import oracle.ide.inspector.PropertyInfo;
import oracle.ide.inspector.PropertyLabel;
import oracle.javatools.ui.ExtendedTextField;

final class LabelAndEditor {
    private static final String COLON = ":";
    private static final String MANDATORY_INDICATOR = " *";
    private LabelContainer labelContainer;
    private EditorContainer editorContainer;

    LabelAndEditor(LabelContainer labelContainer, EditorContainer editorContainer) {
        this.labelContainer = labelContainer;
        this.editorContainer = editorContainer;
    }

    LabelAndEditor(PropertyInfo property, EditorContainer editorContainer) {
        this(property.displayName(), property.isMandatory(), editorContainer);
    }

    @Deprecated
    LabelAndEditor(String propertyName, EditorContainer editorContainer) {
        this(propertyName, false, editorContainer);
    }

    LabelAndEditor(String propertyName, boolean mandatory, EditorContainer editorContainer) {
        this.editorContainer = editorContainer;
        Component editor = editorContainer.editor();
        PropertyLabel label = new PropertyLabel(LabelAndEditor.textForLabel(propertyName, mandatory));
        if (editor instanceof JCheckBox) {
            StringBuilder b = new StringBuilder(propertyName);
            LabelAndEditor.addMandoryIndicator(b, mandatory);
            ((JCheckBox)editor).setText(b.toString());
        } else {
            LabelAndEditor.makeAccessible((JLabel)label, editorContainer, propertyName);
        }
        this.labelContainer = new LabelContainer(label);
    }

    static void makeAccessible(JLabel label, EditorContainer editorContainer, PropertyInfo property) {
        LabelAndEditor.makeAccessible(label, editorContainer, property.displayName());
    }

    static void makeAccessible(JLabel label, EditorContainer editorContainer, String propertyName) {
        AccessibleContext labelAccessibleContext = label.getAccessibleContext();
        if (labelAccessibleContext != null) {
            labelAccessibleContext.setAccessibleName(propertyName);
        }
        label.setLabelFor(editorContainer.editor());
    }

    static String textForLabel(PropertyInfo property) {
        return LabelAndEditor.textForLabel(property.displayName(), property.isMandatory());
    }

    private static String textForLabel(String propertyName, boolean mandatory) {
        StringBuilder b = new StringBuilder(propertyName);
        b.append(COLON);
        LabelAndEditor.addMandoryIndicator(b, mandatory);
        return b.toString();
    }

    private static void addMandoryIndicator(StringBuilder text, boolean mandatory) {
        if (mandatory) {
            text.append(MANDATORY_INDICATOR);
        }
    }

    static String textForLabel(String propertyName) {
        return propertyName + COLON;
    }

    void updateWith(LabelAndEditor labelAndEditor) {
        this.labelContainer.updateWith(labelAndEditor.labelContainer());
        this.editorContainer.updateWith(labelAndEditor.editorContainer());
    }

    void updateWith(EditorContainer editorContainer) {
        this.editorContainer.updateWith(editorContainer);
    }

    public LabelContainer labelContainer() {
        return this.labelContainer;
    }

    public EditorContainer editorContainer() {
        return this.editorContainer;
    }

    void addPropertyEditorToContainer() {
        this.editorContainer.addPropertyEditorToContainer();
    }

    void addActionsAndHelpPopupListener(PropertyInfo property) {
        if (this.editorContainer == null) {
            return;
        }
        Component editor = this.editorContainer.editor();
        if (editor == null) {
            return;
        }
        if (this.labelContainer != null) {
            ActionsAndHelpPopupListener.attachTo(this.labelContainer.label(), property, editor);
        }
        ActionsAndHelpPopupListener.attachTo(editor, property, editor);
    }

    static class ActionsAndHelpPopupListener
    extends MouseAdapter {
        private PropertyInfo property;
        private Component editor;

        static void attachTo(Component c, PropertyInfo property, Component editor) {
            if (c == null) {
                return;
            }
            if (c instanceof JComboBox) {
                JComboBox combo = (JComboBox)c;
                for (Component child : combo.getComponents()) {
                    ActionsAndHelpPopupListener.attachTo(child, property, editor);
                }
            }
            if (c instanceof ExtendedTextField) {
                ExtendedTextField textField = (ExtendedTextField)c;
                ActionsAndHelpPopupListener.attachTo(textField.getLargerTextArea(), property, editor);
            }
            ArrayList<ActionsAndHelpPopupListener> toRemove = new ArrayList<ActionsAndHelpPopupListener>();
            for (MouseListener l : c.getMouseListeners()) {
                if (!(l instanceof ActionsAndHelpPopupListener)) continue;
                toRemove.add((ActionsAndHelpPopupListener)l);
            }
            for (ActionsAndHelpPopupListener l : toRemove) {
                l.cleanUp();
                c.removeMouseListener(l);
            }
            ActionsAndHelpPopupListener l = new ActionsAndHelpPopupListener(property, editor);
            c.addMouseListener(l);
        }

        ActionsAndHelpPopupListener(PropertyInfo property, Component editor) {
            this.property = property;
            this.editor = editor;
        }

        void cleanUp() {
            this.property = null;
            this.editor = null;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.property == null || this.editor == null) {
                return;
            }
            if (e.getButton() != 3) {
                return;
            }
            if (e.getClickCount() != 1) {
                return;
            }
            Component c = e.getComponent();
            Window w = null;
            if (c != null) {
                w = SwingUtilities.getWindowAncestor(c);
            }
            List<ActionGroup> actions = CustomEditors.actionGroups(this.property);
            ActionContext context = new ActionContext(this.editor, (SinglePropertyInfo)this.property);
            CustomEditorButton.renderAndShowPopupDialog(actions, context, this.property, w, e.getLocationOnScreen());
        }
    }
}

