/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import oracle.ide.inspector.DisplayGroupPanel;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.ScrollToVisibleFocusListeners;
import oracle.ide.inspector.layout.DisplayGroup;
import oracle.ide.inspector.layout.Element;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderEvent;
import oracle.javatools.ui.HeaderListener;

class HorizontalDisplayGroupPanel
extends DisplayGroupPanel {
    private JLabel hintLabel;
    private Header header;

    HorizontalDisplayGroupPanel(DisplayGroup group, Properties properties, Orientation orientation) {
        super(group, properties, orientation);
    }

    HorizontalDisplayGroupPanel(List<Element> group, Properties properties, Orientation orientation) {
        super(group, properties, orientation);
    }

    @Override
    void expanded(boolean isExpanded) {
        if (this.header == null) {
            return;
        }
        if (isExpanded) {
            this.showTargetPanel();
        } else {
            this.hideTargetPanel();
        }
        if (this.hintLabel == null) {
            return;
        }
        this.hintLabel.setVisible(isExpanded);
    }

    @Override
    boolean isExpanded() {
        if (this.header == null) {
            return true;
        }
        return this.header.isExpanded();
    }

    @Override
    void setUpHeader(boolean expanded) {
        this.header = new Header();
        this.header.setText(this.title);
        this.header.setExpandable(true);
        this.header.setExpanded(expanded);
        this.header.addHeaderListener(new HeaderListener(){

            public void headerCollapsed(HeaderEvent event) {
                HorizontalDisplayGroupPanel.this.expanded(false);
            }

            public void headerExpanded(HeaderEvent event) {
                HorizontalDisplayGroupPanel.this.expanded(true);
            }
        });
        this.header.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.header, this.constraints());
        this.expanded(expanded);
        ScrollToVisibleFocusListeners.addScrollToVisibleFocusListener((Component)this.header);
        this.addSeparator();
    }

    private void addSeparator() {
        ++this.constraints().gridy;
        this.add((Component)new JSeparator(), this.constraints());
    }

    @Override
    void addHintWhenHavingTitle() {
        if (!this.hasHint()) {
            return;
        }
        this.addVerticalSpace(1);
        ++this.constraints().gridy;
        this.hintLabel = new JLabel(this.hint);
        this.hintLabel.setForeground(HINT_FOREGROUND);
        this.add((Component)this.hintLabel, this.constraints());
        ++this.constraints().gridy;
    }
}

