/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.inspector.AbstractCustomEditorAction;
import oracle.bali.inspector.AbstractCustomEditorButton;
import oracle.bali.inspector.ActionContext;
import oracle.bali.inspector.ActionGroup;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.editor.SinglePropertyInfo;
import oracle.ide.Ide;
import oracle.ide.inspector.ContextActionPanel;
import oracle.ide.inspector.ContextActionPanelHost;
import oracle.ide.inspector.InspectorBundle;
import oracle.ide.inspector.LazyLoadMenuItem;
import oracle.ide.inspector.PropertyInfo;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.icons.OracleIcons;

public class CustomEditorButton
extends AbstractCustomEditorButton {
    private static final Icon NORMAL_ARROW = OracleIcons.getIcon((String)"pi_action_enabled.png");
    private static final Icon PRESSED_ARROW = OracleIcons.getIcon((String)"pi_action_down.png");
    private static final Icon MOUSEOVER_ARROW = OracleIcons.getIcon((String)"pi_action_over.png");
    private static final Dimension NULL_DIMENSION = new Dimension(0, 0);
    private Border dropDownWithoutFocusBorder;
    private Border dropDownWithFocusBorder;
    private static JPopupMenu menu;
    private static ContextActionPanel contextActionPanel;
    private static ContextActionPanelHost contextActionPanelHost;

    public static void hidePopup() {
        contextActionPanelHost.setVisible(false);
    }

    CustomEditorButton(PropertyInfo property, Component editorComponent) {
        this(property.editorFactory(), property.model(), property.row, editorComponent);
    }

    public CustomEditorButton(PropertyEditorFactory2 propertyEditor, PropertyModel model, int row, Component editorComponent) {
        super(propertyEditor, model, row, editorComponent);
        this.setOpaque(true);
        contextActionPanelHost.content(contextActionPanel);
    }

    @Deprecated
    public void releaseActionContext() {
    }

    public void setActionGroups(List<ActionGroup> groups) {
        if (this.actionCount(groups) == 1) {
            Action singleAction = this.singleAction(groups);
            if (singleAction instanceof AbstractCustomEditorAction) {
                this.renderAsSimpleButton(singleAction);
            } else {
                this.renderAsDropDownList(groups);
            }
        } else {
            this.renderAsDropDownList(groups);
        }
    }

    private void renderAsSimpleButton(Action singleAction) {
        this.setMargin(new Insets(0, 2, 0, 2));
        this.setText("...");
        this.getAccessibleContext().setAccessibleName(this.advancedEditorScreenReaderLabel());
        for (ActionListener l : this.getActionListeners()) {
            this.removeActionListener(l);
        }
        this.addActionListener(singleAction);
    }

    private String advancedEditorScreenReaderLabel() {
        int key = 35;
        return InspectorArb.getString(key);
    }

    private void renderAsDropDownList(List<ActionGroup> groups) {
        this.setContentAreaFilled(false);
        Border border = this.dropDownWithoutFocusBorder();
        if (this.hasFocus()) {
            border = this.dropDownWithFocusBorder();
        }
        this.setBorder(border);
        this.setAction(this.popUpDialogAction(groups));
        this.setIcon(NORMAL_ARROW);
        this.getAccessibleContext().setAccessibleName(this.actionsButtonScreenReaderLabel());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CustomEditorButton.this.setIcon(PRESSED_ARROW);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CustomEditorButton.this.setIcon(NORMAL_ARROW);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CustomEditorButton.this.setIcon(MOUSEOVER_ARROW);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CustomEditorButton.this.setIcon(NORMAL_ARROW);
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                CustomEditorButton.this.setBorder(CustomEditorButton.this.dropDownWithoutFocusBorder());
            }

            @Override
            public void focusGained(FocusEvent e) {
                CustomEditorButton.this.setBorder(CustomEditorButton.this.dropDownWithFocusBorder());
            }
        });
        String tooltip = InspectorBundle.get("PROPERTY_ACTION_MENU_TOOLTIP");
        this.setToolTipText(tooltip);
        this.hidePopupMenuOnEditorFocus(this.getEditorComponent());
    }

    private String actionsButtonScreenReaderLabel() {
        int key = 36;
        return InspectorArb.getString(key);
    }

    private Border dropDownWithoutFocusBorder() {
        if (this.dropDownWithoutFocusBorder != null) {
            return this.dropDownWithoutFocusBorder;
        }
        this.dropDownWithoutFocusBorder = new EmptyBorder(2, 2, 2, 2);
        return this.dropDownWithoutFocusBorder;
    }

    private Border dropDownWithFocusBorder() {
        if (this.dropDownWithFocusBorder != null) {
            return this.dropDownWithFocusBorder;
        }
        Border outside = UIManager.getBorder("List.focusCellHighlightBorder");
        EmptyBorder inside = new EmptyBorder(1, 1, 1, 1);
        this.dropDownWithFocusBorder = BorderFactory.createCompoundBorder(outside, inside);
        return this.dropDownWithFocusBorder;
    }

    private int actionCount(List<ActionGroup> groups) {
        int totalActions = 0;
        for (ActionGroup group : groups) {
            if (group == null) continue;
            totalActions += group.size();
        }
        return totalActions;
    }

    private Action popUpMenuAction(final List<ActionGroup> groups) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionContext context = CustomEditorButton.this.createActionContext();
                if (groups.isEmpty()) {
                    return;
                }
                menu = new JPopupMenu();
                Iterator it = groups.iterator();
                while (it.hasNext()) {
                    ActionGroup group = (ActionGroup)it.next();
                    for (Action action : group) {
                        ActionContext.updateContextIn((Action)action, (ActionContext)context);
                        LazyLoadMenuItem menuItem = new LazyLoadMenuItem(action, context, CustomEditorButton.this);
                        menu.add(menuItem);
                    }
                    if (!it.hasNext()) continue;
                    menu.addSeparator();
                }
                menu.show((Component)((Object)CustomEditorButton.this), 0, CustomEditorButton.this.getHeight());
            }
        };
        return action;
    }

    private Action popUpDialogAction(final List<ActionGroup> groups) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (groups.isEmpty()) {
                    return;
                }
                Point l = CustomEditorButton.this.getLocationOnScreen();
                Dimension d = CustomEditorButton.this.getSize();
                int x = l.x;
                int y = l.y + d.height;
                CustomEditorButton.this.renderAndShowPopupDialog(groups, new Point(x, y));
            }
        };
        return action;
    }

    private void renderAndShowPopupDialog(List<ActionGroup> groups, Point where) {
        ActionContext context = this.createActionContext();
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this));
        CustomEditorButton.renderAndShowPopupDialog(groups, context, (SinglePropertyInfo)this, w, where);
    }

    static void renderAndShowPopupDialog(List<ActionGroup> groups, ActionContext context, SinglePropertyInfo property, Window parent, Point where) {
        String title;
        int row;
        PropertyModel propertyModel = property.getPropertyModel();
        String desc = propertyModel.getPropertyDescription(row = property.getPropertyModelRow());
        if (desc == null) {
            desc = "";
        }
        contextActionPanel.render(property, context, groups, desc);
        String titleValue = propertyModel.getPropertyDisplayName(row);
        String string = title = titleValue != null ? titleValue.toString() : "";
        if (!contextActionPanelHost.isSameOwner(parent)) {
            ContextActionPanelHost oldHost = contextActionPanelHost;
            if (oldHost.isVisible()) {
                oldHost.setVisible(false);
            }
            contextActionPanelHost = new ContextActionPanelHost(parent);
            contextActionPanelHost.content(contextActionPanel);
            oldHost.dispose();
        }
        contextActionPanelHost.title(title);
        contextActionPanelHost.pack();
        Point realWhere = where;
        if (property instanceof CustomEditorButton) {
            Dimension buttonSize = ((CustomEditorButton)property).getSize();
            realWhere = CustomEditorButton.whereToShowPopup(buttonSize, where);
        } else {
            realWhere = CustomEditorButton.whereToShowPopup(NULL_DIMENSION, where);
        }
        contextActionPanelHost.setLocation(realWhere);
        contextActionPanelHost.setVisible(true);
        contextActionPanelHost.giveFocus();
    }

    private static Point whereToShowPopup(Dimension invokerSize, Point where) {
        int height;
        int x = where.x;
        int y = where.y;
        Dimension screenSize = CustomEditorButton.screenSize();
        int width = contextActionPanelHost.getWidth();
        if (x + width > screenSize.width && (x = x - width + invokerSize.width) < 0) {
            x = 0;
        }
        if (y + (height = contextActionPanelHost.getHeight()) > screenSize.height && (y = y - height + invokerSize.height) < 0) {
            y = 0;
        }
        return new Point(x, y);
    }

    private static Dimension screenSize() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = e.getDefaultScreenDevice().getDefaultConfiguration();
        Toolkit t = Toolkit.getDefaultToolkit();
        Insets insets = t.getScreenInsets(gc);
        Dimension screenSize = t.getScreenSize();
        screenSize.width -= insets.left + insets.right;
        screenSize.height -= insets.top + insets.bottom;
        return screenSize;
    }

    private void hidePopupMenuOnEditorFocus(Component c) {
        if (c instanceof JComboBox) {
            final Component boxEditor = ((JComboBox)c).getEditor().getEditorComponent();
            boxEditor.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (menu != null && menu.isVisible()) {
                        menu.setVisible(false);
                        boxEditor.requestFocusInWindow();
                    }
                    if (contextActionPanelHost != null) {
                        contextActionPanelHost.setVisible(false);
                        boxEditor.requestFocusInWindow();
                    }
                }
            });
        } else if (c instanceof JComponent) {
            JComponent comp = (JComponent)c;
            int len = comp.getComponentCount();
            for (int i = 0; i < len; ++i) {
                if (!(comp.getComponent(i) instanceof JComboBox)) continue;
                this.hidePopupMenuOnEditorFocus(comp.getComponent(i));
                break;
            }
        }
    }

    private Action singleAction(List<ActionGroup> groups) {
        ActionContext context = this.createActionContext();
        for (ActionGroup group : groups) {
            Iterator i$ = group.iterator();
            if (!i$.hasNext()) continue;
            Action action = (Action)i$.next();
            return ActionContext.updateContextIn((Action)action, (ActionContext)context);
        }
        return null;
    }

    private ActionContext createActionContext() {
        return new ActionContext(this.getEditorComponent(), (AbstractCustomEditorButton)this);
    }

    static {
        contextActionPanel = new ContextActionPanel();
        contextActionPanelHost = new ContextActionPanelHost((Window)Ide.getMainWindow());
    }
}

