/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ide.inspector.ChoiceGroupPanel;
import oracle.ide.inspector.DisplayGroupPanel;
import oracle.ide.inspector.EditorContainer;
import oracle.ide.inspector.LabelAndEditor;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.PropertyInfo;
import oracle.ide.inspector.RenderingUtils;
import oracle.ide.inspector.SingletonPropertyEditorFinder;
import oracle.ide.inspector.Turner;

abstract class AbstractPropertyInspectorPanel
extends JPanel {
    static final int PROPERTY_LEFT_PADDING = 2;
    static final int PROPERTY_FORM_Y_GAP = 4;
    static final int SPACE_BETWEEN_LABEL_AND_EDITOR = 6;
    private boolean hasContent;
    private JPanel targetPanel;
    private final GridBagConstraints constraints;

    AbstractPropertyInspectorPanel() {
        this.setLayout(new GridBagLayout());
        this.constraints = RenderingUtils.initialConstraints();
        AbstractPropertyInspectorPanel.setUpLAF(this);
    }

    static void setUpLAF(JComponent target) {
        target.setBorder(BorderFactory.createEmptyBorder());
        target.setOpaque(true);
    }

    final void renderProperty(PropertyInfo property, Orientation orientation) {
        this.renderProperty(property, 1, 0, orientation);
    }

    final void renderProperty(PropertyInfo property, int editorWidth, int startCell, Orientation orientation) {
        LabelAndEditor labelAndEditor = SingletonPropertyEditorFinder.instance().editorFor(property, orientation);
        this.render(labelAndEditor, editorWidth, startCell, property);
        property.rendered();
    }

    private void render(LabelAndEditor labelAndEditor, int editorWidth, int startCell, PropertyInfo property) {
        Container iconContainer = property.iconContainer();
        LabelAndEditor containers = this.render(iconContainer, labelAndEditor, editorWidth, startCell);
        property.addPropertyEditorInfo(containers, iconContainer);
    }

    final LabelAndEditor render(Container icon, LabelAndEditor labelAndEditor, int editorWidth, int startCell) {
        this.constraints().insets.top = 4;
        this.resetConstraints(startCell);
        this.addToTargetPanel(icon);
        this.addLeftMargin();
        EditorContainer editorContainer = labelAndEditor.editorContainer();
        if (editorContainer.editor() instanceof JCheckBox) {
            this.addCheckBoxEditor(editorContainer, editorWidth);
            return labelAndEditor;
        }
        this.addLabel(labelAndEditor.labelContainer());
        this.addEditor(editorContainer, editorWidth);
        return labelAndEditor;
    }

    private void addCheckBoxEditor(EditorContainer editorContainer, int editorWidth) {
        ++this.constraints().gridx;
        this.constraints().gridwidth = editorWidth + 2;
        this.constraints().insets.left = 0;
        this.constraints().insets.right = 0;
        this.constraints().weightx = 0.0;
        this.constraints().fill = 0;
        this.addToTargetPanel(editorContainer);
        editorContainer.editor().setBackground(this.targetPanel.getBackground());
        this.constraints().gridwidth = 1;
    }

    final void resetConstraints(int startCell) {
        this.constraints().gridx = startCell;
        this.constraints().insets.left = 0;
        this.constraints().weightx = 0.0;
        this.constraints().gridwidth = 1;
        this.constraints().gridheight = 1;
    }

    private void addLeftMargin() {
        this.addLeftMargin(null);
    }

    private void addLeftMargin(List<PropertyInfo> subProperties) {
        ++this.constraints().gridx;
        if (subProperties != null && !subProperties.isEmpty()) {
            this.addTurner();
        } else {
            this.addLeftMarginSpace();
        }
    }

    private void addTurner() {
        this.constraints().insets.right = 2;
        this.addToTargetPanel(new Turner());
        this.constraints().insets.right = 0;
    }

    private void addLeftMarginSpace() {
        this.constraints().insets.right = 0;
        this.addToTargetPanel(Box.createHorizontalStrut(2));
    }

    private void addLabel(Component label) {
        ++this.constraints().gridx;
        this.constraints().gridwidth = 1;
        this.constraints().insets.right = 0;
        this.constraints().fill = 1;
        this.addToTargetPanel(label);
    }

    private void addEditor(Component editor, int gridWidth) {
        ++this.constraints().gridx;
        this.constraints().gridwidth = gridWidth;
        this.constraints().insets.left = 6;
        this.constraints().weightx = 1.0;
        this.constraints().fill = 1;
        this.addToTargetPanel(editor);
        this.constraints().gridwidth = 1;
    }

    final GridBagConstraints constraints() {
        return this.constraints;
    }

    final void updateTargetPanel(JPanel newValue) {
        this.targetPanel = newValue;
    }

    final boolean hasContent() {
        return this.hasContent;
    }

    final void showTargetPanel() {
        this.showOrHideTargetPanel(true);
    }

    final void hideTargetPanel() {
        this.showOrHideTargetPanel(false);
    }

    private void showOrHideTargetPanel(boolean visible) {
        if (this.targetPanel != null) {
            this.targetPanel.setVisible(visible);
        }
    }

    final void addToTargetPanel(Component c) {
        if (!(c instanceof Box.Filler)) {
            this.hasContent = true;
        }
        this.targetPanel.add(c, this.constraints());
    }

    final JPanel targetPanel() {
        return this.targetPanel;
    }

    final void clearTargetPanel() {
        if (this.targetPanel == null) {
            return;
        }
        this.targetPanel.removeAll();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        JPanel targetPanel = this.targetPanel();
        if (targetPanel == null) {
            targetPanel = this;
        }
        if (targetPanel != this) {
            targetPanel.setBackground(bg);
        }
        for (Component c : targetPanel.getComponents()) {
            Component editor;
            if (c instanceof DisplayGroupPanel || c instanceof ChoiceGroupPanel) {
                c.setBackground(bg);
            }
            if (!(c instanceof EditorContainer) || !((editor = ((EditorContainer)c).editor()) instanceof JCheckBox)) continue;
            editor.setBackground(bg);
        }
    }
}

