/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.DefaultKeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLPath;
import oracle.ide.panels.Navigable;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.MenuSpec;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareHints;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.algorithm.directory.DirectoryCompareContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.algorithm.directory.DirectoryList;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.ToolbarView;
import oracle.javatools.compare.view.list.ListCompareView;
import oracle.javatools.compare.view.text.TextCompareView;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.CompareConstants;
import oracle.jdeveloper.compare.CompareManager;
import oracle.jdeveloper.compare.CompareMethod;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdevimpl.compare.CompareController;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.compare.CompareManagerImpl;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.compare.CompareOptions;
import oracle.jdevimpl.compare.ComparePreferencesPanel;
import oracle.jdevimpl.compare.CompareURLHelper;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.compare.SearchNavigable;
import oracle.jdevimpl.resource.CompareArb;

public class CompareAddin
extends EditorAddin {
    private CompareIdeViewer m_compareIdeViewer;
    private MenuSpec m_menuSpec;
    int m_otherFileAction;
    int m_savedFileAction;
    int m_eachOtherAction;
    private MyController m_controller;
    static final String KEY_CONTEXT = "compareKeyContext";
    public static final String COMPARE_DIRECTORY_FILE_CMD = "compare.compareDirectoryFile";
    public static final int COMPARE_DIRECTORY_FILE_CMD_ID = Ide.findOrCreateCmdID((String)"compare.compareDirectoryFile");
    public static final String GO_FIRST_CMD = "compare.navigateFirst";
    public static final int GO_FIRST_CMD_ID = Ide.findOrCreateCmdID((String)"compare.navigateFirst");
    public static final String GO_PREVIOUS_CMD = "compare.navigatePrevious";
    public static final int GO_PREVIOUS_CMD_ID = Ide.findOrCreateCmdID((String)"compare.navigatePrevious");
    public static final String GO_NEXT_CMD = "compare.navigateNext";
    public static final int GO_NEXT_CMD_ID = Ide.findOrCreateCmdID((String)"compare.navigateNext");
    public static final String GO_LAST_CMD = "compare.navigateLast";
    public static final int GO_LAST_CMD_ID = Ide.findOrCreateCmdID((String)"compare.navigateLast");
    private Navigable _compareNavigable;
    private List<CompareMethod> _compareMethods = new ArrayList<CompareMethod>();
    private CompareManagerImpl _manager;
    private static String _createPatchCommand;
    private static int _createPatchCommandId;
    private static Controller _patchController;

    public CompareAddin() {
        this.m_compareIdeViewer = new CompareIdeViewer(this);
    }

    CompareIdeViewer getCompareIdeViewer() {
        return this.m_compareIdeViewer;
    }

    public Navigable getCompareNavigable() {
        return this._compareNavigable;
    }

    public void registerCompareMethod(CompareMethod compareMethod) {
        for (int i = 0; i <= this._compareMethods.size(); ++i) {
            if (i >= this._compareMethods.size()) {
                this._compareMethods.add(compareMethod);
                break;
            }
            CompareType[] compareTypeArray = compareMethod.getFallbackCompareTypes();
            if (compareTypeArray == null || !Arrays.asList(compareTypeArray).contains(this._compareMethods.get(i).getCompareType())) continue;
            this._compareMethods.add(i, compareMethod);
            break;
        }
    }

    public Collection<CompareMethod> getCompareMethods() {
        return Collections.unmodifiableCollection(this._compareMethods);
    }

    private void compareOtherFile(Context context) throws Exception {
        int n;
        CompareContributor compareContributor = null;
        URL uRL = null;
        Locatable[] locatableArray = VCSManager.getVCSManager().getContextLocatables(context);
        try {
            if (locatableArray.length == 1) {
                uRL = this.getSelectionURL(locatableArray[0]);
                if (uRL != null) {
                    compareContributor = this.createContributorFromURL(uRL);
                }
            } else {
                uRL = context.getNode().getURL();
                compareContributor = this.createContributorFromURL(uRL);
            }
        }
        catch (IOException iOException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.format((int)52, (Object)URLFileSystem.getName(uRL)), (String)CompareArb.getString((int)53), null);
            return;
        }
        URLFileChooser uRLFileChooser = new URLFileChooser(context);
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setSelectionScope(uRL == null || !URLFileSystem.isDirectoryPath((URL)uRL) ? 0 : 1);
        if (uRL != null) {
            uRLFileChooser.setSelectedURL(uRL);
        }
        if ((n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), CompareArb.getString((int)26))) == 0) {
            URL uRL2 = uRLFileChooser.getSelectedURL();
            if (URLFileSystem.isDirectoryPath((URL)uRL) != URLFileSystem.isDirectoryPath((URL)uRL2)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.getString((int)9), (String)CompareArb.getString((int)8), null);
            } else if (uRL2 != null && uRL2.equals(uRL)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.getString((int)7), (String)CompareArb.getString((int)6), null);
            } else if (!URLFileSystem.exists((URL)uRL2)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.getString((int)11), (String)CompareArb.getString((int)10), null);
            } else {
                CompareContributor compareContributor2 = this.createContributorFromURL(uRL2);
                this.m_compareIdeViewer.show(compareContributor2, compareContributor);
            }
        }
    }

    private final CompareContributor createContributorFromURL(URL uRL) throws IOException {
        if (CompareUtil.isContentTypeBinary((URL)uRL)) {
            return new BinaryCompareContributor(uRL);
        }
        return URLFileSystem.isDirectoryPath((URL)uRL) ? this.createDirectoryContributor(uRL) : new URLContributor(uRL);
    }

    private void compareSavedFile(Context context) throws Exception {
        URLContributor uRLContributor = null;
        TextNodeContributor textNodeContributor = null;
        Locatable[] locatableArray = VCSManager.getVCSManager().getContextLocatables(context);
        if (locatableArray.length == 0 && context.getNode() != null) {
            uRLContributor = new URLContributor(context.getNode().getURL());
            textNodeContributor = new TextNodeContributor((TextNode)context.getNode());
        }
        if (locatableArray.length > 0) {
            if (locatableArray[0] instanceof TextNode) {
                uRLContributor = new URLContributor(((TextNode)locatableArray[0]).getURL());
                textNodeContributor = new TextNodeContributor((TextNode)locatableArray[0]);
            } else {
                uRLContributor = new URLContributor(context.getNode().getURL());
                textNodeContributor = new TextNodeContributor((TextNode)context.getNode());
            }
        }
        if (uRLContributor == null) {
            Assert.fail();
            return;
        }
        this.m_compareIdeViewer.show((CompareContributor)uRLContributor, textNodeContributor);
    }

    private void compareEachOther(Context context) throws Exception {
        Locatable locatable = null;
        Locatable locatable2 = null;
        Locatable[] locatableArray = VCSManager.getVCSManager().getContextLocatables(context);
        Element[] elementArray = context.getSelection();
        if (locatableArray != null) {
            if (1 <= locatableArray.length) {
                locatable = locatableArray[0];
            }
            if (2 <= locatableArray.length) {
                locatable2 = locatableArray[1];
            }
            if (locatable2 == null) {
                locatable2 = locatable;
            }
        }
        if (elementArray != null) {
            if (1 <= elementArray.length) {
                locatable = elementArray[0];
            }
            if (2 <= elementArray.length) {
                locatable2 = elementArray[1];
            }
        }
        this.m_compareIdeViewer.show(this.createContributorFromURL(this.getSelectionURL(locatable)), this.createContributorFromURL(this.getSelectionURL(locatable2)));
    }

    private CompareContributor createDirectoryContributor(URL uRL) {
        DirectoryCompareContributor directoryCompareContributor = new DirectoryCompareContributor(){};
        directoryCompareContributor.setShortLabel(URLFileSystem.getFileName((URL)uRL));
        directoryCompareContributor.setLongLabel(URLFileSystem.getPlatformPathName((URL)uRL));
        DirectoryList directoryList = new DirectoryList();
        for (final URLFileSystem.FileInfo fileInfo : URLFileSystem.ls((URL)uRL)) {
            directoryList.appendFile(new DirectoryFile(fileInfo.isDirectory(), URLFileSystem.getFileName((URL)fileInfo.getURL()), fileInfo.isDirectory() ? "" : Long.toString(this.computeChecksum(fileInfo.getURL()))){

                public CompareContributor createCompareContributor() throws Exception {
                    URL uRL = fileInfo.getURL();
                    return CompareAddin.this.createContributorFromURL(uRL);
                }
            });
        }
        directoryList.clearModified();
        directoryCompareContributor.setDirectoryList(directoryList);
        return directoryCompareContributor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long computeChecksum(URL uRL) {
        CheckedInputStream checkedInputStream = null;
        try {
            checkedInputStream = new CheckedInputStream(URLFileSystem.openInputStream((URL)uRL), new Adler32());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return 0L;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0L;
        }
        try {
            byte[] byArray = new byte[128];
            while (checkedInputStream.read(byArray) >= 0) {
            }
            long l = checkedInputStream.getChecksum().getValue();
            return l;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            long l = 0L;
            return l;
        }
        finally {
            try {
                checkedInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void initialize() {
        IdeAction ideAction;
        InitialContext initialContext;
        this._manager = new CompareManagerImpl();
        CompareViewFactory.registerCompareView((CompareType)CompareType.TEXT, TextCompareView.class);
        CompareManager.getCompareManager().registerCompareMethod(new CompareMethod(){

            public boolean canCompare(CompareContributor compareContributor, CompareContributor compareContributor2, StreamType streamType) {
                if (!(compareContributor instanceof TextCompareContributor) || !(compareContributor2 instanceof TextCompareContributor)) {
                    return false;
                }
                return streamType != null || this.getStreamType(compareContributor) != null && this.getStreamType(compareContributor2) != null;
            }

            public boolean canMerge(CompareContributor compareContributor, CompareContributor compareContributor2, CompareContributor compareContributor3) {
                if (!(compareContributor instanceof TextCompareContributor && compareContributor2 instanceof TextCompareContributor && compareContributor3 instanceof TextCompareContributor)) {
                    return false;
                }
                return this.getStreamType(compareContributor) != null && this.getStreamType(compareContributor2) != null && this.getStreamType(compareContributor3) != null;
            }

            public CompareType getCompareType() {
                return CompareType.TEXT;
            }
        });
        CompareManager.getCompareManager().registerCompareMethod(new CompareMethod(){

            public boolean canCompare(CompareContributor compareContributor, CompareContributor compareContributor2, StreamType streamType) {
                return compareContributor instanceof DirectoryCompareContributor && compareContributor2 instanceof DirectoryCompareContributor;
            }

            public CompareType getCompareType() {
                return CompareType.DIRECTORY;
            }
        });
        URLFileSystem.registerHelper((String)"ide.compare", (URLFileSystemHelper)new CompareURLHelper());
        EditorManager.getEditorManager().register((EditorAddin)this, new Class[]{CompareNode.class});
        Ide.getMenubar().add((Component)this.m_compareIdeViewer.getMainCompareMenu(), MenuManager.getJMenu((String)"File"), MenuConstants.SECTION_FILE_ADDINS);
        this.m_controller = new MyController();
        String string = CompareArb.getString((int)22);
        Integer n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        string = StringUtils.stripMnemonic((String)string);
        this.m_savedFileAction = Ide.findOrCreateCmdID((String)"compare.CompareDirty");
        IdeAction ideAction2 = IdeAction.get((int)this.m_savedFileAction, null, (String)string, (String)IdeMainWindow.ACTION_CATEGORY_FILE, (Integer)n, null, null, (boolean)true);
        ideAction2.putValue("NoCtxName", (Object)CompareArb.getString((int)23));
        ideAction2.addController((Controller)this.m_controller);
        string = CompareArb.getString((int)20);
        n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        string = StringUtils.stripMnemonic((String)string);
        this.m_otherFileAction = Ide.findOrCreateCmdID((String)"compare.CompareOther");
        IdeAction ideAction3 = IdeAction.get((int)this.m_otherFileAction, null, (String)string, (String)IdeMainWindow.ACTION_CATEGORY_FILE, (Integer)n, null, null, (boolean)true);
        ideAction3.putValue("NoCtxName", (Object)CompareArb.getString((int)21));
        ideAction3.addController((Controller)this.m_controller);
        string = CompareArb.getString((int)24);
        n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        string = StringUtils.stripMnemonic((String)string);
        this.m_eachOtherAction = Ide.findOrCreateCmdID((String)"compare.CompareEachOther");
        IdeAction ideAction4 = IdeAction.get((int)this.m_eachOtherAction, null, (String)string, (String)IdeMainWindow.ACTION_CATEGORY_FILE, (Integer)n, null, null, (boolean)true);
        ideAction4.putValue("NoCtxName", (Object)CompareArb.getString((int)25));
        ideAction4.addController((Controller)this.m_controller);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)ideAction2, 1.0f), this.m_compareIdeViewer.getMainCompareMenu(), 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)ideAction3, 2.0f), this.m_compareIdeViewer.getMainCompareMenu(), 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)ideAction4, 1.0f), this.m_compareIdeViewer.getMainCompareMenu(), 2.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)ideAction2, 1.0f), this.m_compareIdeViewer.getContextCompareMenu(), 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)ideAction3, 2.0f), this.m_compareIdeViewer.getContextCompareMenu(), 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)ideAction4, 1.0f), this.m_compareIdeViewer.getContextCompareMenu(), 2.0f);
        this._compareNavigable = new SearchNavigable(CompareArb.getString((int)27), ComparePreferencesPanel.class, new String[]{CompareArb.getString((int)55), CompareArb.getString((int)56)});
        IdeSettings.registerUI((Navigable)this._compareNavigable);
        final IdeAction ideAction5 = IdeAction.get((int)Ide.findOrCreateCmdID((String)GO_FIRST_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString((int)41)), (String)CompareArb.getString((int)40), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString((int)41))), (ArrayResourceBundle)CompareArb.getInstance(), (int)42, null, (boolean)false);
        final IdeAction ideAction6 = IdeAction.get((int)Ide.findOrCreateCmdID((String)GO_PREVIOUS_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString((int)43)), (String)CompareArb.getString((int)40), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString((int)43))), (ArrayResourceBundle)CompareArb.getInstance(), (int)44, null, (boolean)false);
        final IdeAction ideAction7 = IdeAction.get((int)Ide.findOrCreateCmdID((String)GO_NEXT_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString((int)45)), (String)CompareArb.getString((int)40), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString((int)45))), (ArrayResourceBundle)CompareArb.getInstance(), (int)46, null, (boolean)false);
        final IdeAction ideAction8 = IdeAction.get((int)Ide.findOrCreateCmdID((String)GO_LAST_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString((int)47)), (String)CompareArb.getString((int)40), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString((int)47))), (ArrayResourceBundle)CompareArb.getInstance(), (int)48, null, (boolean)false);
        final IdeAction ideAction9 = IdeAction.get((int)Ide.findOrCreateCmdID((String)COMPARE_DIRECTORY_FILE_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString((int)54)), (String)CompareArb.getString((int)40), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString((int)54))), (ArrayResourceBundle)CompareArb.getInstance(), (int)12, null, (boolean)false);
        ideAction9.addController((Controller)CompareController.getDefaultController());
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public void addinsLoaded(IdeEvent ideEvent) {
                Ide.removeIdeListener((IdeListener)this);
                if (CompareAddin.getCreatePatchCommand() == null) {
                    return;
                }
                IdeAction ideAction = IdeAction.get((int)CompareAddin.getCreatePatchCommandID(), (String)CompareAddin.getCreatePatchCommand(), (String)StringUtils.stripMnemonic((String)CompareArb.getString((int)49)), (String)CompareArb.getString((int)40), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString((int)49))), (ArrayResourceBundle)CompareArb.getInstance(), (int)50, null, (boolean)true);
                ideAction.addController(CompareAddin.getPatchController());
            }
        });
        Ide.getKeyStrokeContextRegistry().addContext((KeyStrokeContext)new DefaultKeyStrokeContext(){
            private Set _actions = new HashSet();
            {
                this._actions.add(ideAction5);
                this._actions.add(ideAction6);
                this._actions.add(ideAction7);
                this._actions.add(ideAction8);
                if (IdeAction.find((int)CompareConstants.CREATE_PATCH_CMD_ID) != null) {
                    this._actions.add(IdeAction.find((int)CompareConstants.CREATE_PATCH_CMD_ID));
                }
                this._actions.add(ideAction9);
            }

            public String getName() {
                return CompareArb.getString((int)40);
            }

            public Set getAllActions(boolean bl) {
                return this._actions;
            }
        });
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), "oracle/jdevimpl/compare/accelerators.xml");
        Ide.getMainWindow().addDynamicMenuListener(new DynamicMenuListener(){

            public JComponent[] gatherDynamicActions(Context context) {
                if (context.getView() instanceof CompareEditor) {
                    return new JComponent[]{Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_FIRST_CMD)), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_PREVIOUS_CMD)), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_NEXT_CMD)), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_LAST_CMD)), 0.0f)};
                }
                return new JComponent[0];
            }
        });
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(new ContextMenuListener(){

            public void menuWillShow(ContextMenu contextMenu) {
                if (contextMenu.getContext().getView() instanceof CompareEditor) {
                    Object[] objectArray;
                    CompareView compareView = ((CompareEditor)contextMenu.getContext().getView()).getCompareView();
                    float f = 1.0f;
                    if (compareView instanceof ListCompareView && ((ListCompareView)compareView).getCompareMode() == CompareMode.TWO_WAY_COMPARE && ((ListCompareView)compareView).isSelectionComparable() && (objectArray = ((ListCompareView)compareView).getSelectionForCompare()) != null && objectArray[0] instanceof DirectoryFile && objectArray[1] instanceof DirectoryFile) {
                        try {
                            ((DirectoryFile)objectArray[0]).getCompareContributor();
                            ((DirectoryFile)objectArray[1]).getCompareContributor();
                            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.COMPARE_DIRECTORY_FILE_CMD))), f);
                            f += 0.01f;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    Object[] objectArray2 = objectArray = compareView instanceof BaseCompareView ? ((BaseCompareView)compareView).getEditActions() : null;
                    if (objectArray != null) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (objectArray[i] == null) {
                                f += 0.01f;
                                continue;
                            }
                            contextMenu.add((Component)(objectArray[i] instanceof ToggleAction ? contextMenu.createMenuItem((ToggleAction)objectArray[i]) : new JMenuItem((Action)objectArray[i])), f, false);
                        }
                    }
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_FIRST_CMD))), f += 0.01f);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_PREVIOUS_CMD))), f);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_NEXT_CMD))), f);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_LAST_CMD))), f);
                    if (compareView instanceof ToolbarView) {
                        f += 0.01f;
                        IdeAction[] ideActionArray = ((ToolbarView)compareView).getToolbarActions();
                        if (ideActionArray != null) {
                            for (IdeAction ideAction : ideActionArray) {
                                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction), f);
                            }
                        }
                    }
                }
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }
        });
        try {
            initialContext = new InitialContext();
            try {
                initialContext.lookup("jdeveloper");
            }
            catch (NamingException namingException) {
                initialContext.createSubcontext("jdeveloper");
            }
            initialContext.bind("jdeveloper/compareviewer", (Object)this.m_compareIdeViewer);
        }
        catch (NamingException namingException) {
            ExceptionDialog.showExceptionDialog((Component)null, (Throwable)namingException);
        }
        initialContext = IdeAction.find((int)18);
        if (initialContext != null) {
            initialContext.addController(this.m_controller);
        }
        if ((ideAction = IdeAction.find((int)22)) != null) {
            ideAction.addController((Controller)this.m_controller);
        }
        Preferences preferences = Preferences.getPreferences();
        IdeSettings ideSettings = Ide.getSettings();
        ideSettings.putLegacyData("compareOptions", (Copyable)CompareOptions.getInstance((PropertyStorage)preferences));
        this.initializeSettings();
    }

    public Class getEditorClass() {
        return CompareEditor.class;
    }

    public boolean isDefault() {
        return true;
    }

    public MenuSpec getMenuSpecification() {
        if (this.m_menuSpec == null) {
            this.m_menuSpec = new MenuSpec(CompareArb.getString((int)16), null, null, null);
        }
        return this.m_menuSpec;
    }

    public Object getAttribute(Object object) {
        if (object.equals("no-recent-file")) {
            return Boolean.FALSE;
        }
        if (object.equals("restorable-from-url")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public float getEditorWeight(Element element) {
        return Float.NaN;
    }

    public boolean isDuplicable() {
        return false;
    }

    public boolean restoreAtStartup() {
        return false;
    }

    private URL getSelectionURL(Object object) {
        if (object instanceof RelativeDirectoryContextFolder) {
            return this.getDirectoryCompareURL((RelativeDirectoryContextFolder)object);
        }
        if (object instanceof Locatable) {
            return ((Locatable)object).getURL();
        }
        return null;
    }

    private URL getDirectoryCompareURL(RelativeDirectoryContextFolder relativeDirectoryContextFolder) {
        RelativeDirectoryContextFolder relativeDirectoryContextFolder2 = relativeDirectoryContextFolder;
        URLPath uRLPath = relativeDirectoryContextFolder2.getRootDirectories();
        Iterator iterator = uRLPath.iterator();
        if (iterator.hasNext()) {
            return URLFactory.newDirURL((URL)((URL)iterator.next()), (String)relativeDirectoryContextFolder2.getRelativePath());
        }
        return null;
    }

    private void initializeSettings() {
        Preferences preferences = Preferences.getPreferences();
        CompareOptions compareOptions = CompareOptions.getInstance((PropertyStorage)preferences);
        CompareHints.setIgnoreWhiteSpace((boolean)compareOptions.getIgnoreWhitespace());
        CompareHints.setShowCharDifferences((boolean)compareOptions.getShowCharDifferences());
    }

    boolean isValidCompareURL(URL uRL) {
        String string;
        if (DBURLFormatHelper.isDBURL(uRL) && ("PROCEDURE".equals(string = DBURLFormatHelper.getBaseType(uRL)) || "FUNCTION".equals(string) || string.startsWith("PACKAGE") || "TRIGGER".equals(string))) {
            return true;
        }
        if (uRL == null || !URLFileSystem.isLocal((URL)uRL) || !URLFileSystem.exists((URL)uRL)) {
            return false;
        }
        if (URLFileSystem.isDirectoryPath((URL)uRL)) {
            return true;
        }
        return CompareManager.getCompareManager().isContentComparable(uRL);
    }

    public static String getCreatePatchCommand() {
        return _createPatchCommand;
    }

    public static void setCreatePatchCommand(String string) {
        _createPatchCommand = string;
    }

    public static int getCreatePatchCommandID() {
        return _createPatchCommandId;
    }

    public static void setCreatePatchCommandID(int n) {
        _createPatchCommandId = n;
    }

    public static Controller getPatchController() {
        return _patchController;
    }

    public static void setPatchController(Controller controller) {
        _patchController = controller;
    }

    private class MyController
    implements Controller {
        private MyController() {
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == CompareAddin.this.m_eachOtherAction) {
                ideAction.setEnabled(false);
                Locatable[] locatableArray = VCSManager.getVCSManager().getContextLocatables(context);
                Element[] elementArray = context.getSelection();
                if (locatableArray != null && locatableArray.length == 2) {
                    if (locatableArray[0] instanceof Locatable && locatableArray[1] instanceof Locatable) {
                        ideAction.setEnabled(CompareAddin.this.isValidCompareURL(locatableArray[0].getURL()) && CompareAddin.this.isValidCompareURL(locatableArray[1].getURL()) && URLFileSystem.isDirectoryPath((URL)locatableArray[0].getURL()) == URLFileSystem.isDirectoryPath((URL)locatableArray[1].getURL()) && DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)locatableArray[0].getURL())) == DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)locatableArray[1].getURL())));
                    }
                    if (locatableArray[0] instanceof RelativeDirectoryContextFolder && locatableArray[1] instanceof RelativeDirectoryContextFolder) {
                        ideAction.setEnabled(CompareAddin.this.isValidCompareURL(CompareAddin.this.getDirectoryCompareURL((RelativeDirectoryContextFolder)locatableArray[0])) && CompareAddin.this.isValidCompareURL(CompareAddin.this.getDirectoryCompareURL((RelativeDirectoryContextFolder)locatableArray[1])));
                    }
                } else if (elementArray != null && elementArray.length == 2 && elementArray[0] instanceof PlSqlNode && elementArray[1] instanceof PlSqlNode) {
                    ideAction.setEnabled(true);
                }
                return true;
            }
            if (n == CompareAddin.this.m_otherFileAction) {
                Locatable[] locatableArray = VCSManager.getVCSManager().getContextLocatables(context);
                if (locatableArray != null) {
                    if (locatableArray.length == 0) {
                        ideAction.setEnabled(context.getNode() != null && CompareAddin.this.isValidCompareURL(context.getNode().getURL()));
                        return true;
                    }
                    if (locatableArray.length != 1) {
                        ideAction.setEnabled(false);
                        return true;
                    }
                    if (locatableArray[0] instanceof Locatable) {
                        ideAction.setEnabled(CompareAddin.this.isValidCompareURL(locatableArray[0].getURL()));
                        return true;
                    }
                    if (locatableArray[0] instanceof RelativeDirectoryContextFolder) {
                        ideAction.setEnabled(CompareAddin.this.isValidCompareURL(CompareAddin.this.getDirectoryCompareURL((RelativeDirectoryContextFolder)locatableArray[0])));
                        return true;
                    }
                    if (context.getNode() != null) {
                        ideAction.setEnabled(CompareAddin.this.isValidCompareURL(context.getNode().getURL()));
                        return true;
                    }
                }
                ideAction.setEnabled(false);
                return true;
            }
            if (n == CompareAddin.this.m_savedFileAction) {
                Locatable[] locatableArray = VCSManager.getVCSManager().getContextLocatables(context);
                if (locatableArray != null) {
                    if (locatableArray.length == 0) {
                        Node node = context.getNode();
                        ideAction.setEnabled(node instanceof TextNode && (node.isDirty() || URLFileSystem.lastModified((URL)node.getURL()) != node.getUnmodifiedTimestamp()) && CompareAddin.this.isValidCompareURL(node.getURL()));
                        return true;
                    }
                    if (locatableArray.length == 1 && locatableArray[0] instanceof TextNode && CompareAddin.this.isValidCompareURL(((TextNode)locatableArray[0]).getURL())) {
                        ideAction.setEnabled(this.isDifferent((Node)((TextNode)locatableArray[0])));
                        return true;
                    }
                    ideAction.setEnabled(false);
                    return true;
                }
                ideAction.setEnabled(false);
                return true;
            }
            return false;
        }

        private boolean isDifferent(Node node) {
            if (node == null) {
                return false;
            }
            return node.isDirty() || URLFileSystem.lastModified((URL)node.getURL()) != node.getUnmodifiedTimestamp();
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            try {
                if (n == CompareAddin.this.m_otherFileAction) {
                    CompareAddin.this.compareOtherFile(context);
                    return true;
                }
                if (n == CompareAddin.this.m_savedFileAction) {
                    CompareAddin.this.compareSavedFile(context);
                    return true;
                }
                if (n == CompareAddin.this.m_eachOtherAction) {
                    CompareAddin.this.compareEachOther(context);
                    return true;
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return false;
        }
    }
}

