/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import oracle.dbtools.raptor.utils.Closeables;

public class StreamCopy {
    private static final int BUFFER_SIZE = 65536;
    private static final EmptyStream EMPTY_STREAM = new EmptyStream();

    public static long drain(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream != null && outputStream != null) {
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
            WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
            return StreamCopy.drain(readableByteChannel, writableByteChannel);
        }
        return -1L;
    }

    public static long drain(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel) throws IOException {
        long l = 0L;
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        while (readableByteChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            l += (long)byteBuffer.limit();
            writableByteChannel.write(byteBuffer);
            byteBuffer.compact();
        }
        byteBuffer.flip();
        while (byteBuffer.hasRemaining()) {
            writableByteChannel.write(byteBuffer);
        }
        return l;
    }

    public static long drain(Readable readable, Appendable appendable) throws IOException {
        long l = 0L;
        CharBuffer charBuffer = CharBuffer.allocate(65536);
        while (readable.read(charBuffer) != -1) {
            charBuffer.flip();
            l += (long)charBuffer.limit();
            appendable.append(charBuffer);
            charBuffer.compact();
        }
        return l;
    }

    public static InputStream emptyStream() {
        return EMPTY_STREAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String string(InputStream inputStream) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while (-1 != (n = inputStream.read())) {
                byteArrayOutputStream.write(n);
            }
            byteArrayOutputStream.close();
            String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
            return string;
        }
        finally {
            Closeables.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String string(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            char[] cArray = new char[11];
            int n = -1;
            while (-1 != (n = reader.read(cArray, 0, cArray.length))) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        finally {
            Closeables.close(reader);
        }
        return stringBuilder.toString();
    }

    public static InputStream toInputStream(String string) throws IOException {
        if (null == string) {
            return EMPTY_STREAM;
        }
        return new ByteArrayInputStream(string.getBytes("UTF-8"));
    }

    private static final class EmptyStream
    extends InputStream {
        private EmptyStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }
}

