/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.Reader;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.metadata.MetaData;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CLOB;

public class MetaDataDDLGenerator {
    private static Boolean _usePrefs = false;
    private static final String META_SQL = "SELECT DBMS_METADATA.GET_DDL(:TYPE,:NAME,:OWNER) SQL FROM SYS.DUAL";
    private static final String USER_META_SQL = "SELECT DBMS_METADATA.GET_DDL(:TYPE,:NAME) SQL FROM SYS.DUAL";
    private static final String TABLE_SQL = "declare   owner  varchar2(2000) := ?;    object varchar2(2000) := ?;    h  number;    h2 number; begin    h := dbms_metadata.open('TABLE');    dbms_metadata.set_filter(h,'SCHEMA',owner);    dbms_metadata.set_filter(h,'NAME',object);    dbms_metadata.set_filter(h,'EXCLUDE_PATH_EXPR','in (''TABLE_DATA'',''STATISTICS'',''POST_INSTANCE'',''INSTANCE_CALLOUT'',''PROCACT_INSTANCE'',''PRE_TABLE_ACTION'',''POST_TABLE_ACTION'')');    h2 := DBMS_METADATA.ADD_TRANSFORM(h,'DDL');    dbms_metadata.set_transform_param(h2,'SQLTERMINATOR',true);   ? := h;end;";
    private static final String TABLE_SQL_CLOB = "begin  ? := dbms_metadata.fetch_clob(?); end;";

    public static String getDDLFromGenerator(DBObject dBObject) {
        Database database = dBObject.getDatabase();
        String string = null;
        if (database != null) {
            OracleDDLGenerator oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database);
            Ddl ddl = oracleDDLGenerator.getCreateDDL(dBObject.getSchemaObject(), false, false);
            string = ddl.getDdl();
        }
        return string;
    }

    public static String getDDL(DBObject dBObject, Boolean bl) {
        _usePrefs = bl;
        return MetaDataDDLGenerator.getDDL(dBObject);
    }

    public static String getDDL(DBObject dBObject) {
        String string = MetaData.getDDL(dBObject, _usePrefs);
        if ((string == null || string.equals("")) && dBObject.getObjectType().equals("TABLE")) {
            string = MetaDataDDLGenerator.getTableMetaData(dBObject);
        } else if ((string == null || string.equals("")) && dBObject.getObjectType().equals("USER")) {
            string = MetaDataDDLGenerator.getUserFromMeta(dBObject);
        } else if (string == null || string.equals("")) {
            string = MetaDataDDLGenerator.getDDLFromMeta(dBObject);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserFromMeta(DBObject dBObject) {
        String string = null;
        DBUtil dBUtil = DBUtil.getInstance((String)dBObject.getConnectionName());
        dBUtil.setRaiseError(false);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TYPE", dBObject.getObjectType().replace(" ", "_"));
        hashMap.put("NAME", dBObject.getObjectName());
        ResultSetWrapper resultSetWrapper = dBUtil.executeQuery(USER_META_SQL, hashMap);
        try {
            ResultSet resultSet = resultSetWrapper.getResultSet();
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        catch (Exception exception) {
            String string2 = "-- DBMS_METADATA was unable to generate SQL. Now using internal DDL generator\n-- To Test DBMS_METADATA : select dbms_metadata.get_ddl('TABLE','DUAL','SYS') from dual;\n" + MetaDataDDLGenerator.getDDLFromGenerator(dBObject);
            return string2;
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDDLFromMeta(DBObject dBObject) {
        String string = null;
        DBUtil dBUtil = DBUtil.getInstance((String)dBObject.getConnectionName());
        dBUtil.setRaiseError(false);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (dBObject.getObjectType().equals("DATABASE LINK")) {
            hashMap.put("TYPE", "DB_LINK");
        } else {
            hashMap.put("TYPE", dBObject.getObjectType().replace(" ", "_"));
        }
        hashMap.put("NAME", dBObject.getObjectName());
        hashMap.put("OWNER", dBObject.getSchemaName());
        ResultSetWrapper resultSetWrapper = dBUtil.executeQuery(META_SQL, hashMap);
        try {
            ResultSet resultSet = resultSetWrapper.getResultSet();
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        catch (Exception exception) {
            String string2 = "-- DBMS_METADATA was unable to generate SQL. Now using internal DDL generator\n-- To Test DBMS_METADATA : select dbms_metadata.get_ddl('TABLE','DUAL','SYS') from dual;\n" + MetaDataDDLGenerator.getDDLFromGenerator(dBObject);
            return string2;
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTableMetaData(DBObject dBObject) {
        StringBuilder stringBuilder = new StringBuilder();
        OracleCallableStatement oracleCallableStatement = null;
        OracleCallableStatement oracleCallableStatement2 = null;
        PerformanceLogger.get().startTiming(MetaDataDDLGenerator.class.toString() + ".getTableMetaData");
        try {
            int n;
            oracleCallableStatement = (OracleCallableStatement)dBObject.getConnection().prepareCall(TABLE_SQL);
            oracleCallableStatement.setString(1, dBObject.getSchemaName());
            oracleCallableStatement.setString(2, dBObject.getObjectName());
            oracleCallableStatement.registerOutParameter(3, 2);
            oracleCallableStatement.execute();
            BigDecimal bigDecimal = oracleCallableStatement.getBigDecimal(3);
            CLOB cLOB = null;
            oracleCallableStatement2 = (OracleCallableStatement)dBObject.getConnection().prepareCall(TABLE_SQL_CLOB);
            oracleCallableStatement2.registerOutParameter(1, 2005);
            oracleCallableStatement2.setBigDecimal(2, bigDecimal);
            oracleCallableStatement2.execute();
            cLOB = oracleCallableStatement2.getCLOB(1);
            Reader reader = cLOB.getCharacterStream();
            char[] cArray = new char[8192];
            while ((n = reader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (Exception exception) {
            if (stringBuilder.length() < 10) {
                String string = "-- DBMS_METADATA was unable to use TABLE_EXPORT to generate sql.  Now trying to use TABLE.\n" + MetaDataDDLGenerator.getDDLFromMeta(dBObject);
                return string;
            }
        }
        finally {
            try {
                oracleCallableStatement.close();
            }
            catch (SQLException sQLException) {}
        }
        PerformanceLogger.get().stopTiming(MetaDataDDLGenerator.class.toString() + ".getTableMetaData", "Got DDL");
        return stringBuilder.toString();
    }
}

