/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.cloud.navigator.CloudObject;
import oracle.dbtools.raptor.navigator.CustomNode;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.runner.DBStarterFactory;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.ModelUtil;

public final class DBObject {
    private static Logger LOGGER = Logger.getLogger(DBObject.class.getName());
    public static final String DBOBJECT_KEY = "DB_OBJECT";
    public static final String OBJECT_NAME_KEY = "OBJECT_NAME";
    public static final String OBJECT_TYPE_KEY = "OBJECT_TYPE";
    public static final String OBJECT_FOLDER_TYPE_KEY = "OBJECT_FOLDER_TYPE";
    public static final String OBJECT_OWNER_KEY = "OBJECT_OWNER";
    public static final String COLUMN_NAME_KEY = "COLUMN_NAME";
    public static final String OBJECT_ID_KEY = "OBJECT_ID";
    public static final String CHILD_NAME_KEY = "CHILD_NAME";
    public static final String CONN_TYPE_KEY = "CONN_TYPE";
    public static final String CONNECTION_NAME = "CONNECTION_NAME";
    public static final String NEW_OBJECTVIEWER_FLAG = "NEW_OBJECTVIEWER_FLAG";
    private Element m_node;
    private String m_name;
    private String m_schema;
    private String m_id;
    private String m_type;
    private String m_folderType;
    private String m_childName;
    private SchemaObject m_schemaObject;
    private Connection m_conn;
    private String m_connName;
    private Map<String, Object> m_dict;
    private String m_connType;
    private String m_catalog;
    private boolean m_isValid;
    private URL m_url;
    private boolean m_loaded = false;

    public static DBObject getDBObjectForName(String string, Database database) {
        String string2 = Connections.getInstance().getConnectionName(database);
        return DBObject.getDBObjectForName(string, string2);
    }

    public static DBObject getDBObjectForName(String string, String string2) {
        Map map;
        DBObject dBObject = null;
        if (string != null && string.trim().length() > 0 && (map = DBUtil.getInstance((String)string2).resolveName(string)) != null) {
            URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string2, null, (String)map.get("OWNER"), (String)map.get(OBJECT_TYPE_KEY));
            uRL = DBURLFormatHelper.getURL(uRL, (String)map.get(OBJECT_NAME_KEY));
            LOGGER.info("Found:" + (String)map.get("OWNER") + "." + (String)map.get(OBJECT_TYPE_KEY) + "." + (String)map.get(OBJECT_NAME_KEY));
            LOGGER.info("Found URL:" + uRL);
            dBObject = new DBObject(uRL);
        }
        return dBObject;
    }

    public DBObject(URL uRL) {
        this.m_url = uRL;
        this.m_connName = DBURLFormatHelper.getConnectionName(uRL);
        this.m_name = DBURLFormatHelper.getName(uRL);
        String string = DBURLFormatHelper.getBaseType(uRL);
        this.m_type = ModelUtil.hasLength((String)this.m_name) ? string : string + "_FOLDER";
        this.m_folderType = string;
        this.m_schema = DBURLFormatHelper.getSchema(uRL);
        this.m_catalog = DBURLFormatHelper.getCatalog(uRL);
        this.m_loaded = true;
    }

    public DBObject(Element element) {
        this.m_node = element instanceof IViewerNode ? ((IViewerNode)element).getBaseNode() : element;
    }

    public Map<String, Object> getDictionary() {
        if (this.m_dict == null) {
            Object object;
            this.loadDBData();
            this.m_dict = new HashMap<String, Object>();
            if (this.m_node instanceof DatabaseNode && (object = ((DatabaseNode)this.m_node).getNodeInstance()) != null) {
                for (String string : object.getPropertyKeys()) {
                    this.m_dict.put(string, object.getProperty(string));
                }
            }
            if (this.m_node instanceof ObjectFolder) {
                object = ((ObjectFolder)this.m_node).getFolderInstance();
                for (String string : object.getPropertyKeys()) {
                    this.m_dict.put(string, object.getProperty(string));
                }
            }
            if ((object = ObjectFactory.getFactory(this.getConnectionName(), this.getConnection())) != null) {
                this.m_dict.putAll(((ObjectFactory)object).getGlobalBindMap());
            }
            if (this.m_node instanceof CustomNode && ((CustomNode)this.m_node).getDict() != null) {
                this.m_dict.putAll(((CustomNode)this.m_node).getDict());
            }
            if (this.m_type != null && this.m_type.equals("CONNECTION")) {
                this.m_dict.put(OBJECT_NAME_KEY, Connections.getConnectionName(this.getObjectName()));
            } else {
                this.m_dict.put(OBJECT_NAME_KEY, this.getObjectName());
            }
            this.m_dict.put(OBJECT_TYPE_KEY, this.getObjectType());
            this.m_dict.put(OBJECT_OWNER_KEY, this.getSchemaName());
            this.m_dict.put(COLUMN_NAME_KEY, this.getChildName());
            this.m_dict.put(OBJECT_ID_KEY, this.getObjectId());
            this.m_dict.put(CHILD_NAME_KEY, this.getChildName());
            this.m_dict.put(OBJECT_FOLDER_TYPE_KEY, this.m_folderType);
            Connections.getInstance();
            this.m_dict.put(CONNECTION_NAME, Connections.getConnectionName(this.getConnectionName()));
        }
        return this.m_dict;
    }

    public Map<String, Object> getObjectBinds(String string) {
        this.loadDBData();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string.indexOf(":OBJECT_NAME") > 0) {
            hashMap.put(OBJECT_NAME_KEY, this.getObjectName());
        }
        if (string.indexOf(":OBJECT_OWNER") > 0) {
            hashMap.put(OBJECT_OWNER_KEY, this.getSchemaName());
        }
        if (string.indexOf(":OBJECT_ID") > 0) {
            hashMap.put(OBJECT_ID_KEY, this.getObjectId());
        }
        if (string.indexOf(":OBJECT_TYPE") > 0) {
            hashMap.put(OBJECT_TYPE_KEY, this.getObjectType());
        }
        return hashMap;
    }

    public boolean isValid() {
        this.loadDBData();
        return this.m_isValid;
    }

    public synchronized void loadDBData() {
        if (!this.m_loaded) {
            this.m_isValid = true;
            if (this.m_node instanceof DatabaseNode) {
                this.processObjectNode((DatabaseNode)this.m_node);
            } else if (this.m_node instanceof ObjectFolder) {
                this.processObjectFolder((ObjectFolder)this.m_node);
            } else if (this.m_node instanceof OtherSchemasFolder) {
                this.processOtherSchemasFolder((OtherSchemasFolder)this.m_node);
            } else if (this.m_node instanceof DatabaseConnection) {
                this.processConnectionNode((DatabaseConnection)this.m_node);
            } else if (this.m_node instanceof SchemaFolder) {
                this.processSchemaFolder((SchemaFolder)this.m_node);
            } else if (this.m_node instanceof CategoryFolder) {
                this.processCategoryFolder((CategoryFolder)this.m_node);
            } else if (this.m_node instanceof ObjectNode) {
                this.processObjectNode((ObjectNode)this.m_node);
            } else if (this.m_node instanceof CustomNode) {
                this.processCustomNode((CustomNode)this.m_node);
            } else if (this.m_node instanceof ChildObjectElement) {
                this.processChild((ChildObjectElement)this.m_node);
            } else if (this.m_node instanceof CatalogFolder) {
                this.processCatalogFolder((CatalogFolder)this.m_node);
            } else if (this.m_node instanceof CloudObject) {
                this.processCloudObject((CloudObject)this.m_node);
            } else {
                this.m_isValid = false;
            }
            if (this.m_node instanceof DatabaseElement) {
                DatabaseElement databaseElement = (DatabaseElement)this.m_node;
                if (this.m_connType == null) {
                    this.m_connType = (String)databaseElement.getProperty("ConnectionType");
                }
                String string = this.m_id = databaseElement.getProperty(OBJECT_ID_KEY) != null ? databaseElement.getProperty(OBJECT_ID_KEY).toString() : null;
            }
            if (this.m_type != null && this.m_type.equals("PUBLIC_SYNONYM")) {
                this.m_schema = "PUBLIC";
            }
            if (this.m_node instanceof Locatable) {
                this.m_url = ((Locatable)this.m_node).getURL();
            }
            this.m_loaded = true;
        }
    }

    private void processCloudObject(CloudObject cloudObject) {
        this.m_type = cloudObject.getObjectType();
        this.m_name = cloudObject.getName();
    }

    private void processCatalogFolder(CatalogFolder catalogFolder) {
        this.m_folderType = this.m_type = "CATALOG";
        this.m_url = catalogFolder.getURL();
        this.m_connName = DBURLFormatHelper.getConnectionName(this.m_url);
        this.m_connType = catalogFolder.getCatalogInstance().getObjectFactory().getConnectionType();
        this.m_name = DBURLFormatHelper.getCatalog(this.m_url);
        this.m_catalog = DBURLFormatHelper.getCatalog(this.m_url);
    }

    private void processChild(ChildObjectElement childObjectElement) {
        this.m_name = (String)childObjectElement.getProperty(OBJECT_NAME_KEY);
        this.m_schema = (String)childObjectElement.getProperty("SCHEMA");
        this.m_folderType = this.m_type = (String)childObjectElement.getProperty("TYPE");
        this.m_connName = DBURLFormatHelper.getConnectionName(childObjectElement.getURL());
        this.m_connType = (String)childObjectElement.getProperty("ConnectionType");
        this.m_catalog = (String)childObjectElement.getProperty("CATALOG");
        this.m_childName = (String)childObjectElement.getProperty("NAME");
    }

    private void processCustomNode(CustomNode customNode) {
        this.m_folderType = this.m_type = customNode.getObjectType();
        this.m_connType = customNode.getConnType();
        this.m_connName = customNode.getConnectionName();
        this.m_name = customNode.getObjectName();
        this.m_schema = customNode.getSchemaName();
        this.m_conn = customNode.getConn();
    }

    private void processConnectionNode(DatabaseConnection databaseConnection) {
        this.m_folderType = this.m_type = "CONNECTION";
        this.m_name = databaseConnection.getQualifiedConnectionName();
        this.m_connName = databaseConnection.getQualifiedConnectionName();
        try {
            if (databaseConnection.isConnectionOpen()) {
                ObjectFactory objectFactory = ObjectFactory.getFactory(this.m_connName, databaseConnection.getConnection());
                this.m_connType = objectFactory.getConnectionType();
                this.m_schema = objectFactory.getSchema();
            } else {
                Properties properties = Connections.getInstance().getConnectionInfo(this.m_connName);
                if (properties != null) {
                    this.m_schema = properties.getProperty("user");
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.severe("Could not read node:" + iOException.getMessage());
        }
    }

    private void processOtherSchemasFolder(OtherSchemasFolder otherSchemasFolder) {
        this.m_folderType = this.m_type = "USER_FOLDER";
        this.m_connName = otherSchemasFolder.getConnectionName();
    }

    private void processSchemaFolder(SchemaFolder schemaFolder) {
        this.m_folderType = this.m_type = "USER";
        this.m_connName = (String)schemaFolder.getProperty("ConnectionName");
        this.m_schema = (String)schemaFolder.getProperty("SCHEMA");
    }

    private void processCategoryFolder(CategoryFolder categoryFolder) {
        this.m_folderType = this.m_type = categoryFolder.getCategory();
        this.m_connName = (String)categoryFolder.getProperty("ConnectionName");
        this.m_schema = (String)categoryFolder.getProperty("SCHEMA");
    }

    private void processObjectFolder(ObjectFolder objectFolder) {
        this.m_type = objectFolder.getObjectType() + "_FOLDER";
        this.m_folderType = objectFolder.getObjectType();
        this.m_connName = (String)objectFolder.getProperty("ConnectionName");
        this.m_schema = (String)objectFolder.getProperty("SCHEMA");
    }

    private static Connection getConnection(String string) {
        try {
            return Connections.getInstance().getConnection(string);
        }
        catch (DBException dBException) {
            ExceptionHandler.handleException((Throwable)dBException);
            return null;
        }
    }

    private void processObjectNode(DatabaseNode databaseNode) {
        this.m_name = (String)databaseNode.getProperty("NAME");
        this.m_schema = (String)databaseNode.getProperty("SCHEMA");
        this.m_folderType = this.m_type = (String)databaseNode.getProperty("TYPE");
        this.m_connName = (String)databaseNode.getProperty("ConnectionName");
        this.m_connType = (String)databaseNode.getProperty("ConnectionType");
        this.m_catalog = (String)databaseNode.getProperty("CATALOG");
        if (this.m_type != null) {
            if (this.m_type.equalsIgnoreCase("materialized view log")) {
                this.m_childName = (String)databaseNode.getProperty("MASTER");
            }
        } else {
            this.m_isValid = false;
        }
    }

    public URL getURL() {
        this.loadDBData();
        return this.m_url;
    }

    public Node getNode() {
        Element element = this.getElement();
        return element instanceof Node ? (Node)element : null;
    }

    public Element getElement() {
        if (this.m_node == null && this.m_url != null) {
            this.m_node = DatabaseNavigatorElementFactory.getObjectNode(this.m_url);
        }
        return this.m_node;
    }

    public void setNode(Node node) {
        this.m_node = node;
        this.loadDBData();
    }

    public String getObjectName() {
        this.loadDBData();
        return this.m_name;
    }

    public String getSchemaName() {
        this.loadDBData();
        return this.m_schema;
    }

    public String getObjectId() {
        DBObjectID dBObjectID;
        SchemaObject schemaObject;
        this.loadDBData();
        if (this.m_id == null && (schemaObject = this.getSchemaObject()) != null && (dBObjectID = schemaObject.getID()) instanceof IdentifierBasedID) {
            this.m_id = ((IdentifierBasedID)dBObjectID).getIdentifier().toString();
        }
        return this.m_id;
    }

    public String getObjectType() {
        this.loadDBData();
        return this.m_type;
    }

    public String getObjectFolderType() {
        this.loadDBData();
        return this.m_folderType;
    }

    public String getChildName() {
        this.loadDBData();
        return this.m_childName;
    }

    public SchemaObject getSchemaObject() {
        this.loadDBData();
        if (this.m_schemaObject == null) {
            try {
                Database database = this.getDatabase();
                if (database != null) {
                    this.m_schemaObject = database.getObject(this.m_type, database.getSchema(this.m_schema), this.m_name);
                }
            }
            catch (DBException dBException) {
                LOGGER.severe("Could not get schema Object:" + dBException.getMessage());
            }
        }
        return this.m_schemaObject;
    }

    public Database getDatabase() {
        this.loadDBData();
        Database database = null;
        try {
            database = Connections.getInstance().getDatabase(this.m_connName);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return database;
    }

    public Connection getConnection() {
        this.loadDBData();
        this.m_conn = DBObject.getConnection(this.m_connName);
        return this.m_conn;
    }

    public boolean isConnected() {
        return Connections.getInstance().isConnectionOpen(this.m_connName);
    }

    public String getConnectionName() {
        this.loadDBData();
        return this.m_connName;
    }

    private boolean isOracleImpl() {
        this.loadDBData();
        return Connections.getInstance().isOracle(this.getConnectionName());
    }

    public String getConnectionType() {
        this.loadDBData();
        if (this.m_connType == null) {
            Properties properties;
            if (this.isOracleImpl()) {
                this.m_connType = "Oracle";
            } else if (this.m_connName != null && (properties = Connections.getInstance().getConnectionInfo(this.m_connName)) != null) {
                this.m_connType = properties.getProperty("RaptorConnectionType");
            }
        }
        return this.m_connType;
    }

    public String getCatalog() {
        this.loadDBData();
        return null;
    }

    public boolean isOracle() {
        this.loadDBData();
        return this.m_connType != null ? "Oracle".equals(this.m_connType) : this.isOracleImpl();
    }

    public boolean isTimesTen() {
        this.loadDBData();
        return Connections.getInstance().isTimesTen(this.getConnectionName());
    }

    public String getKey() {
        this.loadDBData();
        return DBObject.getKey(this.getConnectionType(), this.getObjectType());
    }

    public static String getKey(String string, String string2) {
        return string + "#" + string2;
    }

    public String getDBVersion() {
        this.loadDBData();
        try {
            return DBUtil.getDbVersion((Connection)Connections.getInstance().getConnection(this.getConnectionName())).toCanonicalString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean checkVals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public boolean checkQualifiedNameEquals(DBObject dBObject) {
        this.loadDBData();
        if (dBObject == null) {
            return false;
        }
        return DBObject.checkVals(String.valueOf(dBObject.getURL()), String.valueOf(this.getURL())) && DBObject.checkVals(dBObject.getObjectName(), this.getObjectName()) && DBObject.checkVals(dBObject.getConnectionName(), this.getConnectionName()) && DBObject.checkVals(dBObject.getSchemaName(), this.getSchemaName());
    }

    public boolean isActionAllowed() {
        return !DBStarterFactory.isDebugSessionActive(this.m_connName);
    }
}

