/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.net.JarUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractFolderedXml {
    protected static Logger LOGGER = Logger.getLogger(AbstractFolderedXml.class.getName());
    private XMLDocument _document;
    protected XLIFFHelper xliff = new XLIFFHelper();
    private DOMParser parser;

    public abstract void openFolder(String var1, String var2, String var3, Node var4);

    public abstract void closeFolder();

    public abstract void newItem(Node var1);

    public void newNode(Node node) {
    }

    private void processFolder(Node node) {
        String string = XMLHelper.getNodeValue((Node)node, (String)"name");
        String string2 = XMLHelper.getNodeValue((Node)node, (String)"description");
        String string3 = XMLHelper.getNodeValue((Node)node, (String)"tip");
        string = this.xliff.getTranslation(string);
        string2 = this.xliff.getTranslation(string2);
        string3 = this.xliff.getTranslation(string3);
        this.openFolder(string, string2, string3, node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string4 = node2.getNodeName();
            if (string4.equalsIgnoreCase("folder")) {
                this.processFolder(node2);
                continue;
            }
            if (string4.equalsIgnoreCase("item")) {
                this.newItem(node2);
                continue;
            }
            if (string4.equalsIgnoreCase("description") || string4.equalsIgnoreCase("name") || string4 == null) continue;
            LOGGER.finer("Folder:Unsupported node in xml:" + string4);
        }
    }

    private void processNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equalsIgnoreCase("folder")) {
                this.processFolder(node2);
                this.closeFolder();
                continue;
            }
            if (string.equalsIgnoreCase("item")) {
                this.newItem(node2);
                continue;
            }
            if (string.equalsIgnoreCase("#comment")) continue;
            this.newNode(node2);
        }
    }

    public void processXML(InputStream inputStream, URL uRL) throws Exception {
        String string = JarUtil.getJarEntry((URL)uRL);
        if (string != null) {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            this.xliff.setBaseDocName(string);
        }
        this.processXML(inputStream);
    }

    public void processXML(InputStream inputStream) throws Exception {
        if (this.parser == null) {
            this.parser = new DOMParser();
        } else {
            this.parser.reset();
        }
        this.parser.setPreserveWhitespace(false);
        this.parser.parse(inputStream);
        this._document = this.parser.getDocument();
        NodeList nodeList = this._document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.processNode(nodeList.item(i));
        }
        inputStream.close();
    }

    public Document getDocument() {
        return this._document;
    }

    public static void main(String[] stringArray) {
    }
}

