/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JPanel;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class TimeActionControl
extends ActionControl {
    private CalendarPopupButton _calButton = new CalendarPopupButton();
    private CalendarPanel _calPanel;
    private DateTimeEditor _dateEditor;
    private DateFormat _format;
    private JPanel _ui;
    private Date _defaultDate;

    public TimeActionControl(String string, String string2, DateFormat dateFormat) {
        this(string, string2, null, dateFormat, null);
    }

    public TimeActionControl(String string, String string2, DateFormat dateFormat, DateFormat dateFormat2) {
        this(string, string2, null, dateFormat, dateFormat2);
    }

    public TimeActionControl(String string, String string2, Date date, DateFormat dateFormat) {
        this(string, string2, date, dateFormat, null);
    }

    public TimeActionControl(String string, String string2, Date date, DateFormat dateFormat, DateFormat dateFormat2) {
        super(string, string2);
        this._defaultDate = date;
        this._format = dateFormat;
        this._calPanel = this._calButton.getCalendarPanel();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        Date date2 = date;
        if (date2 == null) {
            date2 = new Date(calendar.getTimeInMillis() / 60000L * 60000L);
        }
        this._dateEditor = new DateTimeEditor(date2);
        if (dateFormat2 != null) {
            this._dateEditor.setDateFormat(dateFormat2);
        }
        this._calPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Date[] dateArray;
                if (actionEvent.getActionCommand() == "SELECTION_CHANGED_COMMAND" && (dateArray = TimeActionControl.this._calPanel.getSelectedDates()).length > 0) {
                    TimeActionControl.this._dateEditor.setDate(dateArray[0]);
                }
            }
        });
        this._calButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimeActionControl.this._calPanel.setSelectedDate(TimeActionControl.this._dateEditor.getDate());
                TimeActionControl.this._calPanel.makeDateVisible(TimeActionControl.this._dateEditor.getDate());
            }
        });
        this._ui = new JPanel(new GridBagLayout());
        this._ui.add((Component)((Object)this._dateEditor), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
        this._ui.add((Component)this._calButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0));
        this._dateEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TimeActionControl.this.firePropertyChangeListeners();
            }
        });
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        value.set(this._format.format(this._dateEditor.getDate()));
        return value;
    }

    @Override
    public Component getUI() {
        return this._ui;
    }

    @Override
    public void reset() {
        this.set(this._defaultDate);
    }

    public void set(Date date) {
        if (date == null) {
            Calendar calendar = Calendar.getInstance();
            date = new Date(calendar.getTimeInMillis() / 60000L * 60000L);
        }
        this._dateEditor.setDate(date);
    }

    @Override
    public void setEditable(boolean bl) {
        this.enableUI(bl);
    }

    @Override
    public void enableUI(boolean bl) {
        super.enableUI(bl);
        this._calButton.setEnabled(bl);
        this._dateEditor.setEnabled(bl);
    }
}

