/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.Document;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;

public class EditorActionControl
extends ActionControl {
    private BasicEditorPane _editor;
    private String _defaultValue;
    private JScrollPane _editorWithScrollBars;

    public EditorActionControl(String string, String string2) {
        this(string, null, string2, null);
    }

    public EditorActionControl(String string, String string2, String string3) {
        this(string, null, string2, string3);
    }

    public EditorActionControl(String string, String string2, String string3, String string4) {
        super(string, string2);
        this._defaultValue = string3;
        this._editor = this.createEditorPane(string4);
        this._editor.setName(string);
        this._editorWithScrollBars = new JScrollPane((Component)this._editor){
            private static final long serialVersionUID = 1L;
            int hpad;
            int vpad;
            {
                this.hpad = this.createVerticalScrollBar().getPreferredSize().width;
                this.vpad = this.createHorizontalScrollBar().getPreferredSize().height;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension(dimension.width + this.hpad, dimension.height + this.vpad);
            }
        };
        this._editor.setBorder(BorderFactory.createEmptyBorder());
        this.setFillVertical(true);
        this.setSpringVertical(true);
        this.reset();
        this._editor.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                EditorActionControl.this.firePropertyChangeListeners();
            }
        });
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        value.set(this._editor.getText());
        return value;
    }

    @Override
    public Component getUI() {
        return this._editorWithScrollBars;
    }

    @Override
    public void reset() {
        this._editor.setText(this._defaultValue);
    }

    public void set(String string) {
        this._editor.setText(string);
    }

    @Override
    public void setEditable(boolean bl) {
        this._editor.setEditable(bl);
    }

    private BasicEditorPane createEditorPane(String string) {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setDocument((Document)(string != null ? new BasicDocument(string) : new BasicDocument()));
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin();
        basicEditorPane.installPlugin((EditorPlugin)lineGutterPlugin);
        basicEditorPane.installPlugin((EditorPlugin)highlightEditorPlugin);
        basicEditorPane.setBorder((Border)new LineBorder(Color.BLACK));
        basicEditorPane.setPreferredSize(null);
        return basicEditorPane;
    }
}

