/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.dbtools.raptor.ui.panels.CustomDateEditor;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class CalendarActionControl
extends ActionControl
implements LayoutControl {
    private static final Object[] sortedTimeZoneList = CalendarActionControl.getTZList();
    private final CalendarPopupButton _calButton = new CalendarPopupButton();
    private final CalendarPanel _calPanel;
    private final DateTimeEditor _dateEditor;
    private final JComboBox _timezones;
    private final SimpleDateFormat _format;
    private final JPanel _ui;
    private final Calendar _defaultCalendar;

    public CalendarActionControl(String string, String string2, SimpleDateFormat simpleDateFormat) {
        this(string, string2, null, simpleDateFormat);
    }

    public CalendarActionControl(String string, String string2, Calendar calendar, SimpleDateFormat simpleDateFormat) {
        super(string, string2);
        this._defaultCalendar = calendar;
        this._format = new SimpleDateFormat(simpleDateFormat.toPattern());
        this._calPanel = this._calButton.getCalendarPanel();
        Calendar calendar2 = this.fixCalendar(this._defaultCalendar);
        this._dateEditor = new CustomDateEditor(calendar2.getTime(), calendar2, this._format);
        this._timezones = new JComboBox<Object>(sortedTimeZoneList);
        this._timezones.setRenderer(new TimeZoneListRenderer(this._timezones.getRenderer()));
        this._timezones.setSelectedItem(calendar2.getTimeZone());
        this._timezones.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TimeZone timeZone;
                if (1 == itemEvent.getStateChange() && (timeZone = (TimeZone)CalendarActionControl.this._timezones.getSelectedItem()) != null) {
                    Calendar calendar = CalendarActionControl.this.getCalendar();
                    calendar.setTimeZone(timeZone);
                    CalendarActionControl.this.set(calendar);
                }
            }
        });
        this._calPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Date[] dateArray;
                if (actionEvent.getActionCommand() == "SELECTION_CHANGED_COMMAND" && (dateArray = CalendarActionControl.this._calPanel.getSelectedDates()).length > 0) {
                    CalendarActionControl.this._dateEditor.setDate(dateArray[0]);
                }
            }
        });
        this._calButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarActionControl.this._calPanel.setSelectedDate(CalendarActionControl.this._dateEditor.getDate());
                CalendarActionControl.this._calPanel.makeDateVisible(CalendarActionControl.this._dateEditor.getDate());
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)((Object)this._dateEditor), LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this._timezones, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP));
        this._ui = new JPanel(new GridBagLayout());
        this._ui.add((Component)jPanel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        this._ui.add((Component)this._calButton, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP));
        this._dateEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CalendarActionControl.this.firePropertyChangeListeners();
            }
        });
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        value.set(this._format.format(this._dateEditor.getDate()));
        return value;
    }

    @Override
    public Component getUI() {
        return this._ui;
    }

    @Override
    public void reset() {
        this.set(this._defaultCalendar);
    }

    protected long fixMillis(long l) {
        long l2 = l / 1000L * 1000L;
        return l2;
    }

    public Calendar fixCalendar(Calendar calendar) {
        long l = (calendar = calendar == null ? Calendar.getInstance() : (Calendar)calendar.clone()).getTimeInMillis();
        long l2 = this.fixMillis(l);
        if (l2 != l) {
            calendar.setTimeInMillis(l2);
        }
        return calendar;
    }

    public void set(Calendar calendar) {
        Calendar calendar2 = this.getCalendar();
        if (!CalendarActionControl.areEqual(calendar2, calendar)) {
            calendar = this.fixCalendar(calendar);
            this._dateEditor.setCalendar(calendar);
            TimeZone timeZone = calendar.getTimeZone();
            this._timezones.setSelectedItem(timeZone);
        }
        this._timezones.repaint();
    }

    @Override
    public void setEditable(boolean bl) {
        this.enableUI(bl);
    }

    @Override
    public void enableUI(boolean bl) {
        super.enableUI(bl);
        this._calButton.setEnabled(bl);
        this._timezones.setEnabled(bl);
        this._dateEditor.setEnabled(bl);
    }

    public Calendar getCalendar() {
        Calendar calendar = this._dateEditor.getCalendar();
        Date date = this._dateEditor.getDate();
        calendar = (Calendar)calendar.clone();
        long l = this.fixMillis(date.getTime());
        calendar.setTimeInMillis(l);
        return calendar;
    }

    protected static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    private static Object[] getTZList() {
        TreeSet<TimeZone> treeSet = new TreeSet<TimeZone>(new Comparator<TimeZone>(){

            @Override
            public int compare(TimeZone timeZone, TimeZone timeZone2) {
                return timeZone.getID().compareTo(timeZone2.getID());
            }

            @Override
            public boolean equals(Object object) {
                return super.equals(object);
            }
        });
        for (String string : TimeZone.getAvailableIDs()) {
            TimeZone timeZone = TimeZone.getTimeZone(string);
            treeSet.add(timeZone);
        }
        return treeSet.toArray();
    }

    protected class TimeZoneListRenderer
    implements ListCellRenderer {
        protected ListCellRenderer defaultRenderer;

        public TimeZoneListRenderer(ListCellRenderer listCellRenderer) {
            this.defaultRenderer = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof TimeZone) {
                TimeZone timeZone = (TimeZone)object;
                boolean bl3 = timeZone.inDaylightTime(CalendarActionControl.this._dateEditor.getDate());
                if (n == -1) {
                    return this.defaultRenderer.getListCellRendererComponent(jList, timeZone.getDisplayName(bl3, 0), n, bl, bl2);
                }
                return this.defaultRenderer.getListCellRendererComponent(jList, timeZone.getID() + " (" + timeZone.getDisplayName(bl3, 1) + ")", n, bl, bl2);
            }
            return this.defaultRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
        }
    }
}

