/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.mimeeditor.ExternalBlobEditor;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.controls.DelayedLoadingComboBox;
import oracle.dbtools.raptor.ui.controls.DelayedLoadingComboBoxLoader;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.controller.MenuManager;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.layout.ViewId;
import oracle.ide.log.Href;
import oracle.ide.log.MessagePage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserAdapter;
import oracle.ide.net.URLChooserEvent;
import oracle.ide.net.URLChooserListener;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.Traversable;
import oracle.ide.resource.NetArb;
import oracle.ide.util.Encodings;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class URLFileChooser
extends URLChooser {
    private static final long serialVersionUID = 1L;
    private static URL _lastURL;
    private boolean checkIfFileExists;
    private int _trackSelectionScope = -1;
    private boolean showEncodings;
    public static final String ENCODINGS_LABEL;
    public static final String ENCODINGS_TIP;
    private JLabel encodingsLabel = new JLabel();
    private JComboBox encodingsCombo;
    private static List<Object> _encodings;
    private static MessagePage MESSAGE_PAGE;
    private static final String MESSAGE_PAGE_ID = "URLFileChooserMessagePage";
    private static final JFileChooser _jFileChooser;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private URLChooserAdapter _adjustFileNameAdapter = new URLChooserAdapter(){

        public void listSelectionChanged(URLChooserEvent uRLChooserEvent) {
        }

        public void urlFilterChanged(URLChooserEvent uRLChooserEvent) {
            URLFileChooser.this.adjustFileNameURL(uRLChooserEvent.getCurrentFilter(), true);
        }
    };

    public URLFileChooser() {
        this((URL)null);
    }

    public URLFileChooser(URL uRL) {
        this(null, uRL);
    }

    public URLFileChooser(URL[] uRLArray, URL uRL) {
        this(uRLArray, uRL, Context.newIdeContext());
    }

    public URLFileChooser(Context context) {
        this(null, null, context);
    }

    private URLFileChooser(URL[] uRLArray, URL uRL, Context context) {
        super(uRLArray, uRL);
        this.setSelectionScope(0);
        DialogUtil.initURLChooser((URLChooser)this, (Context)context);
    }

    public int showOpenDialog(Component component) {
        return this.showOpenDialog(component, null);
    }

    public int showOpenDialog(Component component, String string) {
        return this.showOpenDialog(component, (Traversable)this, string);
    }

    public int showOpenDialog(Component component, Traversable traversable, String string) {
        int n = super.showOpenDialog(component, traversable, string);
        if (0 == n) {
            File file;
            if (this.checkIfFileExists() && (null == (file = this.getSelectedFile()) || !file.exists())) {
                MessageDialog.information((Component)((Object)this), (Object)Messages.getString("URLFileChooser.FileNotFound"), (String)string, null);
            }
            this.trackApproved(0, string);
        }
        return n;
    }

    public void setCheckIfFileExists(boolean bl) {
        this.checkIfFileExists = bl;
    }

    public boolean checkIfFileExists() {
        return this.checkIfFileExists;
    }

    public void setSelectionScope(int n) {
        super.setSelectionScope(n);
        this._trackSelectionScope = n;
    }

    private void trackApproved(int n, String string) {
        _lastURL = this.getSelectedURL();
        if (!URLFileSystem.isDirectory((URL)_lastURL)) {
            FileOpenHistory.getInstance().updateFileHistory(_lastURL);
        }
        String string2 = this.getChooserTitle(n, string);
        this.postMessage(string2, _lastURL);
    }

    private String getChooserTitle(int n, String string) {
        String string2;
        if (string != null) {
            return string;
        }
        switch (n) {
            case 0: {
                if (this._trackSelectionScope == 0 || this._trackSelectionScope == 2) {
                    string2 = NetArb.getString((int)15);
                    break;
                }
                string2 = NetArb.getString((int)17);
                break;
            }
            default: {
                string2 = this._trackSelectionScope == 0 ? NetArb.getString((int)19) : NetArb.getString((int)17);
            }
        }
        return string2;
    }

    public int showSaveDialog(Component component) {
        return this.showSaveDialog(component, null);
    }

    public int showSaveDialog(Component component, String string) {
        return this.showSaveDialog(component, (Traversable)this, string);
    }

    public int showSaveDialog(Component component, Traversable traversable, String string) {
        if (this._trackSelectionScope == 0) {
            this.addURLChooserListener((URLChooserListener)this._adjustFileNameAdapter);
        }
        int n = super.showSaveDialog(component, traversable, string);
        if (this._trackSelectionScope == 0) {
            this.adjustSelectedURL();
            if (0 == n) {
                this.trackApproved(1, string);
            }
        }
        return n;
    }

    public void showEncodings(boolean bl) {
        if (bl == this.showEncodings) {
            return;
        }
        if (this.showEncodings) {
            if (this.encodingsCombo != null) {
                this.remove(this.encodingsLabel);
                this.remove(this.encodingsCombo);
                this.changeShortcutBarHeight(4, 3);
                this.validate();
            }
        } else {
            if (null == this.encodingsCombo) {
                this.encodingsCombo = this.createEncodingsCombo(this.encodingsLabel);
            }
            Insets insets = new Insets(5, 5, 5, 0);
            this.add(this.encodingsLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add(this.encodingsCombo, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
            this.changeShortcutBarHeight(3, 4);
            this.validate();
        }
        this.showEncodings = bl;
    }

    JComboBox createEncodingsCombo(JLabel jLabel) {
        DelayedLoadingComboBox delayedLoadingComboBox = new DelayedLoadingComboBox(ENCODINGS_LABEL, IdeUtil.getIdeEncoding(), new DelayedLoadingComboBoxLoader(){

            @Override
            public List<Object> getComboContents() throws TaskException {
                if (null == _encodings) {
                    _encodings = Arrays.asList((Object[])Encodings.getEncodings());
                }
                return _encodings;
            }
        });
        ResourceUtils.resLabel((JLabel)jLabel, (Component)delayedLoadingComboBox, (String)ENCODINGS_LABEL);
        jLabel.setToolTipText(ENCODINGS_TIP);
        return delayedLoadingComboBox;
    }

    private void changeShortcutBarHeight(int n, int n2) {
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        for (Component component : this.getComponents()) {
            GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(component);
            if (gridBagConstraints.gridheight != n) continue;
            gridBagConstraints.gridheight = n2;
            this.remove(component);
            this.add(component, gridBagConstraints);
            break;
        }
    }

    public String getEncoding() {
        if (!this.showEncodings || null == this.encodingsCombo) {
            return IdeUtil.getIdeEncoding();
        }
        return this.encodingsCombo.getSelectedItem().toString();
    }

    public void setEncoding(String string) {
        this.showEncodings(true);
        this.encodingsCombo.setSelectedItem(string);
    }

    private File toFile(URL uRL) {
        URI uRI = this.toURI(uRL);
        return null == uRI ? null : new File(uRI);
    }

    private URI toURI(URL uRL) {
        URI uRI = null;
        try {
            uRI = new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)uRISyntaxException);
        }
        return uRI;
    }

    private void postMessage(String string, URL uRL) {
        MessagePage messagePage = this.getMessagePage();
        Href href = new Href(URLFileSystem.getFileName((URL)uRL), uRL){

            public void go() {
                File file = URLFileChooser.this.toFile(this.getURL());
                if (file.isDirectory()) {
                    try {
                        BrowserRunner browserRunner = BrowserRunner.getBrowserRunner();
                        browserRunner.runBrowserOnURL(this.getURL(), null, null);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                } else {
                    try {
                        Node node = NodeFactory.findOrCreate((URL)this.getURL());
                        if (node instanceof UnrecognizedTextNode) {
                            ExternalBlobEditor externalBlobEditor = new ExternalBlobEditor();
                            externalBlobEditor.setAbsolutePathFileName(file);
                            externalBlobEditor.executeExternalEditor(false);
                        } else {
                            Context context = Context.newIdeContext((Node)node);
                            context.setWorkspace(Ide.getActiveWorkspace());
                            context.setProject(Ide.getActiveProject());
                            EditorManager editorManager = EditorManager.getEditorManager();
                            editorManager.openEditor(new OpenEditorOptions(context, CodeEditor.class));
                        }
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                }
            }
        };
        messagePage.log((Object)(string + ": "), false);
        messagePage.log((Object)href, false);
        messagePage.log((Object)"\n", false);
    }

    private MessagePage getMessagePage() {
        if (null == MESSAGE_PAGE) {
            JMenu jMenu;
            try {
                jMenu = MenuManager.getJMenu((String)"File");
                if (jMenu == null) {
                    throw new IllegalStateException("Menu is unavailable - cannot initialise");
                }
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalStateException("Ide is unavailable - cannot initialise");
            }
            String string = jMenu.getText();
            MESSAGE_PAGE = new MessagePage(new ViewId(MESSAGE_PAGE_ID, string), null, true){
                private String _localToolTip;
                private MouseInputListener _mouseInputListener;
                {
                    this._localToolTip = "";
                }

                public Component getGUI() {
                    JTextComponent jTextComponent;
                    Component component = super.getGUI();
                    if (null == this._mouseInputListener && (jTextComponent = (JTextComponent)Utils.findFirst(component, JTextComponent.class)) != null) {
                        this._mouseInputListener = new MouseInputAdapter(){

                            @Override
                            public void mouseMoved(MouseEvent mouseEvent) {
                                Href href = null;
                                try {
                                    int n = jTextComponent.getUI().viewToModel(jTextComponent, mouseEvent.getPoint());
                                    href = this.findHrefByOffset(n);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                String string = this.getToolTip();
                                if (href != null) {
                                    _localToolTip = href.getURL().getPath();
                                } else {
                                    _localToolTip = "";
                                }
                                if (!_localToolTip.equals(string)) {
                                    this.updateToolTipText();
                                }
                            }
                        };
                        jTextComponent.addMouseMotionListener(this._mouseInputListener);
                    }
                    return component;
                }

                public String getToolTip() {
                    if ("".equals(this._localToolTip)) {
                        return super.getToolTip();
                    }
                    return this._localToolTip;
                }
            };
        }
        return MESSAGE_PAGE;
    }

    public URLFileChooser(File file) {
        this();
        this.setCurrentDirectory(file);
    }

    public File getCurrentDirectory() {
        URL uRL = this.getSelectedURL();
        File file = this.toFile(uRL);
        return file;
    }

    public void setCurrentDirectory(File file) {
        _jFileChooser.setCurrentDirectory(file);
        File file2 = _jFileChooser.getCurrentDirectory();
        try {
            this.setSelectedURL(file2.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)malformedURLException);
        }
    }

    public File getSelectedFile() {
        URL uRL = this.getSelectedURL();
        File file = this.toFile(uRL);
        return file;
    }

    public void setSelectedFile(File file) {
        try {
            this.setSelectedURL(file == null ? null : file.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)malformedURLException);
        }
    }

    public void setFileFilter(FileFilter fileFilter) {
        if (fileFilter != null) {
            this.setURLFilter(new FileFilterURLWrapper(fileFilter));
        }
    }

    public void setFileSelectionMode(int n) {
        this.setSelectionScope(n);
    }

    private String getDefaultExtension(URLFilter uRLFilter) {
        String string = "";
        String string2 = uRLFilter.toString();
        int n = string2.indexOf("*");
        int n2 = string2.indexOf(",");
        if (n != -1) {
            n2 = n2 != -1 ? n2 : string2.indexOf(")");
            string = string2.substring(n + 1, n2);
            string = string.equals(".*") ? "" : string;
        }
        return string;
    }

    private void adjustFileNameURL(URLFilter uRLFilter, boolean bl) {
        if (null == uRLFilter) {
            return;
        }
        String string = this.getFileNameURL();
        int n = string.lastIndexOf(".");
        String string2 = this.getDefaultExtension(uRLFilter);
        if (n != -1 && bl && !string2.equals("") && (string = string.substring(0, n)).endsWith(string2)) {
            this.setFileNameURL(string);
            return;
        }
        this.setFileNameURL(string + string2);
    }

    private void adjustSelectedURL() {
        URL[] uRLArray = this.getSelectedURLs();
        if (uRLArray.length == 0) {
            return;
        }
        if (this.getSelectedFilter() == null) {
            return;
        }
        if (this.getSelectedFilter().accept(uRLArray[0])) {
            return;
        }
        this.adjustFileNameURL(this.getSelectedFilter(), false);
        boolean bl = this.approveSelection();
        if (!bl) {
            URLFileChooserException uRLFileChooserException = new URLFileChooserException("approveSelection failed for " + this.getSelectedURL());
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)uRLFileChooserException);
            throw uRLFileChooserException;
        }
    }

    public static URLFileChooserPanel createURLFileChooserPanel() {
        return new URLFileChooserPanel();
    }

    public static URLFileChooserPanel createURLFileChooserPanel(int n, String string) {
        return new URLFileChooserPanel(n, string);
    }

    static {
        ENCODINGS_LABEL = Messages.getString("FilePanelAcc.1");
        ENCODINGS_TIP = Messages.getString("FilePanelAcc.0");
        _jFileChooser = new JFileChooser();
    }

    public static class URLFileChooserPanel
    extends JPanel
    implements LayoutControl {
        private static final long serialVersionUID = 1L;
        private URLFileChooser chooser = new URLFileChooser();
        private String labelText;
        private int chooserType;
        private JLabel uiLabel = new JLabel();
        private URLTextField uiText = URLTextField.newForSavingFile();
        private JButton uiButton = new JButton();
        public static final String CHOOSER_BUTTON_LABEL = Messages.getString("FilePanel.1");
        private JLabel uiEncLabel = new JLabel();
        private JComboBox uiEncCombo = this.chooser.createEncodingsCombo(this.uiEncLabel);

        public URLFileChooserPanel() {
            this(0, null);
        }

        public URLFileChooserPanel(int n, String string) {
            this.chooserType = n;
            this.labelText = string;
            this.initUI();
        }

        private void initUI() {
            if (null == this.labelText) {
                this.labelText = this.chooser.getChooserTitle(this.chooserType, null);
            }
            ResourceUtils.resLabel((JLabel)this.uiLabel, (Component)this.uiText, (String)this.labelText);
            ResourceUtils.resButton((AbstractButton)this.uiButton, (String)CHOOSER_BUTTON_LABEL);
            this.uiButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    URLFileChooserPanel.this.browseForURL();
                }
            });
            this.uiEncLabel.setVisible(false);
            this.uiEncCombo.setVisible(false);
            this.chooser.showEncodings(false);
            this.uiText.setURL(this.chooser.getSelectedURL());
            this.setLayout(new GridBagLayout());
            int n = 0;
            this.add((Component)this.uiLabel, LayoutControl.GBC.gbc(0, n, 1, 1, LayoutControl.GBC.Inset.NONE));
            this.add((Component)this.uiText, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
            this.add((Component)this.uiButton, LayoutControl.GBC.gbc(2, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP));
            this.add((Component)this.uiEncLabel, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
            this.add((Component)this.uiEncCombo, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X));
            LayoutControl.GBC.addVSpring(this, ++n);
        }

        private void browseForURL() {
            if (this.uiText.getURL() != null) {
                this.chooser.setSelectedURL(this.uiText.getURL());
            }
            this.chooser.setEncoding((String)this.uiEncCombo.getSelectedItem());
            int n = 0 == this.chooserType ? this.chooser.showOpenDialog(this, StringUtils.stripMnemonic((String)this.labelText)) : this.chooser.showSaveDialog(this, StringUtils.stripMnemonic((String)this.labelText));
            if (0 == n) {
                this.uiText.setURL(this.chooser.getSelectedURL());
                this.uiEncCombo.setSelectedItem(this.chooser.getEncoding());
            }
        }

        public void showEncodings(boolean bl) {
            this.chooser.showEncodings(bl);
            this.uiEncLabel.setVisible(bl);
            this.uiEncCombo.setVisible(bl);
            this.validate();
        }

        public String getEncoding() {
            return this.uiEncCombo.getSelectedItem().toString();
        }

        public void setEncoding(String string) {
            this.chooser.setEncoding(string);
            this.uiEncCombo.setSelectedItem(string);
        }

        public File getCurrentDirectory() {
            this.chooser.setSelectedURL(this.uiText.getURL());
            return this.chooser.getCurrentDirectory();
        }

        public void setCurrentDirectory(File file) {
            this.chooser.setCurrentDirectory(file);
            this.uiText.setURL(this.chooser.getSelectedURL());
        }

        public File getSelectedFile() {
            this.chooser.setSelectedURL(this.uiText.getURL());
            return this.chooser.getSelectedFile();
        }

        public void setSelectedFile(File file) {
            this.chooser.setSelectedFile(file);
            this.uiText.setURL(this.chooser.getSelectedURL());
        }

        public String getText() {
            return this.uiText.getText();
        }

        public void setText(String string) {
            this.setSelectedFile(new File(string));
        }

        public void setFileFilter(FileFilter fileFilter) {
            this.chooser.setFileFilter(fileFilter);
        }

        public void setFileSelectionMode(int n) {
            this.chooser.setFileSelectionMode(n);
        }

        public void addChooseableURLFilter(URLFilter uRLFilter) {
            this.chooser.addChooseableURLFilter(uRLFilter);
        }

        public URL getSelectedURL() {
            return this.chooser.getSelectedURL();
        }

        public void setSelectionMode(int n) {
            this.chooser.setSelectionMode(n);
        }

        public void setSelectedURL(URL uRL) {
            this.chooser.setSelectedURL(uRL);
            this.uiText.setURL(uRL);
        }

        public void setSelectionScope(int n) {
            this.chooser.setSelectionScope(n);
            this.uiText.setDirectoryOnly(1 == n);
        }

        public void setURLFilter(URLFilter uRLFilter) {
            this.chooser.setURLFilter(uRLFilter);
        }

        public void addURLChooserListener(URLChooserAdapter uRLChooserAdapter) {
            this.chooser.addURLChooserListener((URLChooserListener)uRLChooserAdapter);
        }

        public void removeURLChooserListener(URLChooserAdapter uRLChooserAdapter) {
            this.chooser.removeURLChooserListener((URLChooserListener)uRLChooserAdapter);
        }

        public void setCheckIfFileExists(boolean bl) {
            this.chooser.setCheckIfFileExists(bl);
            this.uiText.setValidateExistingFile(bl);
        }
    }

    public static class URLFileChooserException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        public URLFileChooserException() {
        }

        public URLFileChooserException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public URLFileChooserException(String string) {
            super(string);
        }

        public URLFileChooserException(Throwable throwable) {
            super(throwable);
        }
    }

    public class FileFilterURLWrapper
    implements URLFilter {
        private FileFilter _fileFilter;

        public FileFilterURLWrapper(FileFilter fileFilter) {
            assert (fileFilter != null);
            this._fileFilter = fileFilter;
        }

        public boolean accept(URL uRL) {
            if (uRL != null) {
                try {
                    File file = URLFileChooser.this.toFile(uRL);
                    return this._fileFilter.accept(file);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger.warn(this.getClass(), (String)(uRL.toString() + " skipped."), (Throwable)illegalArgumentException);
                }
            }
            return false;
        }

        public boolean equals(Object object) {
            return this._fileFilter.equals(object);
        }

        public String toString() {
            return this._fileFilter.getDescription();
        }
    }
}

