/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemacopy.wizard;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.schemacopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.schemacopy.wizard.CopyWizDBSelector;
import oracle.dbtools.raptor.schemacopy.wizard.CopyWizSummary;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class CopyWizMain {
    public static final String COPY_WIZ_NAME = "raptor.copyWizard";
    public static final int COPY_WIZ_ACTION = Ide.findOrCreateCmdID((String)"raptor.copyWizard");
    private static CopyWizMain INSTANCE;
    private static Context m_staticContext;

    public static Context getStaticContext() {
        return m_staticContext;
    }

    public void setContext(Context context) {
        m_staticContext = context;
    }

    public void setObjectFilter(ArrayList<DatabaseNode> arrayList) {
        if (m_staticContext == null) {
            m_staticContext = new Context();
        }
        try {
            m_staticContext.setProperty("OBJECT_FILTER", arrayList);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void setConnections(DatabaseConnection databaseConnection, DatabaseConnection databaseConnection2) {
        if (m_staticContext == null) {
            m_staticContext = new Context();
        }
        try {
            m_staticContext.setProperty("SOURCE_CONNECTION_NAME", (Object)databaseConnection.getQualifiedConnectionName());
            m_staticContext.setProperty("DEST_CONNECTION_NAME", (Object)databaseConnection2.getQualifiedConnectionName());
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private static FSM getFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(CopyWizArb.getString("STEP1"), CopyWizDBSelector.class, "f1_schemacopy_html");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)"Fin", (Object)"Fin");
        Step step2 = new Step(CopyWizArb.getString("SUMMARY"), CopyWizSummary.class, "f1_schemacopy2_html");
        fSMBuilder.newFinalState((Object)"Fin", step2);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public WizardDialog getWizard() {
        Object object;
        FSM fSM = CopyWizMain.getFSM();
        Namespace namespace = new Namespace();
        if (m_staticContext != null) {
            object = m_staticContext.getProperty("SOURCE_CONNECTION_NAME");
            if (object != null) {
                namespace.put("SOURCE_CONNECTION_NAME", object);
            }
            if ((object = m_staticContext.getProperty("DEST_CONNECTION_NAME")) != null) {
                namespace.put("DEST_CONNECTION_NAME", object);
            }
            if ((object = m_staticContext.getProperty("OBJECT_FILTER")) instanceof ArrayList) {
                namespace.put("OBJECT_FILTER", object);
            }
        }
        object = new FSMWizard(fSM, namespace);
        object.setWizardTitle(CopyWizArb.getString("MAIN_TITLE"));
        object.setShowStepNumber(true);
        object.setLogoImage(CopyWizArb.getImage("WIZ_IMAGE"));
        object.setRoadmapVisible(true);
        object.setSize(800, 800);
        return object.getDialog((Frame)Ide.getMainWindow());
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)COPY_WIZ_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public static CopyWizMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CopyWizMain();
        }
        return INSTANCE;
    }

    public void launch() {
        boolean bl = false;
        WizardDialog wizardDialog = this.getWizard();
        bl = WizardLauncher.runDialog((JDialog)wizardDialog);
    }

    static {
        m_staticContext = null;
    }

    public static class CopyController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == COPY_WIZ_ACTION) {
                CopyWizMain.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            boolean bl = true;
            String[] stringArray = Connections.getInstance().getConnNames();
            if (stringArray != null && stringArray.length < 2) {
                bl = false;
            }
            if (ideAction.getCommandId() == COPY_WIZ_ACTION) {
                ideAction.setEnabled(bl);
                return true;
            }
            return false;
        }
    }
}

