/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.runner.Mode;
import oracle.dbtools.raptor.runner.ParamTableModel;
import oracle.dbtools.raptor.runner.Parameter;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.util.ModelUtil;

class Procedure {
    private static Map<String, BasicDocument> s_docMap = new HashMap<String, BasicDocument>();
    private String _owner;
    private String _package;
    private String _name;
    private int _id;
    private int _overload;
    private Database _db;
    private PlsqlRoot _parseTree;
    private String _displayValue;
    private ParamTableModel _model;
    private BasicDocument _document;
    static final String INDENT = "  ";

    public Procedure(String string, String string2, int n, Database database, PlsqlRoot plsqlRoot) {
        this(string, null, string2, n, 0, database, plsqlRoot);
    }

    public Procedure(String string, String string2, String string3, int n, int n2, Database database, PlsqlRoot plsqlRoot) {
        this._owner = string;
        this._package = string2;
        this._name = string3;
        this._id = n;
        this._overload = n2;
        this._db = database;
        this._parseTree = plsqlRoot;
    }

    public String toString() {
        if (this._displayValue == null) {
            this._displayValue = this._overload > 0 ? this._name + "(" + this._overload + ")" : this._name;
        }
        return this._displayValue;
    }

    public ParamTableModel getTableModel() throws SQLException {
        if (this._model == null) {
            this._model = new ParamTableModel(this);
        }
        return this._model;
    }

    public Connection getConnection() {
        return this._db.getConnection();
    }

    public String getPackage() {
        return this._package;
    }

    public String getName() {
        return this._name;
    }

    public int getOverload() {
        return this._overload;
    }

    public String getOwner() {
        return this._owner;
    }

    public int getObjectID() {
        return this._id;
    }

    public PlsqlRoot getParseTree() {
        return this._parseTree;
    }

    public BasicDocument getDocument() throws SQLException {
        if (this._document == null) {
            this._document = s_docMap.get(this._getHashName());
            if (this._document == null) {
                TextBuffer textBuffer = this._generateBuffer();
                this._document = new BasicDocument("foo.plsql", textBuffer);
            }
        }
        return this._document;
    }

    public void saveDocument() {
        if (this._document != null) {
            s_docMap.put(this._getHashName(), this._document);
        }
    }

    public void resetDocument() {
        this._document = null;
        s_docMap.remove(this._getHashName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextBuffer _generateBuffer() throws SQLException {
        char[] cArray = this.generateRunBlock();
        TextBuffer textBuffer = TextBufferFactory.createGapTextBuffer();
        textBuffer.writeLock();
        try {
            textBuffer.insert(0, cArray);
        }
        catch (Exception exception) {
        }
        finally {
            textBuffer.writeUnlock();
        }
        return textBuffer;
    }

    public char[] generateRunBlock() throws SQLException {
        Object object;
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        boolean bl = true;
        String string = this._db.getConnection().getMetaData().getUserName();
        bl = ModelUtil.areDifferent((Object)string, (Object)this._owner);
        ParamTableModel paramTableModel = this.getTableModel();
        int n = paramTableModel.getRowCount();
        if (n == 0) {
            fastStringBuffer.append("BEGIN\n  ");
            fastStringBuffer.append(this._getCallName(bl));
            fastStringBuffer.append("();\nEND;");
        } else {
            Mode mode;
            int n2;
            object = null;
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            Parameter parameter = paramTableModel.getParameter(0);
            if (parameter.isReturn()) {
                object = parameter;
            } else {
                arrayList.add(parameter);
            }
            for (n2 = 1; n2 < n; ++n2) {
                arrayList.add(paramTableModel.getParameter(n2));
            }
            n = arrayList.size();
            fastStringBuffer.append("DECLARE\n");
            for (n2 = 0; n2 < n; ++n2) {
                parameter = (Parameter)arrayList.get(n2);
                parameter.generateDeclaration(fastStringBuffer);
            }
            if (object != null) {
                object.generateDeclaration(fastStringBuffer);
            }
            fastStringBuffer.append("BEGIN\n");
            for (n2 = 0; n2 < n; ++n2) {
                parameter = (Parameter)arrayList.get(n2);
                mode = parameter.getMode();
                if (mode.equals(Mode.OUT)) continue;
                parameter.generateInitialization(fastStringBuffer);
            }
            fastStringBuffer.append("\n");
            fastStringBuffer.append(INDENT);
            if (object != null) {
                fastStringBuffer.append(object.getVarName());
                fastStringBuffer.append(" := ");
            }
            fastStringBuffer.append(this._getCallName(bl));
            fastStringBuffer.append("(");
            if (n > 0) {
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
                parameter = (Parameter)arrayList.get(0);
                parameter.generateCallReference(fastStringBuffer);
                for (n2 = 1; n2 < n; ++n2) {
                    fastStringBuffer.append(",\n");
                    fastStringBuffer.append(INDENT);
                    parameter = (Parameter)arrayList.get(n2);
                    parameter.generateCallReference(fastStringBuffer);
                }
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
            }
            fastStringBuffer.append(");\n");
            if (object != null) {
                object.generateResultOutput(fastStringBuffer);
            }
            for (n2 = 0; n2 < n; ++n2) {
                parameter = (Parameter)arrayList.get(n2);
                mode = parameter.getMode();
                if (mode.equals(Mode.IN)) continue;
                parameter.generateResultOutput(fastStringBuffer);
            }
            fastStringBuffer.append("END;\n");
        }
        object = new char[fastStringBuffer.length()];
        fastStringBuffer.getChars(0, ((Object)object).length, (char[])object, 0);
        return object;
    }

    private String _getCallName(boolean bl) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        if (bl && ModelUtil.hasLength((String)this._owner)) {
            fastStringBuffer.append(DBUtil.addDoubleQuote((String)this._owner)).append('.');
        }
        if (ModelUtil.hasLength((String)this._package)) {
            fastStringBuffer.append(DBUtil.addDoubleQuote((String)this._package)).append('.');
        }
        fastStringBuffer.append(DBUtil.addDoubleQuote((String)this._name));
        return fastStringBuffer.toString();
    }

    private String _getHashName() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append(this._getCallName(true));
        if (this._overload > 0) {
            fastStringBuffer.append("(" + this._overload + ")");
        }
        String string = null;
        try {
            Connection connection = this._db.getConnection();
            string = connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (ModelUtil.hasLength(string)) {
            fastStringBuffer.append('@').append(string);
        }
        return fastStringBuffer.toString();
    }
}

