/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.logging.Logger;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.runner.ArgusHelper;
import oracle.dbtools.raptor.runner.Messages;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.SourceFinder;

public final class DBSourceFinder
implements SourceFinder {
    private static Logger logger = Logger.getLogger(DBSourceFinder.class.getName());
    private String _cName;
    private static HashSet<String> warned = new HashSet();

    public DBSourceFinder(String string) {
        this._cName = string;
    }

    public URL findSourceFile(Workspace workspace, Project project, String string, String string2) {
        String string3;
        String string4;
        URL uRL = null;
        String string5 = string4 = this._cName != null ? this._cName : DBSourceFinder.getProjectConnectionName(project);
        if (string4 != null && string4.length() > 0) {
            uRL = DBSourceFinder.findSourceFile(string4, string, string2);
        }
        if (uRL != null && DBConfig.getInstance().getBoolean("LINKDBWITHFILESOURCES").booleanValue() && (string3 = oracle.dbtools.raptor.navigator.plsql.Project.getInstance().getFileURL(uRL.toString())) != null) {
            try {
                URL uRL2 = new URL(string3);
                Node node = NodeFactory.findOrCreate((URL)uRL);
                Node node2 = NodeFactory.findOrCreate((URL)uRL2);
                if (node instanceof PlSqlNode && node instanceof PlSqlNode) {
                    String string6;
                    String string7 = ((PlSqlNode)node).getSource();
                    if (string7.endsWith("\n")) {
                        string7 = string7.substring(0, string7.length() - 1);
                    }
                    if ((string6 = ((PlSqlNode)node2).getSource()).endsWith("\n")) {
                        string6 = string6.substring(0, string6.length() - 1);
                    }
                    if (!string7.equals(string6)) {
                        if (!warned.contains(string3)) {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("DBSourceFinder.Message"), (String)Messages.getString("DBSourceFinder.Title"), null);
                        }
                        warned.add(string3);
                        logger.warning("Different db and file based sources. Returning db based source.");
                        return uRL;
                    }
                    warned.remove(string3);
                }
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                logger.severe("Malformed file URL. Returning db based source.");
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.severe("IllegalAccessException. Returning db based source.");
            }
            catch (InstantiationException instantiationException) {
                logger.severe("InstantiationException. Returning db based source.");
            }
        }
        return uRL;
    }

    public static void resetWarning(PlSqlNode plSqlNode) {
        warned.remove(plSqlNode.getURL().toString());
    }

    public static URL findSourceFile(String string, String string2, String string3) {
        String string4 = DBSourceFinder._createArgusString(string2, string3);
        URL uRL = ArgusHelper.argusStringToUrl(string4, string);
        if (URLFileSystem.exists((URL)uRL)) {
            logger.info("CmSourceFinder: URL=" + uRL);
            return uRL;
        }
        return null;
    }

    private static RunConfiguration _getRunConfiguration(Project project) {
        if (project != null) {
            return RunConfiguration.getInstance((PropertyStorage)project);
        }
        return null;
    }

    public static String getProjectConnectionName(Project project) {
        RunConfiguration runConfiguration = DBSourceFinder._getRunConfiguration(project);
        return runConfiguration != null ? runConfiguration.getConnectionName() : null;
    }

    private static String _createArgusString(String string, String string2) {
        String string3 = string2;
        if (string2.endsWith(".pls")) {
            int n = string2.length() - 4;
            string3 = string2.substring(0, n);
        }
        return string + "." + string3;
    }
}

