/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.refactor.CaseConverter;
import oracle.dbtools.raptor.refactor.Messages;
import oracle.dbtools.raptor.refactor.Obfuscator;
import oracle.dbtools.raptor.refactor.ProcedureExtractor;
import oracle.dbtools.raptor.refactor.Renamer;
import oracle.dbtools.raptor.refactor.Surrounder;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public class RefactorMenu
implements Controller,
ContextMenuListener {
    private static final String ACCELERATOR_FILE = "oracle/dbtools/raptor/refactor/accelerators.xml";
    private static RefactorMenu _instance;
    private static String UPPER_LOWER_INITCAP;
    private static String EXTRACT_PROCEDURE;
    private static String RENAME;
    private static String OBFUSCATE;
    private static String SURROUND;
    private static String FOR;
    private static String WHILE;
    private static String BLOCK;
    private static int _cmdULI;
    private static int _cmdEP;
    private static int _cmdRN;
    private static int _cmdOB;
    public static int cmdFOR;
    public static int cmdWHILE;
    public static int cmdBLOCK;
    private IdeAction actionUpperLowerInitcap = null;
    private IdeAction actionExtractProcedure = null;
    private IdeAction actionRename = null;
    private IdeAction actionObfuscate = null;
    private IdeAction actionFOR = null;
    private IdeAction actionWHILE = null;
    private IdeAction actionBLOCK = null;
    private ProcedureExtractor procExtractor = null;
    private Renamer renamer = null;
    private Obfuscator obfuscator = null;
    private Surrounder surrounder = null;

    public static RefactorMenu getInstance() {
        if (_instance == null) {
            _instance = new RefactorMenu();
        }
        return _instance;
    }

    public void initAction() {
        this.actionUpperLowerInitcap = this.initAction(UPPER_LOWER_INITCAP, this.actionUpperLowerInitcap, _cmdULI, RaptorImagesArb.getIcon("CASE"));
        this.actionExtractProcedure = this.initAction(EXTRACT_PROCEDURE, this.actionExtractProcedure, _cmdEP, null);
        this.actionRename = this.initAction(RENAME, this.actionRename, _cmdRN, null);
        this.actionObfuscate = this.initAction(OBFUSCATE, this.actionObfuscate, _cmdOB, null);
        this.actionFOR = this.initAction(FOR, this.actionFOR, cmdFOR, null);
        this.actionWHILE = this.initAction(WHILE, this.actionWHILE, cmdWHILE, null);
        this.actionBLOCK = this.initAction(BLOCK, this.actionBLOCK, cmdBLOCK, null);
    }

    private IdeAction initAction(String string, IdeAction ideAction, int n, Icon icon) {
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n2 = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (ideAction == null) {
            ideAction = IdeAction.get((int)n, null, (String)string2, null, (Integer)n2, (Icon)icon, null, (boolean)false);
            ideAction.setEnabled(true);
        }
        ideAction.addController((Controller)this);
        ideAction.setEnabled(true);
        return ideAction;
    }

    public static void init() {
        RefactorMenu.getInstance().initAction();
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)RefactorMenu.getInstance());
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(RefactorMenu.getInstance().getClass().getClassLoader(), ACCELERATOR_FILE);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (_cmdULI == n) {
            CaseConverter.convert(context);
            return true;
        }
        if (_cmdEP == n) {
            if (this.procExtractor == null) {
                this.procExtractor = new ProcedureExtractor();
            }
            this.procExtractor.extract(context);
            return true;
        }
        if (_cmdRN == n) {
            if (this.renamer == null) {
                this.renamer = new Renamer();
            }
            this.renamer.rename(context);
            return true;
        }
        if (_cmdOB == n) {
            if (this.obfuscator == null) {
                this.obfuscator = new Obfuscator();
            }
            this.obfuscator.obfuscate(context);
            return true;
        }
        if (cmdFOR == n || cmdWHILE == n || cmdBLOCK == n) {
            if (this.surrounder == null) {
                this.surrounder = new Surrounder();
            }
            this.surrounder.surround(context, n);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    public boolean handleDefaultAction(Context context) {
        return true;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context;
        Context context2 = context = contextMenu == null ? null : contextMenu.getContext();
        if (context == null) {
            return;
        }
        if (RefactorMenu.isMenuAvailable(context)) {
            String string = Messages.getString("RefactorMenu.7");
            JMenu jMenu = contextMenu.createMenu(string, (float)StringUtils.getMnemonicKeyCode((String)string));
            if (RefactorMenu.isPlsqlCodeEditor(context)) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.actionUpperLowerInitcap));
            }
            jMenu.add(contextMenu.createMenuItem((ToggleAction)this.actionExtractProcedure));
            jMenu.add(contextMenu.createMenuItem((ToggleAction)this.actionRename));
            jMenu.add(contextMenu.createMenuItem((ToggleAction)this.actionObfuscate));
            jMenu.setSelected(false);
            contextMenu.add((Component)jMenu);
            String string2 = Messages.getString("SurroundWith");
            JMenu jMenu2 = contextMenu.createMenu(string2, (float)StringUtils.getMnemonicKeyCode((String)string2));
            jMenu2.add(contextMenu.createMenuItem((ToggleAction)this.actionFOR));
            jMenu2.add(contextMenu.createMenuItem((ToggleAction)this.actionWHILE));
            jMenu2.add(contextMenu.createMenuItem((ToggleAction)this.actionBLOCK));
            jMenu.add(jMenu2);
        }
    }

    private static boolean isMenuAvailable(Context context) {
        Node node = context.getNode();
        View view = context.getView();
        String string = node.getShortLabel();
        if (node instanceof PlSqlNode && ("BLOCK".equals(((PlSqlNode)node).getObjectType()) || string != null && string.toLowerCase().startsWith("anon_block"))) {
            return false;
        }
        return (node.getClass().getName().endsWith("PlSqlNode") || node.getClass().getName().endsWith("PlSqlBaseNode") || node.getClass().getName().endsWith("TriggerNode") || view.getClass().getName().endsWith("Worksheet")) && context.getEvent().getSource() instanceof JTextComponent;
    }

    private static boolean isPlsqlCodeEditor(Context context) {
        Node node = context.getNode();
        return (node.getClass().getName().endsWith("PlSqlNode") || node.getClass().getName().endsWith("PlSqlBaseNode") || node.getClass().getName().endsWith("TriggerNode")) && context.getEvent().getSource() instanceof JTextComponent;
    }

    static {
        UPPER_LOWER_INITCAP = Messages.getString("RefactorMenu.1");
        EXTRACT_PROCEDURE = Messages.getString("RefactorMenu.2");
        RENAME = Messages.getString("RefactorMenu.3");
        OBFUSCATE = Messages.getString("RefactorMenu.obfuscate");
        SURROUND = Messages.getString("SurroundWith");
        FOR = Messages.getString("ForLoop");
        WHILE = Messages.getString("WhileLoop");
        BLOCK = Messages.getString("PlSqlBlock");
        _cmdULI = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.CASE_ID");
        _cmdEP = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.EXTR_PROC_ID");
        _cmdRN = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.RENAME_ID");
        _cmdOB = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.OBFUSCATE_ID");
        cmdFOR = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.FOR_ID");
        cmdWHILE = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.WHILE_ID");
        cmdBLOCK = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.refactor.RefactorMenu.BLOCK_ID");
    }
}

