/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.config.NonUserConfigOptions;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.plsql.SqlKeywords;

public class CaseConverter {
    private static Map<BasicEditorPane, String> initialText = new HashMap<BasicEditorPane, String>();
    private static Map<BasicEditorPane, Long> range = new HashMap<BasicEditorPane, Long>();

    public static CASE getState() {
        try {
            String string = NonUserConfigOptions.get("CaseConverter.state");
            if (string == null || CASE.NONE.toString().equals(string) || "NONE".equals(string)) {
                return CASE.NONE;
            }
            if (CASE.UPPER.toString().equals(string) || "UPPER".equals(string)) {
                return CASE.UPPER;
            }
            if (CASE.LOWER.toString().equals(string) || "LOWER".equals(string)) {
                return CASE.LOWER;
            }
            if (CASE.INITCAP.toString().equals(string) || "INITCAP".equals(string)) {
                return CASE.INITCAP;
            }
            if (CASE.UPPER_KW.toString().equals(string) || "UPPER_KW".equals(string)) {
                return CASE.UPPER_KW;
            }
            if (CASE.LOWER_KW_UPPER_ID.toString().equals(string) || "LOWER_KW_UPPER_ID".equals(string)) {
                return CASE.LOWER_KW_UPPER_ID;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return CASE.NONE;
    }

    public static boolean convert(Context context) {
        View view = context.getView();
        BasicEditorPane basicEditorPane = ((FindableEditor)view).getFocusedEditorPane();
        return CaseConverter.convert(basicEditorPane);
    }

    public static boolean convert(BasicEditorPane basicEditorPane) {
        int n = basicEditorPane.getSelectionStart();
        int n2 = basicEditorPane.getSelectionEnd();
        if (n2 == 0 || n == n2) {
            return false;
        }
        CASE cASE = CaseConverter.getState().rotate();
        NonUserConfigOptions.put("CaseConverter.state", cASE.toString());
        Ide.getStatusBar().setText(cASE.toString());
        try {
            String string = basicEditorPane.getText(n, n2 - n);
            String string2 = initialText.get(basicEditorPane);
            Long l = range.get(basicEditorPane);
            if (l != null && (Service.lX((long)l) != n || Service.lY((long)l) != n2)) {
                initialText.remove(basicEditorPane);
                range.remove(basicEditorPane);
                string2 = null;
            }
            if (string2 == null) {
                string2 = string;
                initialText.put(basicEditorPane, string2);
                range.put(basicEditorPane, Service.lPair((int)n, (int)n2));
            }
            string = cASE.convert(string);
            basicEditorPane.replaceSelection(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        basicEditorPane.setSelectionStart(n);
        basicEditorPane.setSelectionEnd(n2);
        basicEditorPane.setToolTipText(cASE.toString());
        return true;
    }

    private static boolean isKeyword(String string) {
        for (String string2 : SqlKeywords.KW_words) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        for (String string2 : SqlKeywords.DW_words) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static enum CASE {
        NONE{

            @Override
            public String convert(String string) {
                return string;
            }

            @Override
            CASE rotate() {
                return INITCAP;
            }

            public String toString() {
                return "None";
            }
        }
        ,
        INITCAP{

            @Override
            public String convert(String string) {
                List list = LexerToken.parse((String)string, (boolean)true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : list) {
                    if (lexerToken.type == Token.IDENTIFIER) {
                        char[] cArray = new char[lexerToken.content.length()];
                        int n = 37;
                        for (int i = 0; i < cArray.length; ++i) {
                            char c = lexerToken.content.charAt(i);
                            cArray[i] = i == 0 || n == 95 ? Character.toUpperCase(c) : Character.toLowerCase(c);
                            n = c;
                        }
                        stringBuffer.append(cArray);
                        continue;
                    }
                    stringBuffer.append(lexerToken.content);
                }
                return stringBuffer.toString();
            }

            @Override
            CASE rotate() {
                return UPPER;
            }

            public String toString() {
                return "Initial Cap";
            }
        }
        ,
        UPPER{

            @Override
            public String convert(String string) {
                List list = LexerToken.parse((String)string, (boolean)true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : list) {
                    if (lexerToken.type == Token.IDENTIFIER) {
                        String string2 = lexerToken.content.toUpperCase();
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(lexerToken.content);
                }
                return stringBuffer.toString();
            }

            @Override
            CASE rotate() {
                return LOWER;
            }

            public String toString() {
                return "Upper Case";
            }
        }
        ,
        UPPER_KW{

            @Override
            public String convert(String string) {
                List list = LexerToken.parse((String)string, (boolean)true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : list) {
                    String string2 = lexerToken.content;
                    if (lexerToken.type == Token.IDENTIFIER && CaseConverter.isKeyword(string2)) {
                        String string3 = string2.toUpperCase();
                        stringBuffer.append(string3);
                        continue;
                    }
                    stringBuffer.append(string2);
                }
                return stringBuffer.toString();
            }

            @Override
            CASE rotate() {
                return LOWER_KW_UPPER_ID;
            }

            public String toString() {
                return "Upper Keywords";
            }
        }
        ,
        LOWER{

            @Override
            public String convert(String string) {
                List list = LexerToken.parse((String)string, (boolean)true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : list) {
                    if (lexerToken.type == Token.IDENTIFIER) {
                        String string2 = lexerToken.content.toLowerCase();
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(lexerToken.content);
                }
                return stringBuffer.toString();
            }

            @Override
            CASE rotate() {
                return UPPER_KW;
            }

            public String toString() {
                return "Lower Case";
            }
        }
        ,
        LOWER_KW_UPPER_ID{

            @Override
            public String convert(String string) {
                List list = LexerToken.parse((String)string, (boolean)true);
                StringBuffer stringBuffer = new StringBuffer();
                for (LexerToken lexerToken : list) {
                    String string2 = lexerToken.content;
                    if (lexerToken.type == Token.IDENTIFIER) {
                        if (CaseConverter.isKeyword(string2)) {
                            stringBuffer.append(string2.toLowerCase());
                            continue;
                        }
                        stringBuffer.append(string2.toUpperCase());
                        continue;
                    }
                    stringBuffer.append(string2);
                }
                return stringBuffer.toString();
            }

            @Override
            CASE rotate() {
                return NONE;
            }

            public String toString() {
                return "Lower Keywords, Upper Identifiers";
            }
        };


        public abstract String convert(String var1);

        abstract CASE rotate();
    }
}

