/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.queryBuilder.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.db.Table;
import oracle.dbtools.raptor.queryBuilder.model.ColumnWrapper;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.RelationUsage;

public class TableWrapper
extends Table {
    private Relation _relation;
    private RelationUsage _usage;
    private List<ColumnWrapper> _colList;
    private List<ColumnWrapper> _pkColList;
    private List<ColumnWrapper> _ukColList;

    public TableWrapper(Relation relation) {
        this._relation = relation;
        this._usage = null;
    }

    public TableWrapper(RelationUsage relationUsage) {
        this._usage = relationUsage;
        try {
            this._relation = (Relation)relationUsage.getObjectID().resolveID();
        }
        catch (DBException dBException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
    }

    private void checkInit() {
        if (this._colList == null || this._pkColList == null) {
            this._colList = new ArrayList<ColumnWrapper>();
            HashMap<oracle.javatools.db.Column, ColumnWrapper> hashMap = new HashMap<oracle.javatools.db.Column, ColumnWrapper>();
            oracle.javatools.db.Column[] columnArray = this.getRelation().getColumns();
            for (int i = 0; i < columnArray.length; ++i) {
                ColumnWrapper columnWrapper = new ColumnWrapper(this, columnArray[i]);
                this._colList.add(columnWrapper);
                hashMap.put(columnArray[i], columnWrapper);
            }
            this._pkColList = new ArrayList<ColumnWrapper>();
            this._ukColList = new ArrayList<ColumnWrapper>();
            Constraint[] constraintArray = this.getRelation().getConstraints();
            for (int i = 0; i < constraintArray.length; ++i) {
                String string = constraintArray[i].getConstraintType();
                if (string.equals("PKConstraint")) {
                    for (oracle.javatools.db.Column column : ((PKConstraint)constraintArray[i]).getColumns()) {
                        this._pkColList.add((ColumnWrapper)((Object)hashMap.get(column)));
                    }
                    continue;
                }
                if (!string.equals("UniqueConstraint")) continue;
                for (oracle.javatools.db.Column column : ((UniqueConstraint)constraintArray[i]).getColumns()) {
                    this._ukColList.add((ColumnWrapper)((Object)hashMap.get(column)));
                }
            }
        }
    }

    public Relation getRelation() {
        return this._relation;
    }

    public FromObject getFromObject() {
        return this._usage != null ? (FromObject)this._usage.getParent() : null;
    }

    public void setFromObject(FromObject fromObject) {
        if (fromObject.getExpression() instanceof RelationUsage) {
            this.setRelationUsage((RelationUsage)fromObject.getExpression());
        }
    }

    public RelationUsage getRelationUsage() {
        return this._usage;
    }

    public void setRelationUsage(RelationUsage relationUsage) {
        this._usage = relationUsage;
    }

    public Column getColumn(int n) {
        this.checkInit();
        return this._colList.get(n);
    }

    public int getColumnCount() {
        this.checkInit();
        return this._colList.size();
    }

    public String getDisplayName(Locale locale) {
        return this.getRelation().getName();
    }

    public int getForeignKeyCount() {
        this.checkInit();
        return 0;
    }

    public Relationship getForeignKey(int n) {
        return null;
    }

    public Relationship getForeignKey(DBObjectID dBObjectID) {
        return null;
    }

    public String getName() {
        if (this.getRelationUsage() != null) {
            return ((FromObject)this.getRelationUsage().getParent()).getName();
        }
        return this.getRelation().getName();
    }

    public Column getPrimaryKey(int n) {
        this.checkInit();
        return this._pkColList.get(n);
    }

    public int getPrimaryKeyCount() {
        this.checkInit();
        return this._pkColList.size();
    }

    public Schema getSchema() {
        return null;
    }

    public Column getUniqueKey(int n) {
        this.checkInit();
        return this._ukColList.get(n);
    }

    public int getUniqueKeyCount() {
        this.checkInit();
        return this._ukColList.size();
    }
}

