/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Component;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public class OutlineMenu
implements Controller,
ContextMenuListener {
    public static String QUICK_OUTLINE = Messages.getString("QuickOutline");
    private static int cmdOutline = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.plsql.structure.OUTLINE");
    private IdeAction actionOutline = null;
    private static OutlineMenu _instance;

    public static OutlineMenu getInstance() {
        if (_instance == null) {
            _instance = new OutlineMenu();
        }
        return _instance;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        OutlineWindow outlineWindow = OutlineWindow.getInstance();
        DockUtil.showDockableWindow((DockableView)outlineWindow);
        View view = context.getView();
        ((OutlinePanel)outlineWindow.getGUI()).buildNewOutlineTree(view);
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context;
        Context context2 = context = contextMenu == null ? null : contextMenu.getContext();
        if (context == null) {
            return;
        }
        Node node = context.getNode();
        if (!(node instanceof PlSqlNode)) {
            return;
        }
        String string = node.getShortLabel();
        if (string != null && string.toLowerCase().startsWith("anon_block")) {
            return;
        }
        this.createAction();
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.actionOutline));
    }

    private void createAction() {
        if (this.actionOutline == null) {
            this.actionOutline = IdeAction.get((int)cmdOutline, null, (String)QUICK_OUTLINE, null, null, null, null, (boolean)true);
            this.actionOutline.addController((Controller)this);
        }
    }

    public static void init() {
        DockStation dockStation;
        if (!RaptorExtensionConstants.isStandAlone()) {
            return;
        }
        try {
            dockStation = DockStation.getDockStation();
            dockStation.registerDockableFactory("OUTLINE_VIEW_TYPE", (DockableFactory)OutlineWindow.getInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)OutlineMenu.getInstance());
        dockStation = Ide.getKeyStrokeContextRegistry();
    }

    private void initAction() {
        String string = QUICK_OUTLINE;
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (this.actionOutline == null) {
            this.actionOutline = IdeAction.get((int)cmdOutline, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this.actionOutline.setEnabled(true);
        }
        this.actionOutline.addController((Controller)this);
        this.actionOutline.setEnabled(true);
    }
}

