/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.dbtools.raptor.plsql.MasterDetailPanel;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.javatools.util.Log;

public class PLSQLProfiles
extends MasterDetailPanel {
    boolean knowApplicable = false;

    @Override
    public String parentQuery() {
        if (!this.knowApplicable) {
            try {
                if (this.dbVersion() < 110) {
                    return "Select 'RDBMS version 11 is minimal required' \"Warning\" from dual";
                }
                Connection connection = Connections.getInstance().getConnection(this.getConnectionName());
                Statement statement = connection.createStatement();
                statement.executeQuery("select 1 from DBMSHP_FUNCTION_INFO where rownum = 1 union all select 1 from DBMSHP_PARENT_CHILD_INFO where rownum = 1 union all select 1 from DBMSHP_RUNS where rownum = 1 ");
                statement.close();
                this.knowApplicable = true;
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 942 || sQLException.getErrorCode() == 1775) {
                    return "Select 'Required tables DBMSHP_FUNCTION_INFO,DBMSHP_PARENT_CHILD_INFO,DBMSHP_RUNS missing' \"Warning\" from dual";
                }
                return "Select 'Unexpected SQLException during version check' \"Warning\" from dual";
            }
            catch (DBException dBException) {
                Log.error((String)("Unexpected DBException " + dBException.getMessage()));
            }
        }
        return "SELECT fi.runid RUNID, \nto_char(r.run_timestamp,'dd-mon-yyyy hh:mi') \"Timestamp\", \ncase when r.run_comment is null then ' ' else r.run_comment end \"Comment\", \n'<html><b>'||r.total_elapsed_time||'</b> &mu;s</html>' \"Total Elapsed Time\" \nFROM dbmshp_function_info fi, dbmshp_parent_child_info pc, dbmshp_runs r \nWHERE OWNER = :OBJECT_OWNER and module=:OBJECT_NAME and SYMBOLID=CHILDSYMID \nand pc.runid=fi.runid and pc.runid=r.runid and parentsymid =1 \norder by runid";
    }

    @Override
    public String[] childQueries() {
        return new String[]{"select \n'<html><b>'||c.subtree_elapsed_time||'</b> &mu;s</html>' \"Total\",\n'<html><b>'||to_char(c.subtree_elapsed_time*100/total,'990d0')||'%'||'</b></html>' \"Tot%\",  \nc.function_elapsed_time \"Function\",  \nto_char(c.function_elapsed_time*100/total, '990d0')||'%' \"Fun%\",  \nc.subtree_elapsed_time-c.function_elapsed_time \"Descendants\",  \nto_char((c.subtree_elapsed_time-c.function_elapsed_time)*100/total, '990d0')||'%' \"Desc%\", \nc.calls \"Calls\",  \nto_char(c.calls*100/tcalls, '990d0')||'%' \"Cal%\", \nc.owner || '.' ||\ncase when c.module = c.function then c.function else c.module||'.'||c.function end ||\ncase when c.line# = 0 then '' else ' (Line '||c.line#||')' end \n\"Function Name\"\nfrom dbmshp_function_info c\n, (select max(subtree_elapsed_time) total,sum(calls) tcalls from dbmshp_function_info where  runid=:RUNID)\nwhere  c.runid=:RUNID\n", "select\n'<html><b>'||sum(c.function_elapsed_time)||'</b> &mu;s</html>' \"Exec Time\", \n'<html><b>'||to_char(sum(c.function_elapsed_time)*100/total,'990d0')||'%'||'</b></html>' \"Tot%\",  \nsum(c.calls) \"Calls\",\nto_char(sum(c.calls)*100/tcalls, '990d0')||'%' \"Cal%\", \nc.owner || '.' || c.module\n\"Module\"\nfrom dbmshp_function_info c\n, (select max(subtree_elapsed_time) total,sum(calls) tcalls from dbmshp_function_info where  runid=:RUNID)\nwhere  c.runid=:RUNID\ngroup by c.owner, c.module, total, tcalls\t\n", "select\n'<html><b>'||sum(c.function_elapsed_time)||'</b> &mu;s</html>' \"Exec Time\",\n'<html><b>'||to_char(sum(c.function_elapsed_time)*100/total,'990d0')||'%'||'</b></html>' \"Tot%\", \nsum(c.calls) \"Calls\",  \nto_char(sum(c.calls)*100/tcalls, '990d0')||'%' \"Cal%\",  \nc.namespace  \"Namespace\"\nfrom dbmshp_function_info c\n, (select max(subtree_elapsed_time) total,sum(calls) tcalls from dbmshp_function_info where  runid=:RUNID)\nwhere  c.runid=:RUNID\ngroup by c.namespace, total, tcalls\n", "select LPAD(' ', (LEVEL-1) * 4) || c.owner || '.' ||\ncase when c.module = c.function then c.function else c.module||'.'||c.function end \"Callee\",\n'<html><P align=\"right\"><b>'||pc.function_elapsed_time||'</b> &mu;s</p></html>' \"Elapsed\", \npc.subtree_elapsed_time \"Aggregated\", pc.calls \"Calls#\"\nfrom dbmshp_parent_child_info pc, dbmshp_function_info p, dbmshp_function_info c\nstart with  pc.runid=:RUNID and p.runid = pc.runid and c.runid = pc.runid\nand pc.childsymid = c.symbolid and pc.parentsymid = p.symbolid and p.symbolid=1\nconnect by  pc.runid=prior pc.runid and p.runid = pc.runid and c.runid = pc.runid\nand pc.childsymid = c.symbolid and pc.parentsymid = p.symbolid\nand prior pc.childsymid = pc.parentsymid"};
    }

    @Override
    public String[] tabNames() {
        return new String[]{Messages.getString("FunctionCalls"), Messages.getString("Module"), Messages.getString("Namespace"), Messages.getString("CallHierarchy")};
    }
}

