/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import oracle.dbtools.parser.plsql.IdentifierDefinitionLookup;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.RaptorDnDPlugin;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.OracleNavigatorResource;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.plsql.PLSQLAddin;
import oracle.dbtools.raptor.plsql.PLSQLController;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchField;

public class PLSQLEditorToolbar
implements EditorPlugin,
Controller,
Observer {
    private ToggleToolButton pinToggle;
    private ToggleToolButton roToggle;
    private ToolButton gotoSpecButton;
    private ToolButton gotoBodyButton;
    private IdeAction pinAction;
    private IdeAction roAction;
    private IdeAction gotoSpecAction;
    private IdeAction gotoBodyAction;
    static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"VE_Pin_Editor");
    static final int RO_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"RO_Pin_Editor");
    static final int GOTO_SPEC_CMD_ID = Ide.findOrCreateCmdID((String)"GOTO_SPEC");
    static final int GOTO_BODY_CMD_ID = Ide.findOrCreateCmdID((String)"GOTO_BODY");
    private CodeEditor parent;
    private Toolbar toolbar;
    private List<IdeAction> actions = new LinkedList<IdeAction>();
    public static final String ACCEL_FILE = "oracle/dbtools/raptor/plsql/accelerators.xml";

    public PLSQLEditorToolbar() {
        PLSQLController.getInstance();
    }

    public void install(BasicEditorPane basicEditorPane) {
        Object object;
        this.parent = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        this.toolbar = this.parent.getToolbar();
        basicEditorPane.installPlugin((EditorPlugin)new RaptorDnDPlugin());
        Node node = this.parent.getContext().getNode();
        this.addPinAction(this.parent, this.toolbar);
        if (DBURLFormatHelper.isDBURL(node.getURL())) {
            this.addROAction(this.parent, this.toolbar);
        }
        this.addRunActions(this.parent, this.toolbar, node);
        this.addCompileActions(this.parent, this.toolbar, node);
        if (node instanceof PlSqlNode) {
            object = (PlSqlNode)node;
            ((PlSqlNode)object).addListener(this);
            this.addGoToActions(this.parent, this.toolbar, (PlSqlNode)object);
        }
        object = new DBConnectionComboBox();
        for (Component component : this.toolbar.getComponents()) {
            if (!(component instanceof SearchField)) continue;
            component.setMinimumSize(new Dimension(225, component.getHeight()));
            component.setPreferredSize(new Dimension(225, component.getHeight()));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add((Component)((DBConnectionComboBox)object).getJComboBox());
        final PlSqlNode plSqlNode = (PlSqlNode)node;
        String string = null;
        if (DBURLFormatHelper.isDBURL(node.getURL())) {
            string = plSqlNode.getConnectionName();
        }
        if (string != null) {
            ((DBConnectionComboBox)object).setCurrentConnection(string);
        }
        ItemListener itemListener = new ItemListener((DBConnectionComboBox)object){
            private String m_currConn;
            final /* synthetic */ DBConnectionComboBox val$dbSelector;
            {
                this.val$dbSelector = dBConnectionComboBox;
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        String string = (String)itemEvent.getItem();
                        try {
                            Connections.getInstance().getConnection(string);
                            this.m_currConn = string;
                            plSqlNode.setConnectionName(string);
                        }
                        catch (DBException dBException) {
                            Throwable throwable = dBException.getCause();
                            if (!(throwable instanceof ConnectionCanceledException) && throwable instanceof Exception) {
                                ExceptionHandler.handleException((Throwable)((Exception)throwable));
                            }
                            this.val$dbSelector.setCurrentConnection(this.m_currConn);
                        }
                        View.updateToolbarActions((Toolbar)PLSQLEditorToolbar.this.toolbar);
                        break;
                    }
                }
            }
        };
        if (DBURLFormatHelper.isDBURL(node.getURL())) {
            ((DBConnectionComboBox)object).getJComboBox().setEnabled(false);
            ((DBConnectionComboBox)object).getJComboBox().setFocusable(false);
        } else {
            ((DBConnectionComboBox)object).getJComboBox().addItemListener(itemListener);
        }
        View.updateToolbarActions((Toolbar)this.toolbar);
    }

    private void addPinAction(CodeEditor codeEditor, Toolbar toolbar) {
        this.pinAction = IdeAction.get((int)PIN_EDITOR_CMD_ID, null, (String)IdeArb.getString((int)28), null, null, (Icon)OracleIcons.getIcon((String)"pin.png"), null, (boolean)true).newLocalAction((View)codeEditor);
        this.pinAction.addController((Controller)this);
        this.pinToggle = new ToggleToolButton((ToggleAction)this.pinAction);
        toolbar.add((Component)this.pinToggle, 0);
        Node node = codeEditor.getContext().getNode();
        boolean bl = PLSQLAddin.pinned.contains(node);
        this.pinAction.setState(bl);
        if (!bl) {
            this.pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
        } else {
            this.pinToggle.setIcon(RaptorImagesArb.getIcon("PINNED"));
        }
    }

    private void addROAction(CodeEditor codeEditor, Toolbar toolbar) {
        this.roAction = IdeAction.get((int)RO_EDITOR_CMD_ID, null, (String)Messages.getString("PLSQLEditorToolbar.switchWrite"), null, null, null, null, (boolean)true).newLocalAction((View)codeEditor);
        this.roAction.addController((Controller)this);
        this.roToggle = new ToggleToolButton((ToggleAction)this.roAction);
        toolbar.add((Component)this.roToggle, 1);
        PlSqlNode plSqlNode = (PlSqlNode)codeEditor.getContext().getNode();
        boolean bl = PLSQLAddin.pinned.contains(plSqlNode);
        this.roAction.setState(bl);
        this.toggleROIcon(plSqlNode);
    }

    private void addCompileActions(CodeEditor codeEditor, Toolbar toolbar, Node node) {
        IdeAction[] ideActionArray;
        String string;
        if (DBURLFormatHelper.isDBURL(node.getURL()) && ((string = (ideActionArray = new DBObject((Element)node)).getObjectType()) == null || "XML SCHEMA".equals(string))) {
            return;
        }
        ideActionArray = new IdeAction[]{this.createLocalAction((View)codeEditor, CompileArb.getIcon("COMPILECODEBUG_ICON"), Messages.getString("CompileForDebug"), PLSQLController.COMPILE_DEBUG_COMMAND), this.createLocalAction((View)codeEditor, CompileArb.getIcon("COMPILECODE_ICON"), Messages.getString("Compile"), PLSQLController.COMPILE_COMMAND)};
        string = this.createLocalAction((View)codeEditor, CompileArb.getIcon("MAKE_ICON"), Messages.getString("Make"), PLSQLController.MAKE_COMMAND);
        ActionMenuToolButton actionMenuToolButton = new ActionMenuToolButton((Action)((Object)string));
        actionMenuToolButton.setMenuActions((Action[])ideActionArray);
        int n = this.searchFieldIndex(toolbar);
        toolbar.add((Component)actionMenuToolButton, n++);
    }

    private void addRunActions(CodeEditor codeEditor, Toolbar toolbar, Node node) {
        DBObject dBObject = new DBObject((Element)node);
        String string = dBObject.getObjectType();
        if (DBURLFormatHelper.isDBURL(node.getURL())) {
            if (string == null || "XML SCHEMA".equals(string)) {
                return;
            }
            if ("TRIGGER".equals(string) || string.startsWith("TYPE")) {
                return;
            }
        }
        int n = this.searchFieldIndex(toolbar);
        ToolButton toolButton = new ToolButton((Action)this.createLocalAction((View)codeEditor, PLSQLController.RUN_COMMAND));
        toolbar.add((Component)toolButton, n++);
        toolButton = new ToolButton((Action)this.createLocalAction((View)codeEditor, OracleIcons.getIcon((String)"debug.png"), Messages.getString("Debug"), PLSQLController.DEBUG_COMMAND));
        toolbar.add((Component)toolButton, n++);
    }

    private void addGoToActions(CodeEditor codeEditor, Toolbar toolbar, PlSqlNode plSqlNode) {
        DBObject dBObject = new DBObject(plSqlNode);
        String string = dBObject.getObjectType();
        if (DBURLFormatHelper.isDBURL(plSqlNode.getURL())) {
            if ("PACKAGE BODY".equals(string)) {
                this.gotoSpecAction = IdeAction.get((int)GOTO_SPEC_CMD_ID, null, (String)Messages.getString("GOTO.spec"), null, null, (Icon)OracleNavigatorResource.getIcon("PACKAGE_ICON"), null, (boolean)true).newLocalAction((View)codeEditor);
                this.gotoSpecAction.addController((Controller)this);
                this.gotoSpecButton = new ToolButton((Action)this.gotoSpecAction);
                int n = this.searchFieldIndex(toolbar);
                toolbar.add((Component)this.gotoSpecButton, n++);
            } else if ("PACKAGE".equals(string)) {
                this.gotoBodyAction = IdeAction.get((int)GOTO_BODY_CMD_ID, null, (String)Messages.getString("GOTO.body"), null, null, (Icon)OracleNavigatorResource.getIcon("PACKAGE_ICON"), null, (boolean)true).newLocalAction((View)codeEditor);
                this.gotoBodyAction.addController((Controller)this);
                this.gotoBodyButton = new ToolButton((Action)this.gotoBodyAction);
                this.gotoBodyButton.setEnabled(plSqlNode.hasBody());
                int n = this.searchFieldIndex(toolbar);
                toolbar.add((Component)this.gotoBodyButton, n++);
            }
        }
    }

    private int searchFieldIndex(Toolbar toolbar) {
        int n = toolbar.getComponentCount() - 1;
        for (int i = 0; i < toolbar.getComponentCount(); ++i) {
            Component component = toolbar.getComponent(i);
            if (!(component instanceof SearchField)) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        Node node = this.parent.getContext().getNode();
        if (node instanceof PlSqlNode) {
            ((PlSqlNode)node).removeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private IdeAction createLocalAction(View view, Icon icon, String string, int n) {
        IdeAction ideAction = this.createLocalAction(view, n);
        ideAction.putValue("SmallIcon", (Object)icon);
        ideAction.putValue("ShortDescription", (Object)string);
        this.setupAcceleratorToolTip(ideAction, n);
        this.actions.add(ideAction);
        return ideAction;
    }

    private IdeAction createLocalAction(View view, int n) {
        IdeAction ideAction = IdeAction.newLocalAction((int)n, (View)view);
        this.setupAcceleratorToolTip(ideAction, n);
        ideAction.setEnabled(false);
        return ideAction;
    }

    private void setupAcceleratorToolTip(IdeAction ideAction, int n) {
        try {
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
            KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(keyStrokeContextRegistry.getContext(ACCEL_FILE));
            if (keyStrokeMap == null) {
                return;
            }
            List list = keyStrokeMap.getKeyStrokesFor(n);
            if (list != null && list.size() > 0) {
                KeyStrokes keyStrokes = (KeyStrokes)list.get(0);
                StringBuffer stringBuffer = new StringBuffer(20);
                stringBuffer.append(" (");
                for (int i = 0; i < keyStrokes.getLength(); ++i) {
                    KeyStroke keyStroke = keyStrokes.getKeyStroke(i);
                    if (keyStroke == null) continue;
                    String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(string);
                        stringBuffer.append("+");
                    }
                    stringBuffer.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
                }
                stringBuffer.append(")");
                ideAction.putValueDirectly("last-tooltip-suffix", (Object)stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in setupAcceleratorToolTip():" + exception.getMessage());
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PIN_EDITOR_CMD_ID) {
            Node node = context.getNode();
            boolean bl = PLSQLAddin.pinned.contains(node);
            if (!bl) {
                this.pinToggle.setIcon(RaptorImagesArb.getIcon("PINNED"));
                PLSQLAddin.pinned.add(node);
            } else {
                this.pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
                PLSQLAddin.pinned.remove(node);
            }
            View.updateToolbarActions((Toolbar)this.toolbar);
            return true;
        }
        if (n == RO_EDITOR_CMD_ID) {
            PlSqlNode plSqlNode = (PlSqlNode)context.getNode();
            plSqlNode.toggleReadOnly();
            this.toggleROIcon(plSqlNode);
            View.updateToolbarActions((Toolbar)this.toolbar);
            return true;
        }
        if (n == GOTO_SPEC_CMD_ID) {
            PlSqlNode plSqlNode = (PlSqlNode)context.getNode();
            IdentifierDefinitionLookup.goTo(DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", plSqlNode.getConnectionName(), null, plSqlNode.getOwner(), "PACKAGE"), plSqlNode.getObjectName()), false);
        } else if (n == GOTO_BODY_CMD_ID) {
            PlSqlNode plSqlNode = (PlSqlNode)context.getNode();
            IdentifierDefinitionLookup.goTo(DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", plSqlNode.getConnectionName(), null, plSqlNode.getOwner(), "PACKAGE BODY"), plSqlNode.getObjectName()), false);
        }
        return false;
    }

    private void toggleROIcon(PlSqlNode plSqlNode) {
        BasicEditorPane basicEditorPane = this.parent.getFocusedEditorPane();
        basicEditorPane.setEditable(!plSqlNode.isReadOnly());
        if (plSqlNode.isReadOnly() || "BLOCK".equals(plSqlNode.getObjectType())) {
            this.roToggle.setIcon(RaptorImagesArb.getIcon("EDIT_CODE_BROKEN"));
            this.roToggle.setToolTipText(Messages.getString("PLSQLEditorToolbar.switchWrite"));
        } else {
            this.roToggle.setIcon(RaptorImagesArb.getIcon("EDIT_CODE_WRITE"));
            this.roToggle.setToolTipText(Messages.getString("PLSQLEditorToolbar.switchReadOnly"));
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        Node node = context.getNode();
        if (node instanceof PlSqlNode) {
            PLSQLController.updateAction(ideAction, (PlSqlNode)node);
        }
        return true;
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (object instanceof PlSqlNode) {
            for (Component component : this.toolbar.getComponents()) {
                AbstractButton abstractButton;
                Action action;
                if (!(component instanceof AbstractButton) || !((action = (abstractButton = (AbstractButton)component).getAction()) instanceof IdeAction)) continue;
                IdeAction ideAction = (IdeAction)action;
                PLSQLController.updateAction(ideAction, (PlSqlNode)object);
            }
        }
    }
}

