/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.runner.DBStarterFactory;
import oracle.dbtools.raptor.runner.PlSqlRunnerPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.View;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.run.JRunner;

public class PLSQLController
implements Controller {
    static Logger LOGGER = Logger.getLogger(PLSQLController.class.getName());
    private static final Object LOCK = new Object();
    private static PLSQLController _controller;
    public static final int COMPILE_COMMAND;
    public static final int COMPILE_DEBUG_COMMAND;
    public static final int MAKE_COMMAND;
    public static final int RUN_COMMAND;
    public static final int DEBUG_COMMAND;
    int tmpDebug = 0;
    private String selection = null;
    List<LexerToken> fragment;
    Matrix matrix;
    ParseNode selRoot;

    private PLSQLController() {
        this.createActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PLSQLController getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_controller == null) {
                _controller = new PLSQLController();
            }
        }
        return _controller;
    }

    private void createActions() {
        this.createAction(MAKE_COMMAND, Messages.getString("Make"));
        this.createAction(COMPILE_DEBUG_COMMAND, Messages.getString("CompileForDebug"));
        this.createAction(COMPILE_COMMAND, Messages.getString("Compile"));
        this.createAction(RUN_COMMAND, Messages.getString("Run"));
        this.createAction(DEBUG_COMMAND, Messages.getString("Debug"));
    }

    private void createAction(int n, String string) {
        IdeAction ideAction = IdeAction.get((int)n, (String)StringUtils.stripMnemonic((String)string), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)));
        ideAction.addController((Controller)this);
    }

    public boolean update(IdeAction ideAction, Context context) {
        Node node = context.getNode();
        if (node instanceof PlSqlNode) {
            PLSQLController.updateAction(ideAction, (PlSqlNode)node);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(IdeAction ideAction, final Context context) {
        boolean bl = false;
        final int n = ideAction.getCommandId();
        if (n == MAKE_COMMAND || n == COMPILE_DEBUG_COMMAND || n == COMPILE_COMMAND) {
            Node node = context.getNode();
            if (node instanceof PlSqlNode) {
                PlSqlNode plSqlNode = (PlSqlNode)node;
                WaitCursor waitCursor = Ide.getWaitCursor();
                waitCursor.show();
                try {
                    plSqlNode.ensureOpen();
                    plSqlNode.markDirty(true);
                    plSqlNode.invokedFromToolbar = true;
                    String string = plSqlNode.getConnectionName();
                    if (string == null) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("PLSQLController.noConnectionMsg"), (String)Messages.getString("PLSQLController.noConnectionTitle"), null);
                        boolean bl2 = true;
                        return bl2;
                    }
                    if (n == COMPILE_DEBUG_COMMAND) {
                        this.setDebug(true, string);
                    } else if (n == COMPILE_COMMAND) {
                        this.setDebug(false, string);
                    } else {
                        this.setDebug(null, string);
                    }
                    plSqlNode.save();
                    this.restoreDebug(string);
                    Ide.getStatusBar().setText(Messages.getString("PLSQLController.0"));
                }
                catch (IOException iOException) {
                    Ide.getStatusBar().setText(Messages.getString("PLSQLController.2") + iOException.getMessage());
                }
                finally {
                    waitCursor.hide();
                }
                bl = true;
            }
        } else if (n == RUN_COMMAND || n == DEBUG_COMMAND) {
            final Node node = context.getNode();
            SwingWorker swingWorker = new SwingWorker(){
                PlSqlRunnerPanel panel = null;

                public Object construct() {
                    if (node instanceof PlSqlNode) {
                        this.panel = n == DEBUG_COMMAND ? new PlSqlRunnerPanel.PlSqlDebuggerPanel((PlSqlNode)node) : new PlSqlRunnerPanel((PlSqlNode)node);
                        return this.panel.runDialog();
                    }
                    return null;
                }

                public void finished() {
                    RunConfiguration runConfiguration;
                    if (this.panel != null) {
                        this.panel.m_txtBlock.dispose();
                    }
                    if ((DBStarterFactory.PlSqlStarter.dialogOutput = (TextBuffer)this.getValue()) == null && node instanceof PlSqlNode) {
                        return;
                    }
                    Project project = context.getProject();
                    if (project != null && (runConfiguration = RunConfigurations.getRunConfigurationByName((Project)project, (String)RunConfiguration.getDefaultName())) != null) {
                        context.setProperty("RunContext.RUN_CONFIGURATION", (Object)runConfiguration);
                    }
                    if (n == RUN_COMMAND) {
                        runConfiguration = IdeAction.get((int)Ide.findOrCreateCmdID((String)"RunSelectionCommand"));
                        if (runConfiguration != null) {
                            runConfiguration.updateAction(context);
                            if (runConfiguration.isEnabled()) {
                                try {
                                    runConfiguration.performAction(context);
                                }
                                catch (Exception exception) {
                                    LOGGER.severe(exception.getLocalizedMessage());
                                }
                            }
                        }
                        return;
                    }
                    runConfiguration = JRunner.prepareProcessContext((Context)context, (boolean)false);
                    DebuggingProcess debuggingProcess = new DebuggingProcess((Context)runConfiguration);
                    RunConfiguration runConfiguration2 = debuggingProcess.getRunConfiguration();
                    boolean bl = DBURLFormatHelper.isDBURL(node.getURL());
                    if (!bl) {
                        runConfiguration2.setCompileBeforeRun(false);
                        if (node instanceof PlSqlNode) {
                            runConfiguration2.setTargetURL(((PlSqlNode)node).matchingDbUrl());
                        } else {
                            try {
                                runConfiguration2.setTargetURL(new URL("http://potato.com"));
                                Class<RunProcess> clazz = RunProcess.class;
                                Field field = clazz.getDeclaredField("starter");
                                field.setAccessible(true);
                                View view = context.getView();
                                String string = ((DbEditor)view).getConnectionName();
                                field.set(debuggingProcess, (Object)new DBStarterFactory.PlSqlStarter((JRunProcess)debuggingProcess, PLSQLController.this.selection, string, context));
                            }
                            catch (Exception exception) {
                                System.err.println(exception);
                            }
                        }
                    } else {
                        runConfiguration2.setTargetURL(node.getURL());
                    }
                    debuggingProcess.start();
                }
            };
            swingWorker.start();
            bl = true;
        }
        return bl;
    }

    private void restoreDebug(String string) {
        DBConfig.getInstance().putInt("PLSQLOPTIMLEVEL", this.tmpDebug);
        Connections connections = Connections.getInstance();
        DBConfig dBConfig = DBConfig.getInstance();
        try {
            int n = Connections.getInstance().getConnection(string).getMetaData().getDatabaseMajorVersion();
            if (n >= 10) {
                DBUtil.getInstance((String)string).execute("alter session set PLSQL_OPTIMIZE_LEVEL=" + dBConfig.getString("PLSQLOPTIMLEVEL"), Collections.emptyList());
            }
        }
        catch (SQLException sQLException) {
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (!connections.isTimesTen(string)) {
            DBUtil.getInstance((String)string).execute("alter session set PLSQL_DEBUG=" + (2 != dBConfig.getInt("PLSQLOPTIMLEVEL") ? "true" : "false"), Collections.emptyList());
        }
    }

    private void setDebug(Boolean bl, String string) {
        this.tmpDebug = DBConfig.getInstance().getInt("PLSQLOPTIMLEVEL");
        int n = bl == null ? this.tmpDebug : (bl != false ? 1 : 2);
        DBConfig.getInstance().putInt("PLSQLOPTIMLEVEL", n);
        Connections connections = Connections.getInstance();
        try {
            int n2 = Connections.getInstance().getConnection(string).getMetaData().getDatabaseMajorVersion();
            if (n2 >= 10) {
                DBUtil.getInstance((String)string).execute("alter session set PLSQL_OPTIMIZE_LEVEL=" + n, Collections.emptyList());
            }
        }
        catch (SQLException sQLException) {
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (!connections.isTimesTen(string) && bl != null) {
            DBUtil.getInstance((String)string).execute("alter session set PLSQL_DEBUG=" + bl, Collections.emptyList());
        }
    }

    public static boolean updateAction(IdeAction ideAction, PlSqlNode plSqlNode) {
        ideAction.setEnabled(true);
        boolean bl = plSqlNode.getConnectionName() != null;
        Debugger debugger = Debugger.getDebugger();
        if (debugger.isDebugging() || !bl) {
            ideAction.setEnabled(false);
        }
        if ((DBURLFormatHelper.isDBURL(plSqlNode.getURL()) && Boolean.valueOf((String)plSqlNode.getProperty("INVALID")) != false || plSqlNode.getObjectType() != null && plSqlNode.getObjectType().endsWith("TRIGGER") || "TRIGGER".equals(plSqlNode.getType())) && (ideAction.getCommandId() == RUN_COMMAND || ideAction.getCommandId() == DEBUG_COMMAND)) {
            ideAction.setEnabled(false);
        }
        if ("BLOCK".equals(plSqlNode.getObjectType())) {
            ideAction.setEnabled(false);
        }
        return true;
    }

    void updateAction(IdeAction ideAction, Context context) {
        ideAction.setEnabled(false);
        View view = context.getView();
        BasicEditorPane basicEditorPane = ((FindableEditor)view).getFocusedEditorPane();
        String string = ((DbEditor)view).getConnectionName();
        Debugger debugger = Debugger.getDebugger();
        if (basicEditorPane.getLineCount() > 1000 || string == null || debugger.isDebugging()) {
            return;
        }
        int n = basicEditorPane.getCaretPosition();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        String string2 = this.extractText(basicDocument.getTextBuffer());
        List list = LexerToken.parse((String)string2);
        LazyNode lazyNode = StackParser.parse((List)list);
        LazyNode lazyNode2 = null;
        if ("declare".equalsIgnoreCase(lazyNode.startToken) || "begin".equalsIgnoreCase(lazyNode.startToken)) {
            lazyNode2 = lazyNode;
        } else {
            for (ParseNode parseNode : lazyNode.children()) {
                if (((LexerToken)list.get((int)parseNode.from)).begin > n || n >= ((LexerToken)list.get((int)(parseNode.to - 1))).end) continue;
                lazyNode2 = (LazyNode)parseNode;
                if ("declare".equalsIgnoreCase(lazyNode2.startToken) || "begin".equalsIgnoreCase(lazyNode2.startToken)) break;
                return;
            }
            if (lazyNode2 == null) {
                return;
            }
        }
        this.selection = string2.substring(((LexerToken)list.get((int)lazyNode2.from)).begin, ((LexerToken)list.get((int)(lazyNode2.to - 1))).end);
        if (!this.selection.endsWith(";")) {
            this.selection = this.selection + ";";
        }
        if (!this.parse(this.selection)) {
            return;
        }
        ideAction.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractText(TextBuffer textBuffer) {
        String string = "";
        try {
            if (!textBuffer.tryReadLock()) {
                String string2 = string;
                return string2;
            }
            if (textBuffer.getLength() > 50000) {
                Logger.getLogger(this.getClass().getName()).warning("Source too big");
                String string3 = string;
                return string3;
            }
            string = textBuffer.getString(0, textBuffer.getLength());
            if (string != null) return string;
            String string4 = "";
            return string4;
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            return string;
        }
        finally {
            try {
                textBuffer.readUnlock();
            }
            catch (Throwable throwable) {}
        }
    }

    private boolean parse(String string) {
        this.fragment = LexerToken.parse((String)string);
        SqlEarley sqlEarley = SqlEarley.getInstance();
        Matrix matrix = new Matrix((Parser)sqlEarley);
        sqlEarley.parse(this.fragment, matrix);
        if (!matrix.contains(0, this.fragment.size(), IdentifiersDb.instance.block_stmt)) {
            return false;
        }
        this.selRoot = sqlEarley.forest(this.fragment, matrix);
        return true;
    }

    static {
        COMPILE_COMMAND = Ide.findOrCreateCmdID((String)"PlSqlController.Compile");
        COMPILE_DEBUG_COMMAND = Ide.findOrCreateCmdID((String)"PlSqlController.CompileDebug");
        MAKE_COMMAND = Ide.findOrCreateCmdID((String)"PlSqlController.Make");
        RUN_COMMAND = Ide.findOrCreateCmdID((String)"PlSqlController.Run");
        DEBUG_COMMAND = Ide.findOrCreateCmdID((String)"PlSqlController.Debug");
    }
}

