/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import java.lang.reflect.Field;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.PLSQLController;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.model.SqlNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareIdeViewer;

public class PLSQLContextMenu
implements ContextMenuListener {
    private MenuFilter m_filter = new MenuFilter(){

        public boolean accept(Component component) {
            IdeAction ideAction;
            int n;
            Action action;
            return !(component instanceof JMenuItem) || !((action = ((JMenuItem)component).getAction()) instanceof IdeAction) || (n = (ideAction = (IdeAction)action).getCommandId()) != Ide.findCmdID((String)"RunSelectionCommand") && n != Ide.findOrCreateCmdID((String)"ContextMenuDebug");
        }
    };

    public void menuWillShow(ContextMenu contextMenu) {
        IdeAction ideAction;
        Context context = contextMenu.getContext();
        Node node = context.getNode();
        if (node == null) {
            return;
        }
        if (!(node instanceof PlSqlNode) && !(node instanceof SqlNode)) {
            return;
        }
        View view = context.getView();
        if (!(node instanceof PlSqlNode) && !(view instanceof DbEditor)) {
            return;
        }
        this.maybeAddMenuFilter(contextMenu, node);
        String string = node.getShortLabel();
        if (string != null && string.toLowerCase().startsWith("anon_block")) {
            return;
        }
        IdeAction ideAction2 = context.getSelection();
        if (ideAction2 != null && (((Element[])ideAction2).length == 1 || ((Element[])ideAction2).length == 2)) {
            CompareAddin compareAddin;
            IdeAction ideAction3;
            boolean bl = true;
            ideAction = ideAction2;
            int n = ((Element[])ideAction).length;
            for (int i = 0; i < n; ++i) {
                ideAction3 = ideAction[i];
                if (ideAction3 instanceof PlSqlNode) continue;
                bl = false;
            }
            if (bl && (compareAddin = (CompareAddin)(ideAction = AddinManager.getAddinManager()).getAddin(CompareAddin.class)) != null) {
                try {
                    Field field = CompareAddin.class.getDeclaredField("m_compareIdeViewer");
                    field.setAccessible(true);
                    ideAction3 = (CompareIdeViewer)field.get((Object)compareAddin);
                    contextMenu.add((Component)ideAction3.getContextCompareMenu());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!(node instanceof PlSqlNode) && !(node instanceof SqlNode)) {
            return;
        }
        URL uRL = node.getURL();
        if (uRL.toString().toLowerCase().startsWith("sqldev.migration")) {
            return;
        }
        if (node instanceof SqlNode) {
            ideAction = IdeAction.find((int)PLSQLController.DEBUG_COMMAND);
            if (ideAction != null) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                PLSQLController.getInstance().updateAction(ideAction, context);
            }
            return;
        }
        this.addAndUpdateMenuItem(contextMenu, (PlSqlNode)node, PLSQLController.DEBUG_COMMAND);
        this.addAndUpdateMenuItem(contextMenu, (PlSqlNode)node, PLSQLController.COMPILE_COMMAND);
        this.addAndUpdateMenuItem(contextMenu, (PlSqlNode)node, PLSQLController.COMPILE_DEBUG_COMMAND);
        this.addAndUpdateMenuItem(contextMenu, (PlSqlNode)node, PLSQLController.RUN_COMMAND);
    }

    public void menuWillHide(ContextMenu contextMenu) {
        contextMenu.removeMenuFilter(this.m_filter);
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void addAndUpdateMenuItem(ContextMenu contextMenu, PlSqlNode plSqlNode, int n) {
        IdeAction ideAction = IdeAction.find((int)n);
        if (ideAction != null) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
            PLSQLController.updateAction(ideAction, plSqlNode);
        }
    }

    private void maybeAddMenuFilter(ContextMenu contextMenu, Node node) {
        if (node instanceof PlSqlNode || node instanceof SqlNode) {
            contextMenu.addMenuFilter(this.m_filter);
        }
    }
}

