/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import oracle.dbtools.raptor.DBDevExtensionResource;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.display.AbstractDisplayModelParser;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.plsql.PLSQLStatusDisplay;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.newscriptrunner.PLSQL;
import oracle.dbtools.raptor.plsql.ExternalUpdateTracker;
import oracle.dbtools.raptor.plsql.InfoPanel;
import oracle.dbtools.raptor.plsql.PLSQLDependencies;
import oracle.dbtools.raptor.plsql.PLSQLDetails;
import oracle.dbtools.raptor.plsql.PLSQLErrors;
import oracle.dbtools.raptor.plsql.PLSQLFactory;
import oracle.dbtools.raptor.plsql.PLSQLGrants;
import oracle.dbtools.raptor.plsql.PLSQLProfiles;
import oracle.dbtools.raptor.plsql.PLSQLReferences;
import oracle.dbtools.raptor.plsql.folding.PlSqlFoldingPlugin;
import oracle.dbtools.raptor.plsql.language.PLSQLLanguageModule;
import oracle.dbtools.raptor.plsql.structure.OutlineMenu;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;
import oracle.dbtools.raptor.runner.DBStarterFactory;
import oracle.dbtools.raptor.runner.SmartPlsql;
import oracle.dbtools.raptor.runner.ToolTipPlsql;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.DeployableTextNode;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Recognizer;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.Runner;
import oracle.ide.runner.SmartDataProvider;
import oracle.ide.runner.StarterFactory;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.ide.util.MenuSpec;
import oracle.ideri.util.Product;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdevimpl.debugger.jdi.DBJDIFileSystemHelperFactory;
import oracle.jdevimpl.debugger.probe.RaptorDebugProbeConnector;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.runner.debug.RaptorDebuggingHelper;

public class PLSQLAddin
implements Addin {
    private static final String ACCELERATOR_FILE = "oracle/dbtools/raptor/plsql/accelerators.xml";
    private Map<String, Integer> editorNums = new HashMap<String, Integer>();
    static LinkedList<Node> pinned = new LinkedList();
    public Map<Node, ReadTextBuffer> pinnedBuffers = new TreeMap<Node, ReadTextBuffer>();

    public void initialize() {
        Recognizer.registerConversion(PlSqlNode.class, SqlNode.class);
        Recognizer.registerConversion(PlSqlNode.class, DeployableTextNode.class);
        DocumentInfo documentInfo = new DocumentInfo("PL/SQL");
        Recognizer.registerDocumentInfo(PlSqlNode.class, (DocumentInfo)documentInfo);
        DBStarterFactory dBStarterFactory = new DBStarterFactory();
        Runner.getRunner().registerStarterFactory(RunnableSourceNode.class, (StarterFactory)dBStarterFactory);
        DebugFactory.registerDebugConnector((int)2, RaptorDebugProbeConnector.class, (String)RaptorDebugProbeConnector.getVersion());
        DBJDIFileSystemHelperFactory.initialize();
        RaptorDebuggingHelper.initialize();
        Debugger debugger = Debugger.getDebugger();
        if (debugger != null) {
            debugger.addSmartDataProvider((SmartDataProvider)new SmartPlsql());
            debugger.addToolTipExpressionProvider((ToolTipExpressionProvider)new ToolTipPlsql());
        }
        CodeEditor.registerFactory((EditorPluginsFactory)new PLSQLFactory());
        CodeEditor.registerFactory((EditorPluginsFactory)new EditorPluginsFactory(){

            public List<?> createPlugins(Context context) {
                Node node = context.getNode();
                return node instanceof PlSqlNode ? Arrays.asList(new EditorPlugin[]{new PlSqlFoldingPlugin((PlSqlNode)node), ((PlSqlNode)node).getParser()}) : Collections.emptyList();
            }
        });
        OutlineMenu.init();
        Recognizer.mapExtensionToClass((String)".klr", PlSqlNode.class);
        Recognizer.mapExtensionToClass((String)".pls", PlSqlNode.class);
        Recognizer.mapExtensionToClass((String)".plb", PlSqlNode.class);
        Recognizer.mapExtensionToClass((String)".pkb", PlSqlNode.class);
        Recognizer.mapExtensionToClass((String)".pls", PlSqlNode.class);
        Recognizer.mapExtensionToClass((String)".pks", PlSqlNode.class);
        Recognizer.mapExtensionToClass((String)".pkh", PlSqlNode.class);
        new PLSQLLanguageModule();
        this.addPlSqlEditorListener();
        this.addPlSqlNodeListener();
        PLSQL.display = new PLSQLStatusDisplay();
        PLSQLAddin.registerEditor(DBDevExtensionResource.getString("GRANTS_EDITOR_LABEL"), PLSQLGrants.class, null, 9, -0.1f);
        PLSQLAddin.registerEditor(DBDevExtensionResource.getString("DEPENDENCIES_EDITOR_LABEL"), PLSQLDependencies.class, null, 9, -0.2f);
        PLSQLAddin.registerEditor(DBDevExtensionResource.getString("REFERENCES_EDITOR_LABEL"), PLSQLReferences.class, null, 9, -0.3f);
        PLSQLAddin.registerEditor(DBDevExtensionResource.getString("ERRORS_EDITOR_LABEL"), PLSQLErrors.class, null, 9, -0.4f);
        PLSQLAddin.registerEditor(DBDevExtensionResource.getString("DETAILS_EDITOR_LABEL"), PLSQLDetails.class, null, 9, -0.5f);
        PLSQLAddin.registerEditor(DBDevExtensionResource.getString("PROFILES_EDITOR_LABEL"), PLSQLProfiles.class, null, 11, -0.6f);
        this.customEditors();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), ACCELERATOR_FILE);
        Node.addNodeListenerForTypeHierarchy(DatabaseSourceNode.class, (NodeListener)new ExternalUpdateTracker());
        if (Product.isRaptor()) {
            try {
                new JLibraryManager();
            }
            catch (SingletonClassException singletonClassException) {
                // empty catch block
            }
        }
    }

    private void customEditors() {
        XMLParser xMLParser = new XMLParser();
        List<String> list = DBConfig.getInstance().getExtensions("EDITOR");
        if (list != null) {
            for (String string : list) {
                try {
                    xMLParser.processXML(new FileInputStream(new File(string)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static void registerEditor(final String string, final Class<? extends Editor> clazz, final String string2, final int n, final float f) {
        EditorAddin editorAddin = new EditorAddin(){

            public Class<? extends Editor> getEditorClass() {
                return clazz;
            }

            public MenuSpec getMenuSpecification() {
                return new MenuSpec(string, null);
            }

            public boolean isDefault() {
                return (double)f > 0.99;
            }

            public float getEditorWeight(Element element) {
                if (element instanceof PlSqlNode) {
                    PlSqlNode plSqlNode = (PlSqlNode)element;
                    String string4 = plSqlNode.getObjectType();
                    if (string4 != null && "BLOCK".equals(string4)) {
                        return Float.NaN;
                    }
                    if (string2 != null && string4 != null && !string4.equalsIgnoreCase(string2)) {
                        return Float.NaN;
                    }
                    if (plSqlNode.getURL().toString().startsWith("sqldev.migration")) {
                        return Float.NaN;
                    }
                    String string22 = plSqlNode.getConnectionName();
                    if (Connections.getInstance().isOracle(string22)) {
                        try {
                            Connection connection = Connections.getInstance().getConnection(string22);
                            Properties properties = Connections.getInstance().getConnectionInfo(string22);
                            if (properties == null) {
                                return Float.NaN;
                            }
                            String string3 = properties.getProperty("driver");
                            if ((0.99 < (double)f || "oracle.jdbc.OracleDriver".equals(string3)) && connection.getMetaData().getDatabaseMajorVersion() >= n) {
                                return f;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                return Float.NaN;
            }
        };
        EditorManager.getEditorManager().registerDynamic(editorAddin);
    }

    protected void addPlSqlEditorListener() {
        EditorManager.getEditorManager().addEditorListener(new EditorListener(){

            public void editorActivated(Editor editor) {
                OutlineWindow.getInstance().refresh(editor);
            }

            public void editorClosed(Editor editor) {
                pinned.remove(editor);
            }

            public void editorDeactivated(Editor editor) {
            }

            public void editorOpened(Editor editor) {
                if (editor instanceof InfoPanel || editor instanceof CodeEditor) {
                    PLSQLAddin.closeUnpinnedEditors(editor);
                }
                OutlineWindow.getInstance().refresh(editor);
            }
        });
    }

    public static void pin(Node node) {
        pinned.add(node);
    }

    public static void unpin(Node node) {
        pinned.remove(node);
    }

    private static void closeUnpinnedEditors(Editor editor) {
        DBConfig dBConfig = DBConfig.getInstance();
        int n = dBConfig.getInt("MAXOPENPLSQLEDITORS");
        PLSQLAddin.truncate(pinned, n);
        EditorManager editorManager = EditorManager.getEditorManager();
        LinkedList<Editor> linkedList = new LinkedList<Editor>();
        Context context = editor.getContext();
        Node node = context != null ? context.getNode() : null;
        for (Object e : editorManager.getAllEditors()) {
            Context context2 = ((Editor)e).getContext();
            Node node2 = context2 != null ? context2.getNode() : null;
            if (!(node2 instanceof PlSqlNode) || node == node2 || pinned.contains(node2) || node2.getURL() == null) continue;
            linkedList.add((Editor)e);
        }
        editorManager.closeEditors(linkedList);
    }

    private static void truncate(LinkedList<Node> linkedList, int n) {
        if (linkedList.size() <= n) {
            return;
        }
        linkedList.removeFirst();
        PLSQLAddin.truncate(linkedList, n);
    }

    protected void addPlSqlNodeListener() {
        Node.addNodeListenerForType(PlSqlNode.class, (NodeListener)new NodeListener(){

            public void nodeOpened(NodeEvent nodeEvent) {
                Node node = nodeEvent.getNode();
                TextBuffer textBuffer = ((PlSqlNode)node).acquireTextBuffer();
                PLSQLAddin.this.pinnedBuffers.put(node, (ReadTextBuffer)textBuffer);
            }

            public void nodeClosed(NodeEvent nodeEvent) {
                Node node = nodeEvent.getNode();
                ((PlSqlNode)node).releaseTextBuffer();
                PLSQLAddin.this.pinnedBuffers.remove(node);
            }
        });
    }

    private final class XMLParser
    extends AbstractDisplayModelParser {
        private XMLParser() {
        }

        @Override
        protected void registerEditor(String string, String string2, DisplayModel displayModel, String string3) {
            if (this.isPlSql(string2)) {
                try {
                    if (PLSQLAddin.this.editorNums.size() > 5) {
                        return;
                    }
                    Integer n = (Integer)PLSQLAddin.this.editorNums.get(displayModel.getName());
                    if (n == null) {
                        n = PLSQLAddin.this.editorNums.size() + 1;
                        PLSQLAddin.this.editorNums.put(displayModel.getName(), n);
                    }
                    Class<?> clazz = Class.forName("oracle.dbtools.raptor.plsql.CustomInfoPanel" + n);
                    Field field = clazz.getDeclaredField("query");
                    field.set(null, displayModel.getQuery().toString());
                    Field field2 = clazz.getDeclaredField("isPivoted");
                    field2.setAccessible(true);
                    field2.setBoolean(null, "true".equalsIgnoreCase(displayModel.getExtAttributes().get("vertical")));
                    PLSQLAddin.registerEditor(displayModel.getName(), clazz, string2, 9, -10.0f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private boolean isPlSql(String string) {
            if (string == null) {
                return true;
            }
            for (String string2 : AbstractDisplayModelParser.getTypesForNode("PlSqlBaseNode")) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }
    }
}

