/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.HarvestDoc;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.phighlight.HighlightAddin;
import oracle.dbtools.raptor.phighlight.HighlightMark;
import oracle.dbtools.raptor.phighlight.TooltipMessage;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.util.SwingWorker;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.plugins.EditorPlugin;

public class HighlightEditorPlugin
implements EditorPlugin,
TooltipMessage,
ParserEventListener {
    private Logger logger = Logger.getLogger(HighlightEditorPlugin.class.getName());
    private BasicEditorPane _editorPane;
    private NodeListener _nodeListener;
    private HighlightLayer _highlightLayer;
    private PlSqlError[] _errors;
    private List<HighlightedText> dynHighlights = new LinkedList<HighlightedText>();
    private Set<Range> ranges = new TreeSet<Range>();

    public HighlightEditorPlugin() {
    }

    public HighlightEditorPlugin(BasicEditorPane basicEditorPane) {
        this._editorPane = basicEditorPane;
    }

    @Override
    public String getToolTipText(int n) {
        if (this._errors != null && 0 < this._errors.length) {
            for (int i = 0; i < this._errors.length; ++i) {
                PlSqlError plSqlError = this._errors[i];
                if (!plSqlError.isInHighlight(n)) continue;
                String[] stringArray = plSqlError._message.split("\n");
                String string = stringArray[0];
                if (stringArray.length > 1) {
                    string = string + "...";
                }
                return string;
            }
        } else {
            for (Range range : this.ranges) {
                if (range.from > n || n >= range.to) continue;
                return range.msg;
            }
        }
        return null;
    }

    public void install(BasicEditorPane basicEditorPane) {
        this._editorPane = basicEditorPane;
        final PlSqlNode plSqlNode = this.getNode();
        if (plSqlNode != null) {
            this._nodeListener = new NodeListener(){

                public void nodeSaved(NodeEvent nodeEvent) {
                    if (plSqlNode.getParser().text == null) {
                        return;
                    }
                    if (DBURLFormatHelper.isDBURL(plSqlNode.getURL())) {
                        HighlightEditorPlugin.this.updateHighlight();
                    }
                }
            };
            plSqlNode.addNodeListener(this._nodeListener);
            this.updateHighlight();
            plSqlNode.getParser().addParserEventListener(this);
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        PlSqlNode plSqlNode = this.getNode();
        plSqlNode.removeNodeListener(this._nodeListener);
        plSqlNode.getParser().removeParserEventListener(this);
        this._highlightLayer = null;
        this._editorPane = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected PlSqlNode getNode() {
        Context context = (Context)this._editorPane.getProperty("editor-ide-context");
        PlSqlNode plSqlNode = null;
        if (context != null) {
            plSqlNode = (PlSqlNode)context.getNode();
        }
        return plSqlNode;
    }

    public HighlightLayer getHighlightLayer() {
        if (this._highlightLayer == null && this._editorPane != null) {
            this._highlightLayer = this._editorPane.createHighlightLayer();
        }
        return this._highlightLayer;
    }

    private void updateHighlight() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                HighlightEditorPlugin.access$202(HighlightEditorPlugin.this, HighlightEditorPlugin.this.getErrors());
                return null;
            }

            public void finished() {
                HighlightLayer highlightLayer = HighlightEditorPlugin.this.getHighlightLayer();
                if (highlightLayer == null) {
                    return;
                }
                highlightLayer.removeAllHighlights();
                HighlightStyle highlightStyle = HighlightAddin.getErrorHighlightStyle();
                HighlightStyle highlightStyle2 = HighlightAddin.getWarningHighlightStyle();
                Context context = (Context)HighlightEditorPlugin.this._editorPane.getProperty("editor-ide-context");
                CodeEditor codeEditor = (CodeEditor)context.getView();
                FileOverviewMargin fileOverviewMargin = codeEditor.getFileOverviewMargin();
                fileOverviewMargin.clearMarks("PLSQLERROR");
                fileOverviewMargin.clearMarks("PLSQLWARNING");
                int n = 0;
                try {
                    n = HighlightEditorPlugin.this._editorPane.getLineCount();
                }
                catch (ExpiredTextBufferException expiredTextBufferException) {
                    return;
                }
                if (n == 0) {
                    return;
                }
                for (int i = 0; i < HighlightEditorPlugin.this._errors.length; ++i) {
                    HighlightStyle highlightStyle3;
                    String string;
                    PlSqlError plSqlError = HighlightEditorPlugin.this._errors[i];
                    int n2 = plSqlError._line;
                    if (n2 < 0) {
                        n2 = 0;
                    } else if (n2 >= n) {
                        n2 = n - 1;
                    }
                    String string2 = plSqlError._message;
                    if (plSqlError._isError) {
                        string = "PLSQLERROR";
                        highlightStyle3 = highlightStyle;
                    } else {
                        string = "PLSQLWARNING";
                        highlightStyle3 = highlightStyle2;
                    }
                    try {
                        HighlightMark highlightMark;
                        int n3;
                        int n4;
                        int n5 = HighlightEditorPlugin.this._editorPane.getLineStartOffset(n2);
                        int n6 = HighlightEditorPlugin.this._editorPane.getLineEndOffset(n2);
                        if (string2.startsWith("PLS-00103:")) {
                            n4 = plSqlError._offset;
                            n3 = n5 + n4;
                            n2 = HighlightEditorPlugin.this._editorPane.getLineFromOffset(n3);
                            highlightLayer.addHighlight(highlightStyle3, n3, n3 + 1);
                            highlightMark = new HighlightMark(n3, n3, string2);
                            fileOverviewMargin.addMark(string, n2, (FileOverviewMark)highlightMark);
                            plSqlError.setHighlights(n3, n3);
                            continue;
                        }
                        n4 = n5 + plSqlError._offset;
                        n3 = n6 - 1;
                        highlightLayer.addHighlight(highlightStyle3, n4, n3);
                        highlightMark = new HighlightMark(n4, n4, string2);
                        fileOverviewMargin.addMark(string, n2, (FileOverviewMark)highlightMark);
                        plSqlError.setHighlights(n4, n3);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        swingWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlSqlError[] getErrors() {
        ArrayList<PlSqlError> arrayList = new ArrayList<PlSqlError>();
        PlSqlNode plSqlNode = this.getNode();
        URL uRL = plSqlNode.getURL();
        String string = DBURLFormatHelper.getBaseType(uRL);
        if (string == null) {
            return new PlSqlError[0];
        }
        String string2 = plSqlNode.getConnectionName();
        if (string2 == null) {
            return new PlSqlError[0];
        }
        ResultSetWrapper resultSetWrapper = null;
        try {
            boolean bl;
            Connection connection = Connections.getInstance().getConnection(string2);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(string);
            arrayList2.add(plSqlNode.getName());
            if (!Connections.getInstance().lock(string2)) {
                PlSqlError[] plSqlErrorArray = new PlSqlError[]{};
                return plSqlErrorArray;
            }
            resultSetWrapper = DBUtil.getInstance((String)string2).executeQuery(this.getSQL(connection), arrayList2);
            if (resultSetWrapper == null) {
                PlSqlError[] plSqlErrorArray = new PlSqlError[]{};
                return plSqlErrorArray;
            }
            ResultSet resultSet = resultSetWrapper.getResultSet();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            boolean bl2 = bl = resultSetMetaData.getColumnCount() == 4;
            while (resultSet.next()) {
                if (plSqlNode.getParser().text == null) {
                    PlSqlError[] plSqlErrorArray = new PlSqlError[]{};
                    return plSqlErrorArray;
                }
                int n = resultSet.getInt(1) - 1 + plSqlNode.offset(string);
                int n2 = resultSet.getInt(2) - 1;
                String string3 = resultSet.getString(3);
                boolean bl3 = bl ? "ERROR".equals(resultSet.getString(4)) : true;
                PlSqlError plSqlError = new PlSqlError(n, n2, string3, bl3);
                arrayList.add(plSqlError);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (DBException dBException) {
        }
        finally {
            Connections.getInstance().unlock(string2);
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
        }
        return arrayList.toArray(new PlSqlError[arrayList.size()]);
    }

    private String getSQL(Connection connection) throws SQLException {
        if (connection.getMetaData().getDatabaseMajorVersion() > 9) {
            return "SELECT LINE,POSITION,TEXT,ATTRIBUTE FROM USER_ERRORS WHERE TYPE=? AND NAME=? ";
        }
        return "SELECT LINE,POSITION,TEXT FROM USER_ERRORS WHERE TYPE=? AND NAME=? ";
    }

    @Override
    public void stateChanged(BackgroundParser backgroundParser) {
        List<LexerToken> list = backgroundParser.src;
        int n = this._editorPane.getCaretPosition();
        int n2 = LexerToken.scanner2parserOffset(list, (int)n);
        this.ranges = new TreeSet<Range>();
        LazyNode lazyNode = backgroundParser.output;
        if (lazyNode != null) {
            for (ParseNode parseNode : lazyNode.ancestors(n2)) {
                int n3;
                if (!(parseNode instanceof LazyNode)) continue;
                LazyNode lazyNode2 = (LazyNode)parseNode;
                if (lazyNode2.to - lazyNode2.from < 4 || !lazyNode2.isDDL() && !lazyNode2.isDML() && !lazyNode2.isProcedure() && !lazyNode2.isStmt(lazyNode) && lazyNode2 != lazyNode || lazyNode2 == lazyNode && lazyNode2.from + 1000 < lazyNode2.to || lazyNode2.from + 2000 < lazyNode2.to) continue;
                LinkedList linkedList = lazyNode2.getSrcFragment();
                SqlEarley sqlEarley = SqlEarley.getInstance();
                Matrix matrix = new Matrix((Parser)sqlEarley);
                sqlEarley.parse((List)linkedList, matrix);
                LexerToken lexerToken = list.get(parseNode.from);
                SyntaxError syntaxError = SyntaxError.checkSyntax((String)backgroundParser.text.substring(lexerToken.begin, list.get((int)(parseNode.to - 1)).end), (String[])new String[]{"sql_statements", "subprg_body"}, (List)linkedList, (Earley)sqlEarley, (Matrix)matrix);
                if (syntaxError == null) break;
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (String string : syntaxError.suggestions) {
                    int n4;
                    int n5 = -1;
                    int n6 = Integer.MAX_VALUE;
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        n4 = (Integer)iterator.next();
                        int n7 = HarvestDoc.getFrequncies()[n4];
                        if (n7 >= n6) continue;
                        n5 = n4;
                        n6 = n7;
                    }
                    int n8 = (Integer)sqlEarley.symbolIndexes.get(string);
                    n4 = HarvestDoc.getFrequncies()[n8];
                    if (hashSet.size() == 3) {
                        if (n6 >= n4) continue;
                        hashSet.remove(n5);
                        hashSet.add(n8);
                        continue;
                    }
                    hashSet.add(n8);
                }
                StringBuilder stringBuilder = new StringBuilder("<html><font color=magenta>Syntax error, expected: </font><br>");
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    String string;
                    n3 = (Integer)iterator.next();
                    string = sqlEarley.allSymbols[n3];
                    if (string.charAt(0) == '\'') {
                        string = "<font color=blue><b>" + string.substring(1, string.length() - 1) + "</b></font>";
                    }
                    stringBuilder.append(string + "<br>");
                }
                int n9 = lexerToken.begin + syntaxError.end;
                n3 = n9 + 3;
                if (backgroundParser.text.length() < n3) {
                    n3 = backgroundParser.text.length();
                }
                if (0 < n9 && n3 < n9 + 3) {
                    --n9;
                }
                this.ranges.add(new Range(n9, n3, stringBuilder.toString()));
                break;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HighlightLayer highlightLayer = HighlightEditorPlugin.this.getHighlightLayer();
                if (highlightLayer == null) {
                    return;
                }
                for (Object object : HighlightEditorPlugin.this.dynHighlights) {
                    highlightLayer.removeHighlight(object);
                }
                HighlightEditorPlugin.this.dynHighlights.clear();
                for (Object object : HighlightEditorPlugin.this.ranges) {
                    HighlightEditorPlugin.this.dynHighlights.add(highlightLayer.addHighlight(HighlightAddin.getDynamicHighlightStyle(), object.from, object.to));
                }
            }
        });
    }

    static /* synthetic */ PlSqlError[] access$202(HighlightEditorPlugin highlightEditorPlugin, PlSqlError[] plSqlErrorArray) {
        highlightEditorPlugin._errors = plSqlErrorArray;
        return plSqlErrorArray;
    }

    static final class Range {
        int from;
        int to;
        String msg;

        Range(int n, int n2, String string) {
            this.from = n;
            this.to = n2;
            this.msg = string;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int hashCode() {
            throw new RuntimeException("hashCode inconsistent with equals");
        }

        public int compareTo(Object object) {
            Range range = (Range)object;
            if (this.from != range.from) {
                return this.from - range.from;
            }
            return this.to - range.to;
        }
    }

    private static class PlSqlError {
        private int _line;
        private int _offset;
        private String _message;
        private boolean _isError;
        private int _highlightedFrom;
        private int _highlightedTo;

        public PlSqlError(int n, int n2, String string, boolean bl) {
            this._line = n;
            this._offset = n2;
            this._message = string;
            this._isError = bl;
        }

        void setHighlights(int n, int n2) {
            this._highlightedFrom = n;
            this._highlightedTo = n2;
        }

        boolean isInHighlight(int n) {
            return this._highlightedFrom <= n && n <= this._highlightedTo;
        }
    }
}

