/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.phighlight.TooltipPlugin;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.model.Node;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.highlight.HighlightStyle;

public class HighlightAddin
implements Addin {
    private static HighlightStyle _errorHighlightStyle;
    private static HighlightStyle _warningHighlightStyle;
    private static HighlightStyle _dynamicHighlightStyle;
    static final String ERROR_CATEGORY = "PLSQLERROR";
    static final String WARNING_CATEGORY = "PLSQLWARNING";
    static final String DYNAMIC_CATEGORY = "SQL&PLSQL";
    public TooltipPlugin ttPlugin;

    public void initialize() {
        _errorHighlightStyle = CodeEditor.createHighlightStyle((String)(this.getClass().getName() + "-E"), (String)"PLSQL Errors", (int)50, null, null, (int)0, (int)4, (Color)Color.RED);
        _warningHighlightStyle = CodeEditor.createHighlightStyle((String)(this.getClass().getName() + "-W"), (String)"PLSQL Warnings", (int)50, null, null, (int)0, (int)4, (Color)new Color(240, 240, 0));
        _dynamicHighlightStyle = CodeEditor.createHighlightStyle((String)(this.getClass().getName() + "-D"), (String)"SQL&PLSQL Syntax Errors", (int)50, null, null, (int)0, (int)4, (Color)Color.PINK);
        FileOverviewMargin.setMarkColor((String)ERROR_CATEGORY, (HighlightStyle)_errorHighlightStyle);
        FileOverviewMargin.setMarkColor((String)WARNING_CATEGORY, (HighlightStyle)_warningHighlightStyle);
        FileOverviewMargin.setMarkColor((String)WARNING_CATEGORY, (HighlightStyle)_dynamicHighlightStyle);
        CodeEditor.registerFactory((EditorPluginsFactory)new EditorPluginsFactory(){

            public List createPlugins(Context context) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Node node = context.getNode();
                if (node instanceof PlSqlNode) {
                    HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin();
                    arrayList.add(highlightEditorPlugin);
                    HighlightAddin.this.ttPlugin = new TooltipPlugin();
                    arrayList.add(HighlightAddin.this.ttPlugin);
                    HighlightAddin.this.ttPlugin.addTooltip(highlightEditorPlugin);
                }
                return arrayList;
            }
        });
    }

    public static HighlightStyle getErrorHighlightStyle() {
        return _errorHighlightStyle;
    }

    public static HighlightStyle getWarningHighlightStyle() {
        return _warningHighlightStyle;
    }

    public static HighlightStyle getDynamicHighlightStyle() {
        return _dynamicHighlightStyle;
    }
}

