/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBTypeOwnerInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.model.DatabaseItem;
import oracle.dbtools.raptor.navigator.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.model.ObjectType;
import oracle.dbtools.raptor.navigator.xml.XmlObjectFactory;
import oracle.javatools.util.ModelUtil;

abstract class XmlTypeOwnerInstance
implements DBTypeOwnerInstance {
    private DatabaseItem m_impl;
    private XmlObjectFactory m_factory;
    private Map<String, Object> m_props = new HashMap<String, Object>();
    private List<DBFolderInstance> m_folders;
    private List<CategoryInstance> m_categories;

    XmlTypeOwnerInstance(XmlObjectFactory xmlObjectFactory, DatabaseItem databaseItem) {
        this.m_factory = xmlObjectFactory;
        this.m_impl = databaseItem;
    }

    @Override
    public DatabaseItem getDescriptor() {
        return this.m_impl;
    }

    @Override
    public Object getProperty(String string) {
        return this.m_props.get(string);
    }

    protected final String getStringProperty(String string) {
        return (String)this.getProperty(string);
    }

    protected final boolean getBooleanProperty(String string) {
        Object object = this.getProperty(string);
        return object instanceof Boolean ? (Boolean)object : false;
    }

    @Override
    public void setProperty(String string, Object object) {
        this.m_props.put(string, object);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.m_props.keySet();
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.m_factory;
    }

    protected String getCategory() {
        return null;
    }

    @Override
    public List<DBFolderInstance> listTypeFolders() {
        if (this.m_folders == null) {
            boolean bl = this.getBooleanProperty("NONTREE_UI");
            this.m_folders = new ArrayList<DBFolderInstance>();
            for (ObjectType objectType : this.m_factory.listTypes(this.getCategory())) {
                if (bl && objectType.isTreeOnly()) continue;
                String string = objectType.getType();
                for (DatabaseFolder databaseFolder : objectType.getFolders()) {
                    DBFolderInstance dBFolderInstance;
                    if (!bl && databaseFolder.isCurrentSchemaOnly() && !ModelUtil.areEqual((Object)this.getProperty("SCHEMA"), (Object)this.m_factory.getSchema()) || (dBFolderInstance = this.m_factory.createFolderInstance(string, databaseFolder)) == null) continue;
                    for (String string2 : this.getPropertyKeys()) {
                        dBFolderInstance.setProperty(string2, this.getProperty(string2));
                    }
                    this.m_folders.add(dBFolderInstance);
                }
            }
        }
        return this.m_folders;
    }

    @Override
    public List<CategoryInstance> listCategories() {
        if (this.m_categories == null) {
            this.m_categories = new ArrayList<CategoryInstance>();
            for (ObjectCategory objectCategory : this.m_factory.listCategories(this.getCategory())) {
                CategoryInstance categoryInstance = this.m_factory.createCategoryInstance(objectCategory);
                if (categoryInstance == null) continue;
                for (String string : this.getPropertyKeys()) {
                    categoryInstance.setProperty(string, this.getProperty(string));
                }
                this.m_categories.add(categoryInstance);
            }
        }
        return this.m_categories;
    }
}

